/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.domain;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.egf.common.helper.URIHelper;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.domain.DiagnosticResourceException;
import org.eclipse.egf.core.domain.EGFResourceSet;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointDelta;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointListener;
import org.eclipse.egf.core.workspace.EGFWorkspaceSynchronizer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;

public final class EGFResourceLoadedListener
implements EGFWorkspaceSynchronizer.Delegate {
    private static volatile EGFResourceLoadedListener __resourceLoadedListener;
    private static volatile ResourceManager __resourceManager;
    private static Object __lockResourceManager;
    private static Object __lockResourceLoadedListener;
    protected IPlatformExtensionPointListener _platformListener = new IPlatformExtensionPointListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void platformExtensionPointChanged(IPlatformExtensionPointDelta delta) {
            Object object = __lockResourceLoadedListener;
            synchronized (object) {
                Resource resource;
                IPlatformFcore fcore;
                TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID);
                UniqueEList deltaChangedFcores = new UniqueEList();
                HashMap<Resource, IPlatformFcore> deltaRemovedFcores = new HashMap<Resource, IPlatformFcore>();
                IPlatformFcore[] iPlatformFcoreArray = (IPlatformFcore[])delta.getRemovedPlatformExtensionPoints(IPlatformFcore.class);
                int n = iPlatformFcoreArray.length;
                int n2 = 0;
                while (n2 < n) {
                    fcore = iPlatformFcoreArray[n2];
                    resource = editingDomain.getResourceSet().getResource(fcore.getURI(), false);
                    if (resource != null) {
                        deltaRemovedFcores.put(resource, fcore);
                    }
                    ++n2;
                }
                iPlatformFcoreArray = (IPlatformFcore[])delta.getAddedPlatformExtensionPoints(IPlatformFcore.class);
                n = iPlatformFcoreArray.length;
                n2 = 0;
                while (n2 < n) {
                    block17: {
                        block18: {
                            fcore = iPlatformFcoreArray[n2];
                            resource = editingDomain.getResourceSet().getResource(fcore.getURI(), false);
                            if (resource == null) break block17;
                            if (resource.getContents().size() != 0 || resource.getErrors().isEmpty()) break block18;
                            IPlatformFcore deletedFcore = (IPlatformFcore)deltaRemovedFcores.get(resource);
                            if (deletedFcore != null) {
                                deltaRemovedFcores.remove(resource);
                            }
                            resource.unload();
                            resource.getResourceSet().getResources().remove((Object)resource);
                            if (EGFCorePlugin.getDefault().isDebugging()) {
                                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"EGFResourceLoadedListener.platformExtensionPointChanged(...) - discard loaded empty resource with errors ''{0}''", (Object)fcore.toString()));
                            }
                            if ((resource = editingDomain.getResourceSet().getResource(fcore.getURI(), true)) == null) break block17;
                            if (deletedFcore != null) {
                                deltaRemovedFcores.put(resource, deletedFcore);
                            }
                        }
                        if (deltaRemovedFcores.remove(resource) != null) {
                            deltaChangedFcores.add(resource);
                        }
                    }
                    ++n2;
                }
                if (!deltaRemovedFcores.isEmpty()) {
                    for (Resource resource2 : deltaRemovedFcores.keySet()) {
                        EGFResourceLoadedListener.getResourceManager().removeResource(resource2);
                    }
                }
                if (!deltaChangedFcores.isEmpty()) {
                    for (Resource resource2 : deltaChangedFcores) {
                        EGFResourceLoadedListener.getResourceManager().reloadResource(resource2);
                    }
                }
            }
        }
    };
    private TransactionalEditingDomain _editingDomain;

    static {
        __lockResourceManager = new Object();
        __lockResourceLoadedListener = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceManager getResourceManager() {
        if (__resourceManager == null) {
            Object object = __lockResourceManager;
            synchronized (object) {
                if (__resourceManager == null) {
                    __resourceManager = new ResourceManager();
                }
            }
        }
        return __resourceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EGFResourceLoadedListener getResourceLoadedListener() {
        if (__resourceLoadedListener == null) {
            Object object = __lockResourceLoadedListener;
            synchronized (object) {
                if (__resourceLoadedListener == null) {
                    __resourceLoadedListener = new EGFResourceLoadedListener();
                }
            }
        }
        return __resourceLoadedListener;
    }

    private EGFResourceLoadedListener() {
        EGFPlatformPlugin.getPlatformManager().addPlatformExtensionPointListener(this._platformListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionalEditingDomain getEditingDomain() {
        Object object = __lockResourceLoadedListener;
        synchronized (object) {
            if (this._editingDomain == null) {
                this._editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID);
            }
            return this._editingDomain;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleResourcePersisted(Resource resource) {
        Object object = __lockResourceLoadedListener;
        synchronized (object) {
            for (ResourceListener resourceListener : EGFResourceLoadedListener.getResourceManager()._listeners) {
                resourceListener.internalUpdate(resource);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleResourceMoved(Resource movedResource, URI newURI) {
        Object object = __lockResourceLoadedListener;
        synchronized (object) {
            boolean isFcore = "fcore".equals(movedResource.getURI().fileExtension());
            boolean isMovedToFcore = "fcore".equals(newURI.fileExtension());
            if (isFcore && isMovedToFcore || !isFcore) {
                Resource resource = this.getEditingDomain().getResourceSet().getResource(movedResource.getURI(), false);
                if (resource != null || this.getEditingDomain().getResourceSet().getResource(newURI, false) != null) {
                    EGFResourceLoadedListener.getResourceManager().movedResource(resource, newURI);
                }
            } else {
                return this.handleResourceDeleted(movedResource);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleResourceDeleted(Resource deletedResource) {
        Object object = __lockResourceLoadedListener;
        synchronized (object) {
            IPlatformFcore fcore = EGFCorePlugin.getPlatformFcore(deletedResource);
            if (fcore == null) {
                EGFResourceLoadedListener.getResourceManager().removeResource(deletedResource);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleResourceChanged(Resource changedResource) {
        Object object = __lockResourceLoadedListener;
        synchronized (object) {
            block11: {
                boolean isDirty;
                boolean hasSavedResource;
                block10: {
                    List users;
                    block9: {
                        users = (List)EGFResourceLoadedListener.getResourceManager()._observers.get(changedResource);
                        if (users != null) break block9;
                        EGFResourceLoadedListener.getResourceManager().reloadResource(changedResource);
                        return true;
                    }
                    hasSavedResource = false;
                    isDirty = false;
                    for (ResourceUser user : users) {
                        hasSavedResource |= user.userHasSavedResource();
                        isDirty |= user.isDirty();
                    }
                    if (hasSavedResource || isDirty) break block10;
                    EGFResourceLoadedListener.getResourceManager().reloadResource(changedResource);
                    return true;
                }
                if (hasSavedResource || !isDirty) break block11;
                for (ResourceListener resourceListener : EGFResourceLoadedListener.getResourceManager()._listeners) {
                    resourceListener.externalUpdate(changedResource);
                }
                return true;
            }
            for (ResourceListener resourceListener : EGFResourceLoadedListener.getResourceManager()._listeners) {
                resourceListener.internalUpdate(changedResource);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = __lockResourceLoadedListener;
        synchronized (object) {
            EGFPlatformPlugin.getPlatformManager().removePlatformExtensionPointListener(this._platformListener);
            EGFResourceLoadedListener.getResourceManager().dispose();
            __resourceManager = null;
        }
    }

    public static interface ResourceListener {
        public void resourceDeleted(Resource var1);

        public void resourceMoved(Resource var1, URI var2);

        public void resourceReloaded(Resource var1);

        public void externalUpdate(Resource var1);

        public void internalUpdate(Resource var1);
    }

    public static class ResourceManager {
        private final List<ResourceListener> _listeners = new ArrayList<ResourceListener>();
        private final Map<Resource, List<ResourceUser>> _observers = new HashMap<Resource, List<ResourceUser>>();

        protected void dispose() {
            this._listeners.clear();
            this._observers.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addObserver(ResourceUser resourceUser) {
            Object object = __lockResourceManager;
            synchronized (object) {
                Resource resource = resourceUser.getResource();
                List<ResourceUser> list = this._observers.get(resource);
                if (list == null) {
                    list = new ArrayList<ResourceUser>();
                    this._observers.put(resource, list);
                }
                list.add(resourceUser);
                this._listeners.add(resourceUser.getListener());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeObserver(ResourceUser resourceUser) {
            Object object = __lockResourceManager;
            synchronized (object) {
                Resource resource = resourceUser.getResource();
                List<ResourceUser> list = this._observers.get(resource);
                if (list == null) {
                    return;
                }
                list.remove(resourceUser);
                if (list.isEmpty()) {
                    try {
                        resource.unload();
                        this._observers.remove(resource);
                        if (!this.noMoreObserver()) {
                            resource.load(Collections.EMPTY_MAP);
                        }
                    }
                    catch (IOException ioe) {
                        resource.getErrors().add((Object)new DiagnosticResourceException(resource, ioe));
                    }
                }
                this._listeners.remove(resourceUser.getListener());
                if (this.noMoreObserver()) {
                    this.clear();
                }
            }
        }

        private void clear() {
            final TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID);
            try {
                editingDomain.runExclusive(new Runnable(){

                    public void run() {
                        EGFResourceSet resourceSet = (EGFResourceSet)editingDomain.getResourceSet();
                        Iterator it = resourceSet.getResources().iterator();
                        while (it.hasNext()) {
                            Resource resource = (Resource)it.next();
                            resource.unload();
                            it.remove();
                        }
                    }
                });
                if (EGFCorePlugin.getDefault().isDebugging()) {
                    EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"''{0}'' _ clear", (Object)EGFCorePlugin.EDITING_DOMAIN_ID));
                }
            }
            catch (InterruptedException e) {
                EGFCorePlugin.getDefault().logError(e);
            }
        }

        private boolean noMoreObserver() {
            for (List<ResourceUser> users : this._observers.values()) {
                if (users.isEmpty()) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeResource(Resource resource) {
            if (resource == null) {
                throw new IllegalArgumentException();
            }
            Object object = __lockResourceManager;
            synchronized (object) {
                Iterator<ResourceUser> iterator;
                boolean isDirty = false;
                List<ResourceUser> users = this._observers.get(resource);
                if (users != null && (iterator = users.iterator()).hasNext()) {
                    ResourceUser user = iterator.next();
                    isDirty = user.isDirty();
                }
                for (ResourceListener resourceListener : this._listeners) {
                    resourceListener.resourceDeleted(resource);
                }
                if (!isDirty) {
                    resource.unload();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reloadResource(Resource resource) {
            if (resource == null) {
                throw new IllegalArgumentException();
            }
            Object object = __lockResourceManager;
            synchronized (object) {
                try {
                    resource.unload();
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException ioe) {
                    resource.getErrors().add((Object)new DiagnosticResourceException(resource, ioe));
                }
                for (ResourceListener resourceListener : this._listeners) {
                    resourceListener.resourceReloaded(resource);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void movedResource(Resource movedResource, URI newURI) {
            if (newURI == null) {
                throw new IllegalArgumentException();
            }
            TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID);
            Object object = __lockResourceManager;
            synchronized (object) {
                EGFResourceSet resourceSet = (EGFResourceSet)editingDomain.getResourceSet();
                Resource resource = resourceSet.getResource(newURI, false);
                if (resource != null && resource.getContents().size() == 0 && !resource.getErrors().isEmpty()) {
                    resource.unload();
                    resourceSet.getResources().remove((Object)resource);
                    if (EGFCorePlugin.getDefault().isDebugging()) {
                        EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"EGFResourceLoadedListener.movedResource(...) - discard loaded empty resource with errors ''{0}''", (Object)URIHelper.toString((URI)newURI)));
                    }
                    movedResource = editingDomain.getResourceSet().getResource(newURI, true);
                } else if (movedResource != null) {
                    movedResource.setURI(newURI);
                }
                if (movedResource != null) {
                    URI oldURI = movedResource.getURI();
                    for (ResourceListener resourceListener : this._listeners) {
                        resourceListener.resourceMoved(movedResource, oldURI);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean resourceHasBeenExternallyChanged(Resource resource) {
            if (resource == null) {
                throw new IllegalArgumentException();
            }
            Object object = __lockResourceManager;
            synchronized (object) {
                List<ResourceUser> users;
                block6: {
                    users = this._observers.get(resource);
                    if (users != null) break block6;
                    return false;
                }
                boolean resourceHasBeenExternallyChanged = false;
                Iterator<ResourceUser> iterator = users.iterator();
                if (iterator.hasNext()) {
                    ResourceUser user = iterator.next();
                    resourceHasBeenExternallyChanged = user.resourceHasBeenExternallyChanged();
                }
                return resourceHasBeenExternallyChanged;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void populateUndoContext(IOperationHistory operationHistory, ObjectUndoContext undoContext, Resource resource) {
            if (resource == null || undoContext == null) {
                throw new IllegalArgumentException();
            }
            Object object = __lockResourceManager;
            synchronized (object) {
                List<ResourceUser> users = this._observers.get(resource);
                if (users == null) {
                    return;
                }
                ObjectUndoContext innerUndoContext = null;
                for (ResourceUser user : users) {
                    if (user.getUndoContext() == undoContext) continue;
                    innerUndoContext = user.getUndoContext();
                    break;
                }
                if (innerUndoContext != null) {
                    IUndoableOperation operation;
                    IUndoableOperation[] iUndoableOperationArray = operationHistory.getUndoHistory(innerUndoContext);
                    int n = iUndoableOperationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        operation = iUndoableOperationArray[n2];
                        operation.addContext((IUndoContext)undoContext);
                        ++n2;
                    }
                    iUndoableOperationArray = operationHistory.getRedoHistory((IUndoContext)innerUndoContext);
                    n = iUndoableOperationArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        operation = iUndoableOperationArray[n2];
                        operation.addContext((IUndoContext)undoContext);
                        ++n2;
                    }
                }
            }
        }
    }

    public static interface ResourceUser {
        public Resource getResource();

        public ResourceListener getListener();

        public boolean isDirty();

        public boolean userHasSavedResource();

        public boolean resourceHasBeenExternallyChanged();

        public IOperationHistory getOperationHistory();

        public ObjectUndoContext getUndoContext();
    }
}

