/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.session;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.common.helper.JavaHelper;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.l10n.EGFCoreMessages;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectBundleSession {
    private static final String EGF_TARGET_BUNDLE_PRIORITY = "egf.target.bundle.priority";
    public static String PROJECT_BUNDLE_SESSION = "org.eclipse.egf.core.project.bundle.session";
    private BundleContext _context;
    private Map<String, Bundle> _projectBundles = new HashMap<String, Bundle>();
    private List<String> _uninstalled = new UniqueEList();
    private Boolean targetBundlePriority;

    public static String getLocation(IPluginModelBase base) throws CoreException {
        IResource resource = base.getUnderlyingResource();
        if (resource == null) {
            return null;
        }
        String location = null;
        try {
            location = "reference:" + URLDecoder.decode(resource.getProject().getLocationURI().toURL().toExternalForm(), System.getProperty("file.encoding"));
        }
        catch (Throwable t) {
            throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_URLFailure, (Object)resource.getProject().getName()), t));
        }
        return location;
    }

    public ProjectBundleSession(BundleContext context) {
        Assert.isNotNull((Object)context);
        this._context = context;
    }

    private Bundle installBundle(IPluginModelBase base) throws CoreException {
        if (ProjectBundleSession.getLocation(base) == null) {
            return null;
        }
        List<IPluginModelBase> workspaceModels = this.getWorkspaceModelDependencies(base);
        this.uninstallTargetBundle(workspaceModels);
        UniqueEList bundles = new UniqueEList();
        for (IPluginModelBase workspaceModel : workspaceModels) {
            if (this._projectBundles.get(ProjectBundleSession.getLocation(workspaceModel)) != null) continue;
            String location = ProjectBundleSession.getLocation(workspaceModel);
            Bundle bundle = this.installBundle(location);
            IProject project = workspaceModel.getUnderlyingResource().getProject();
            this.addOutputFoldersToBundleClasspath(project, bundle);
            bundles.add(bundle);
            this._projectBundles.put(location, bundle);
            if (!EGFCorePlugin.getDefault().isDebugging()) continue;
            EGFCorePlugin.getDefault().logInfo(NLS.bind((String)"Workspace Bundle ''{0}'' is installed.", (Object)bundle.getSymbolicName()));
        }
        if (!bundles.isEmpty()) {
            this.refreshPackages(bundles.toArray(new Bundle[bundles.size()]));
        }
        return Platform.getBundle((String)BundleHelper.getBundleId((IPluginModelBase)base));
    }

    private void uninstallTargetBundle(List<IPluginModelBase> workspaceModels) throws CoreException {
        UniqueEList bundles = new UniqueEList();
        for (IPluginModelBase workspaceModel : workspaceModels) {
            Bundle bundle;
            if (this._projectBundles.get(ProjectBundleSession.getLocation(workspaceModel)) != null || (bundle = Platform.getBundle((String)BundleHelper.getBundleId((IPluginModelBase)workspaceModel))) == null) continue;
            if (bundle.getState() == 2 || bundle.getState() == 4 || bundle.getState() == 8 || bundle.getState() == 16 || bundle.getState() == 32) {
                this.uninstallBundle(bundle);
            }
            bundles.add(bundle);
            this._uninstalled.add(bundle.getLocation());
            if (!EGFCorePlugin.getDefault().isDebugging()) continue;
            EGFCorePlugin.getDefault().logInfo(NLS.bind((String)"Target Bundle ''{0}'' is uninstalled.", (Object)bundle.getSymbolicName()));
        }
        if (!bundles.isEmpty()) {
            this.refreshPackages(bundles.toArray(new Bundle[bundles.size()]));
        }
    }

    private List<IPluginModelBase> getWorkspaceModelDependencies(IPluginModelBase base) throws CoreException {
        IPluginModelBase workspaceModel;
        int n;
        int n2;
        IPluginModelBase[] iPluginModelBaseArray;
        UniqueEList dependencies = new UniqueEList();
        dependencies.add(base);
        BundleDescription description = base.getBundleDescription();
        if (description == null) {
            return dependencies;
        }
        BundleSpecification[] bundleSpecificationArray = description.getRequiredBundles();
        int n3 = bundleSpecificationArray.length;
        int n4 = 0;
        while (n4 < n3) {
            BundleSpecification requiredBundle = bundleSpecificationArray[n4];
            iPluginModelBaseArray = PluginRegistry.getWorkspaceModels();
            n2 = iPluginModelBaseArray.length;
            n = 0;
            while (n < n2) {
                workspaceModel = iPluginModelBaseArray[n];
                if (requiredBundle.isSatisfiedBy((BaseDescription)workspaceModel.getBundleDescription())) {
                    dependencies.addAll(this.getWorkspaceModelDependencies(workspaceModel));
                    break;
                }
                ++n;
            }
            ++n4;
        }
        bundleSpecificationArray = description.getImportPackages();
        n3 = bundleSpecificationArray.length;
        n4 = 0;
        while (n4 < n3) {
            BundleSpecification importPackage = bundleSpecificationArray[n4];
            iPluginModelBaseArray = PluginRegistry.getWorkspaceModels();
            n2 = iPluginModelBaseArray.length;
            n = 0;
            while (n < n2) {
                workspaceModel = iPluginModelBaseArray[n];
                ExportPackageDescription[] exportPackageDescriptionArray = workspaceModel.getBundleDescription().getExportPackages();
                int n5 = exportPackageDescriptionArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    ExportPackageDescription export = exportPackageDescriptionArray[n6];
                    if (importPackage.isSatisfiedBy((BaseDescription)export)) {
                        dependencies.addAll(this.getWorkspaceModelDependencies(workspaceModel));
                        break;
                    }
                    ++n6;
                }
                ++n;
            }
            ++n4;
        }
        if (this.isTargetBundlePriority()) {
            for (IPluginModelBase iPluginModelBase : new ArrayList(dependencies)) {
                if (Platform.getBundle((String)iPluginModelBase.getBundleDescription().getSymbolicName()) == null) continue;
                dependencies.remove(iPluginModelBase);
            }
        }
        return dependencies;
    }

    private Bundle installBundle(String location) throws CoreException {
        Bundle bundle = null;
        try {
            bundle = this._context.installBundle(location);
        }
        catch (Throwable t) {
            throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_InstallationFailure, (Object)location), t));
        }
        if (bundle == null) {
            throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_InstallationFailure, (Object)location), null));
        }
        int state = bundle.getState();
        if (state != 2) {
            throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_IllegalBundleState, (Object)bundle, (Object)state), null));
        }
        return bundle;
    }

    private void addOutputFoldersToBundleClasspath(IProject project, Bundle bundle) throws CoreException {
        List outputFolders = JavaHelper.getStringOutputFolders((IJavaProject)JavaCore.create((IProject)project));
        BaseData bundleData = (BaseData)((AbstractBundle)bundle).getBundleData();
        StringBuilder classpath = new StringBuilder();
        if (outputFolders.size() == 0) {
            classpath.append(".");
        } else {
            Iterator it = outputFolders.iterator();
            while (it.hasNext()) {
                if (classpath.length() > 0) {
                    classpath.append(",");
                }
                classpath.append((String)it.next());
            }
        }
        bundleData.setClassPathString(classpath.toString());
    }

    public Bundle getBundle(String id) throws CoreException {
        IPluginModelBase model = PluginRegistry.findModel((String)id);
        if (model == null) {
            return null;
        }
        if (model.getUnderlyingResource() == null || this.isTargetBundlePriority()) {
            return Platform.getBundle((String)BundleHelper.getBundleId((IPluginModelBase)model));
        }
        String location = ProjectBundleSession.getLocation(model);
        if (location == null) {
            return null;
        }
        Bundle bundle = this._projectBundles.get(location);
        if (bundle == null) {
            return this.installBundle(model);
        }
        return bundle;
    }

    public Bundle getBundle(IProject project) throws CoreException {
        Bundle bundle;
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        if (this.isTargetBundlePriority() && (bundle = Platform.getBundle((String)BundleHelper.getBundleId((IPluginModelBase)model))) != null) {
            return bundle;
        }
        if (model == null) {
            return null;
        }
        String location = ProjectBundleSession.getLocation(model);
        if (location == null) {
            return null;
        }
        Bundle bundle2 = this._projectBundles.get(location);
        if (bundle2 == null) {
            bundle2 = this.installBundle(model);
        }
        return bundle2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void refreshPackages(Bundle[] bundles) throws CoreException {
        ServiceReference packageAdminReference = this._context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminReference != null) {
            packageAdmin = (PackageAdmin)this._context.getService(packageAdminReference);
        }
        if (packageAdmin == null) return;
        final boolean[] flag = new boolean[1];
        final Throwable[] throwable = new Throwable[1];
        FrameworkListener listener = new FrameworkListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() == 4 || event.getType() == 2) {
                    if (event.getType() == 2) {
                        throwable[0] = event.getThrowable();
                    }
                    boolean[] blArray = flag;
                    synchronized (flag) {
                        flag[0] = true;
                        flag.notifyAll();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                    }
                } else if (event.getType() == 16 && event.getThrowable() != null) {
                    EGFCorePlugin.getDefault().logWarning(event.getThrowable());
                }
            }
        };
        this._context.addFrameworkListener(listener);
        packageAdmin.refreshPackages(bundles);
        boolean[] blArray = flag;
        synchronized (flag) {
            while (!flag[0]) {
                try {
                    flag.wait();
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            this._context.removeFrameworkListener(listener);
            this._context.ungetService(packageAdminReference);
            if (throwable[0] == null) return;
            throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, EGFCoreMessages.ProjectBundleSession_PackageRefreshFailure, throwable[0]));
        }
    }

    public void dispose() throws CoreException {
        UniqueEList bundlesToBeRefreshed = new UniqueEList(this._uninstalled.size());
        if (!(!EGFCorePlugin.getDefault().isDebugging() || this._projectBundles.isEmpty() && this._uninstalled.isEmpty())) {
            EGFCorePlugin.getDefault().logInfo("Dispose ProjectBundleSession.");
        }
        if (!this._projectBundles.isEmpty()) {
            for (Bundle bundle : this._projectBundles.values()) {
                this.uninstallBundle(bundle);
                if (!EGFCorePlugin.getDefault().isDebugging()) continue;
                EGFCorePlugin.getDefault().logInfo(NLS.bind((String)"Workspace Bundle ''{0}'' is uninstalled.", (Object)bundle.getSymbolicName()), 1);
            }
            this.refreshPackages(this._projectBundles.values().toArray(new Bundle[this._projectBundles.values().size()]));
        }
        if (!this._uninstalled.isEmpty()) {
            for (String location : this._uninstalled) {
                Bundle bundle = this.installBundle(location);
                bundlesToBeRefreshed.add(bundle);
                if (!EGFCorePlugin.getDefault().isDebugging()) continue;
                EGFCorePlugin.getDefault().logInfo(NLS.bind((String)"Target Bundle ''{0}'' is installed.", (Object)bundle.getSymbolicName()), 1);
            }
            this.refreshPackages(bundlesToBeRefreshed.toArray(new Bundle[bundlesToBeRefreshed.size()]));
        }
        this._projectBundles.clear();
        this._uninstalled.clear();
    }

    private void uninstallBundle(Bundle bundle) throws CoreException {
        try {
            bundle.uninstall();
        }
        catch (BundleException be) {
            throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_UninstallationFailure, (Object)bundle.getSymbolicName()), be));
        }
    }

    private boolean isTargetBundlePriority() {
        if (this.targetBundlePriority == null) {
            String property = System.getProperty(EGF_TARGET_BUNDLE_PRIORITY);
            this.targetBundlePriority = Boolean.TRUE.toString().equals(property);
        }
        return this.targetBundlePriority;
    }
}

