/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.dialogs;

import java.util.Map;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.genmodel.IPlatformGenModel;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.egf.core.ui.dialogs.PlatformPackageDialog;
import org.eclipse.egf.core.ui.l10n.CoreUIMessages;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LoadEcoreDialog
extends ResourceDialog {
    protected boolean _workspace;
    protected boolean _fileSystem;
    protected boolean _multi;
    protected EditingDomain _domain;
    private boolean _packageNsURI;
    private boolean _genmodelURI;

    public LoadEcoreDialog(Shell parent, EditingDomain domain) {
        this(parent, domain, false, false, true, true, true);
    }

    public LoadEcoreDialog(Shell parent, EditingDomain domain, boolean packageNsURI, boolean genmodelURI, boolean multi, boolean workspace, boolean fileSystem) {
        super(parent, packageNsURI ? CoreUIMessages._UI_BrowseRegisteredPackages_title : CoreUIMessages._UI_BrowseResource_title, multi ? 4098 : 4100);
        this._packageNsURI = packageNsURI;
        this._domain = domain;
        this._multi = multi;
        this._workspace = workspace;
        this._fileSystem = fileSystem;
        this._genmodelURI = genmodelURI;
    }

    protected boolean processResources() {
        if (this._domain != null) {
            for (URI uri : this.getURIs()) {
                try {
                    if (this.processResource(this._domain.getResourceSet().getResource(uri, true))) continue;
                    return false;
                }
                catch (RuntimeException re) {
                    EGFCoreUIPlugin.getDefault().logError(NLS.bind((String)CoreUIMessages.ModelSelection_errorMessage, (Object)uri));
                }
            }
        }
        return true;
    }

    protected boolean processResource(Resource resource) {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.updateComposite(composite);
        Composite buttonComposite = (Composite)composite.getChildren()[0];
        Button browseRegisteredPackagesButton = new Button(buttonComposite, 8);
        browseRegisteredPackagesButton.setText(CoreUIMessages._UI_BrowseRegisteredPackages_label);
        this.prepareBrowseRegisteredPackagesButton(browseRegisteredPackagesButton);
        FormData data = new FormData();
        Control[] children = buttonComposite.getChildren();
        data.right = new FormAttachment(children[0], -10);
        browseRegisteredPackagesButton.setLayoutData((Object)data);
        return composite;
    }

    private void updateComposite(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Button) {
                Button button = (Button)control;
                if (CommonUIPlugin.INSTANCE.getString("_UI_BrowseFileSystem_label").equals(button.getText()) && !this._fileSystem) {
                    button.setVisible(false);
                } else if (CommonUIPlugin.INSTANCE.getString("_UI_BrowseWorkspace_label").equals(button.getText()) && !this._workspace) {
                    button.setVisible(false);
                }
            } else if (control instanceof Text) {
                Text text = (Text)control;
                if (CommonUIPlugin.INSTANCE.getString(this.isMulti() ? "_UI_ResourceURIs_label" : "_UI_ResourceURI_label").equals(text.getText()) && this._packageNsURI) {
                    if (this._multi) {
                        text.setText(CoreUIMessages._UI_PackageURIs_label);
                    } else {
                        text.setText(CoreUIMessages._UI_PackageURI_label);
                    }
                }
            } else if (control instanceof Composite) {
                this.updateComposite((Composite)control);
            }
            ++n2;
        }
    }

    protected void prepareBrowseRegisteredPackagesButton(Button browseRegisteredPackagesButton) {
        browseRegisteredPackagesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PlatformPackageDialog dialog = new PlatformPackageDialog(LoadEcoreDialog.this.getShell(), LoadEcoreDialog.this._multi);
                if (dialog.open() != 0) {
                    return;
                }
                Object[] result = dialog.getResult();
                if (result == null) {
                    return;
                }
                StringBuffer uris = new StringBuffer();
                if (LoadEcoreDialog.this._packageNsURI) {
                    int i = 0;
                    int length = result.length;
                    while (i < length) {
                        uris.append(result[i]);
                        uris.append("  ");
                        ++i;
                    }
                    LoadEcoreDialog.this.uriField.setText("");
                    LoadEcoreDialog.this.uriField.setText((String.valueOf(LoadEcoreDialog.this.uriField.getText()) + "  " + uris.toString()).trim());
                } else if (LoadEcoreDialog.this._genmodelURI) {
                    Map ePackageNsURItoGenModelLocationMap = EGFCorePlugin.getEPackageNsURIToGenModelLocationMap();
                    int i = 0;
                    int length = result.length;
                    while (i < length) {
                        IPlatformGenModel genmodel = (IPlatformGenModel)result[i];
                        if (genmodel.getURI() == null) {
                            EGFCoreUIPlugin.getDefault().logWarning(NLS.bind((String)CoreUIMessages._UI_No_Associated_GenModel, (Object)genmodel.getNamespace()));
                        } else {
                            URI location = (URI)ePackageNsURItoGenModelLocationMap.get(genmodel.getURI().toString());
                            if (location != null) {
                                uris.append(location);
                                uris.append("  ");
                            }
                        }
                        ++i;
                    }
                    if (uris.length() != 0) {
                        LoadEcoreDialog.this.uriField.setText("");
                        LoadEcoreDialog.this.uriField.setText((String.valueOf(LoadEcoreDialog.this.uriField.getText()) + "  " + uris.toString()).trim());
                    }
                } else {
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    resourceSet.setURIConverter((URIConverter)EGFCorePlugin.getPlatformURIConverter());
                    Map ePackageNsURItoGenModelLocationMap = EGFCorePlugin.getEPackageNsURIToGenModelLocationMap();
                    int i = 0;
                    int length = result.length;
                    while (i < length) {
                        IPlatformGenModel genmodel = (IPlatformGenModel)result[i];
                        if (genmodel.getURI() == null) {
                            EGFCoreUIPlugin.getDefault().logWarning(NLS.bind((String)CoreUIMessages._UI_No_Associated_GenModel, (Object)genmodel.getNamespace()));
                        } else {
                            URI location = (URI)ePackageNsURItoGenModelLocationMap.get(genmodel.getURI().toString());
                            Resource resource = resourceSet.getResource(location, true);
                            EcoreUtil.resolveAll((Resource)resource);
                        }
                        ++i;
                    }
                    for (Resource resource : resourceSet.getResources()) {
                        block4: for (EPackage ePackage : EMFHelper.getAllPackages((Resource)resource)) {
                            int i2 = 0;
                            int length2 = result.length;
                            while (i2 < length2) {
                                if (((IPlatformGenModel)result[i2]).getId().compareTo(ePackage.getNsURI()) == 0) {
                                    URI resourceUri = resource.getURI();
                                    uris.append(resourceUri);
                                    uris.append("  ");
                                    continue block4;
                                }
                                ++i2;
                            }
                        }
                    }
                    if (uris.length() != 0) {
                        LoadEcoreDialog.this.uriField.setText("");
                        LoadEcoreDialog.this.uriField.setText((String.valueOf(LoadEcoreDialog.this.uriField.getText()) + "  " + uris.toString()).trim());
                    }
                }
            }
        });
    }
}

