/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.egf.common.loader.IClassLoader;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.epackage.IProxyEObject;
import org.eclipse.egf.pattern.l10n.EGFPatternMessages;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;

public class ParameterTypeHelper {
    public static final ParameterTypeHelper INSTANCE = new ParameterTypeHelper();
    private Map<URI, IProxyEObject> _proxies = new HashMap<URI, IProxyEObject>();
    private Map<IPluginModelBase, IClassLoader> _loaders = new HashMap<IPluginModelBase, IClassLoader>();

    private ParameterTypeHelper() {
    }

    public String getSourceTypeLiteral(String type) {
        return this.getTypeLiteral(type, true);
    }

    public String getBinaryTypeLiteral(String type) {
        return this.getTypeLiteral(type, false);
    }

    public void clearProxies() {
        this._proxies.clear();
        this._loaders.clear();
    }

    private String getTypeLiteral(String type, boolean handleInnerClass) {
        if (type == null || type.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        int index = type.indexOf(35);
        if (index == -1) {
            return handleInnerClass ? type.replace('$', '.') : type;
        }
        URI uri = URI.createURI((String)type.trim());
        if (this._proxies.containsKey(uri)) {
            return this._proxies.get(uri).getInstanceClassName();
        }
        IProxyEObject proxy = EGFCorePlugin.getTargetPlatformIProxyEObject((URI)uri, this._loaders);
        if (proxy == null) {
            throw new IllegalStateException(NLS.bind((String)EGFPatternMessages.assembly_error7, (Object)uri));
        }
        if (proxy.getInstanceClassName() == null) {
            throw new IllegalStateException(NLS.bind((String)EGFPatternMessages.assembly_error7, (Object)uri));
        }
        this._proxies.put(uri, proxy);
        return proxy.getInstanceClassName();
    }
}

