/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.task.ant.engine;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.core.platform.uri.TargetPlatformURIConverter;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.portfolio.task.ant.engine.AntProject;
import org.eclipse.egf.portfolio.task.ant.engine.AntTaskBuildLogger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public class AntScriptEngine {
    public static final String TASK_PRODUCTION_CONTEXT = "TaskProductionContext";

    public void executeAntTask(String value, ITaskProductionContext context, SubMonitor monitor) throws Exception {
        AntProject p = new AntProject();
        AntTaskBuildLogger consoleLogger = new AntTaskBuildLogger();
        consoleLogger.setErrorPrintStream(System.err);
        consoleLogger.setOutputPrintStream(System.out);
        consoleLogger.setMessageOutputLevel(2);
        p.addBuildListener((BuildListener)consoleLogger);
        try {
            SubMonitor subMonitor = monitor.newChild(100, 0);
            p.fireBuildStarted();
            p.init();
            ProjectHelper helper = ProjectHelper.getProjectHelper();
            File antFile = this.getFile(value);
            if (!antFile.exists()) {
                throw new Exception("Can not find the ant file :'" + value + "'!");
            }
            helper.parse((Project)p, (Object)antFile);
            String defaultTarget = p.getDefaultTarget();
            p.addReference(TASK_PRODUCTION_CONTEXT, context);
            p.executeTarget(defaultTarget);
            p.fireBuildFinished(null);
            this.doSubMonitor(subMonitor);
        }
        catch (BuildException be) {
            p.fireBuildFinished(be);
            throw be;
        }
    }

    private void doSubMonitor(SubMonitor subMonitor) {
        subMonitor.worked(100);
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private File getFile(String value) throws IOException {
        URI uri = URI.createURI((String)value);
        TargetPlatformURIConverter converter = new TargetPlatformURIConverter();
        URL resolveTarget = AntScriptEngine.resolveTarget(converter.normalize(uri));
        File antfile = new File(resolveTarget.getPath());
        return antfile;
    }

    public static URL resolveTarget(URI uri) throws IOException {
        if (!uri.isPlatform()) {
            return new URL(uri.toString());
        }
        String pluginID = uri.segment(1);
        IPluginModelBase model = PluginRegistry.findModel((String)pluginID);
        if (model == null) {
            throw new IOException(NLS.bind((String)"Unable to resolve target plug-in \"{0}\".", (Object)pluginID));
        }
        if (!model.isEnabled()) {
            throw new IOException(NLS.bind((String)"Target plug-in is disabled \"{0}\".", (Object)pluginID));
        }
        IPath path = new Path(uri.toPlatformString(true)).removeFirstSegments(1);
        File file = new File(model.getInstallLocation());
        if (!file.exists()) {
            throw new IOException(NLS.bind((String)"Target install location \"{0}\" doesn't exist.", (Object)file.toString()));
        }
        if (!file.isFile()) {
            file = new File(model.getInstallLocation(), path.toOSString());
            if (!file.exists()) {
                throw new IOException(NLS.bind((String)"Target resource \"{0}\" doesn't exist.", (Object)file.toString()));
            }
            return file.toURL();
        }
        return new URL("jar:" + file.toURL().toString() + "!/" + path.toString());
    }
}

