/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.extension;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.model.pattern.PatternNature;
import org.eclipse.egf.pattern.EGFPatternPlugin;
import org.eclipse.egf.pattern.extension.PatternExtension;
import org.eclipse.egf.pattern.l10n.EGFPatternMessages;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.osgi.util.NLS;

public class ExtensionHelper {
    public static PatternNature createNature(String name) {
        PatternExtension patternExtension = null;
        try {
            patternExtension = EGFPatternPlugin.getPatternExtension(name);
            if (patternExtension == null) {
                throw new IllegalStateException(NLS.bind((String)EGFPatternMessages.extension_error1, (Object)name));
            }
        }
        catch (CoreException ce) {
            throw new IllegalStateException(NLS.bind((String)EGFPatternMessages.extension_error1, (Object)name), ce);
        }
        EClass eClass = patternExtension.getNature().eClass();
        return (PatternNature)eClass.getEPackage().getEFactoryInstance().create(eClass);
    }

    public static PatternExtension getExtension(PatternNature nature) throws MissingExtensionException {
        PatternExtension patternExtension = null;
        try {
            patternExtension = EGFPatternPlugin.getPatternExtension(nature);
            if (patternExtension == null) {
                throw new MissingExtensionException(NLS.bind((String)EGFPatternMessages.extension_error1, (Object)ExtensionHelper.getName(nature)));
            }
        }
        catch (CoreException ce) {
            throw new MissingExtensionException(NLS.bind((String)EGFPatternMessages.extension_error1, (Object)ExtensionHelper.getName(nature)), ce);
        }
        return patternExtension;
    }

    public static String getName(PatternNature nature) {
        return nature.eClass().getName();
    }

    public static class MissingExtensionException
    extends Exception {
        private static final long serialVersionUID = 8310777379305723688L;

        private MissingExtensionException(String message) {
            super(message);
        }

        private MissingExtensionException(String message, Throwable t) {
            super(message, t);
        }
    }
}

