/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.domain;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.egf.domain.DomainException;
import org.eclipse.egf.model.domain.Domain;
import org.eclipse.egf.model.domain.DomainViewpoint;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.osgi.framework.Bundle;

public interface DomainHelper {
    public static final Helper INSTANCE = new Helper();

    public boolean loadDomain(Domain var1) throws DomainException;

    public boolean unLoadDomain(Domain var1) throws DomainException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Helper {
        public void loadDomains(FactoryComponent fc, Bundle bundle) throws DomainException {
            for (Domain domain : this.getDomains(fc)) {
                String helperImplementation = domain.getHelperImplementation();
                if (helperImplementation == null || "".equals(helperImplementation)) continue;
                DomainHelper helper = this.loadHelper(helperImplementation, bundle);
                helper.loadDomain(domain);
            }
        }

        public void unLoadDomains(FactoryComponent fc, Bundle bundle) throws DomainException {
            for (Domain domain : this.getDomains(fc)) {
                String helperImplementation = domain.getHelperImplementation();
                if (helperImplementation == null || "".equals(helperImplementation)) continue;
                DomainHelper helper = this.loadHelper(helperImplementation, bundle);
                helper.unLoadDomain(domain);
            }
        }

        protected DomainHelper loadHelper(String helperImplementation, Bundle bundle) throws DomainException {
            try {
                Class<?> clazz = Class.forName(helperImplementation);
                return (DomainHelper)clazz.newInstance();
            }
            catch (Exception e1) {
                try {
                    Class loadClass = bundle.loadClass(helperImplementation);
                    return (DomainHelper)loadClass.newInstance();
                }
                catch (Exception e) {
                    throw new DomainException(e);
                }
            }
        }

        private List<Domain> getDomains(FactoryComponent fc) {
            if (fc.getViewpointContainer() == null) {
                return new ArrayList<Domain>();
            }
            DomainViewpoint vp = (DomainViewpoint)fc.getViewpointContainer().getViewpoint(DomainViewpoint.class);
            return vp == null ? new ArrayList<Domain>() : vp.getDomains();
        }
    }
}

