/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.utils;

import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.genmodel.IPlatformGenModel;
import org.eclipse.emf.common.util.URI;

public class ParameterTypeHelper {
    public static final ParameterTypeHelper INSTANCE = new ParameterTypeHelper();

    private ParameterTypeHelper() {
    }

    public String getSourceTypeLiteral(String type) {
        return this.getTypeLiteral(type, true);
    }

    public String getBinaryTypeLiteral(String type) {
        return this.getTypeLiteral(type, false);
    }

    private String getTypeLiteral(String type, boolean handleInnerClass) {
        IPlatformGenModel model;
        if (type == null || "".equals(type)) {
            throw new IllegalArgumentException();
        }
        int index = type.indexOf(35);
        if (index == -1) {
            return handleInnerClass ? type.replace('$', '.') : type;
        }
        URI uri = URI.createURI((String)type.trim());
        IPlatformGenModel genModel = null;
        IPlatformGenModel[] iPlatformGenModelArray = EGFCorePlugin.getWorkspaceTargetPlatformGenModels();
        int n = iPlatformGenModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            model = iPlatformGenModelArray[n2];
            if (model.getURI().equals((Object)uri.trimFragment())) {
                genModel = EGFCorePlugin.getTargetPlatformGenModel((URI)uri.trimFragment());
                break;
            }
            ++n2;
        }
        if (genModel == null) {
            genModel = EGFCorePlugin.getTargetPlatformGenModel((URI)uri.trimFragment());
        }
        if (genModel == null) {
            iPlatformGenModelArray = EGFCorePlugin.getNonWorkspaceTargetPlatformGenModels();
            n = iPlatformGenModelArray.length;
            n2 = 0;
            while (n2 < n) {
                model = iPlatformGenModelArray[n2];
                if (model.getURI().equals((Object)uri.trimFragment())) {
                    genModel = EGFCorePlugin.getTargetPlatformGenModel((URI)uri.trimFragment());
                    break;
                }
                ++n2;
            }
        }
        if (genModel == null) {
            genModel = EGFCorePlugin.getRuntimePlatformGenModel((URI)uri.trimFragment());
        }
        if (genModel != null) {
            return String.valueOf(genModel.getBasePackage()) + '.' + this.getClassName(type, index);
        }
        throw new IllegalStateException("Cannot find model: " + uri);
    }

    private String getClassName(String type, int index) {
        String className = type.substring(index + 1);
        if (className.startsWith("//")) {
            return className.substring(2);
        }
        return className;
    }
}

