/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.jet.editor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.PatternVariable;
import org.eclipse.egf.pattern.ui.jet.Activator;
import org.eclipse.egf.pattern.ui.jet.editor.JETAnnotationModel;
import org.eclipse.egf.pattern.ui.jet.editor.JetTextEditor;
import org.eclipse.egf.pattern.ui.jet.template.JetTemplateEditor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jet.core.parser.ProblemSeverity;
import org.eclipse.jet.core.parser.ast.JETASTElement;
import org.eclipse.jet.core.parser.ast.JETCompilationUnit;
import org.eclipse.jet.core.parser.ast.Problem;
import org.eclipse.jet.internal.editor.JETEditorHelper;
import org.eclipse.jet.internal.editor.JETTextEditor;
import org.eclipse.jet.internal.editor.annotations.JETProblemAnnotation;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.MarkerAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JetEditorHelper
extends JETEditorHelper {
    public static List evaluateProblems(JETTextEditor jetEditor, IDocument jetDocument) {
        JETCompilationUnit cu = jetEditor.requestCompilationUnit();
        String packageName = cu.getOutputJavaPackage();
        String className = cu.getOutputJavaClassName();
        ArrayList problems = new ArrayList();
        if (packageName == null || className == null) {
            return problems;
        }
        HashMap mappingPositions = new HashMap();
        String javaSource = jetEditor.compilationHelper().getJavaCode(cu, mappingPositions);
        JETJavaContentProblemRequestor problemRequestor = new JETJavaContentProblemRequestor(problems, mappingPositions, jetDocument);
        try {
            ICompilationUnit compilationUnit = null;
            IJavaProject javaProject = jetEditor.getJavaProject();
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                if (1 == root.getKind()) {
                    IPackageFragment packageFragment = root.getPackageFragment(packageName);
                    if (packageFragment == null || !packageFragment.exists()) {
                        packageFragment = root.createPackageFragment(packageName, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    compilationUnit = packageFragment.createCompilationUnit(String.valueOf(className) + ".java", javaSource, true, (IProgressMonitor)new NullProgressMonitor());
                    break;
                }
                ++i;
            }
            WorkingCopyOwner owner = new WorkingCopyOwner(){};
            ICompilationUnit copy = compilationUnit.getWorkingCopy(owner, (IProblemRequestor)problemRequestor, null);
            copy.reconcile(0, true, owner, null);
        }
        catch (JavaModelException e) {
            Activator.getDefault();
            Activator.log((Exception)((Object)e));
        }
        return problems;
    }

    public static void refreshPublicTemplateEditor(Pattern pattern, IFile templateFile, JetTextEditor editor) {
        MultiPageEditorPart multiPageEditorPart = JetEditorHelper.getMultiPageEditorPart((TextEditor)editor);
        List editors = ((JetTemplateEditor)multiPageEditorPart).getEditorList();
        if (templateFile.exists()) {
            try {
                templateFile.setContents((InputStream)new ByteArrayInputStream(new byte[0]), true, false, null);
                if (editors == null) {
                    return;
                }
                int size = editors.size();
                if (size == 0) {
                    return;
                }
                JetTextEditor footerEditor = null;
                int i = 0;
                while (i < size) {
                    JetTextEditor currentEditor = (JetTextEditor)((Object)editors.get(i));
                    String partName = currentEditor.getPartName();
                    if (partName.equals("footer")) {
                        footerEditor = currentEditor;
                    } else {
                        JetEditorHelper.visitMethod(currentEditor, templateFile, true);
                    }
                    ++i;
                }
                JetEditorHelper.visitMethod(footerEditor, templateFile, false);
            }
            catch (Exception e) {
                Activator.getDefault();
                Activator.log(e);
            }
        } else {
            try {
                templateFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
            }
            catch (CoreException e) {
                Activator.getDefault();
                Activator.log((Exception)((Object)e));
            }
            JetEditorHelper.refreshPublicTemplateEditor(pattern, templateFile, editor);
        }
    }

    private static void visitMethod(JetTextEditor currentEditor, IFile templateFile, boolean seprator) throws CoreException {
        if (currentEditor == null) {
            return;
        }
        InputStream inputStreamOfEditor = JetEditorHelper.getInputStreamOfEditor(currentEditor);
        if (inputStreamOfEditor == null) {
            return;
        }
        templateFile.appendContents(inputStreamOfEditor, false, false, null);
        if (seprator) {
            templateFile.appendContents((InputStream)new StringBufferInputStream("\n"), true, false, null);
        }
    }

    public static void mappingErrorFromTemplateEditor(JetTextEditor editor) {
        IDocument fDocument;
        MultiPageEditorPart multiPageEditorPart = JetEditorHelper.getMultiPageEditorPart((TextEditor)editor);
        if (multiPageEditorPart == null) {
            return;
        }
        JetTemplateEditor jetTemplateEditor = (JetTemplateEditor)multiPageEditorPart;
        IEditorPart templateEditorPart = jetTemplateEditor.getTemplateFileEditorPart();
        Pattern pattern = editor.getPattern();
        Map editors = ((JetTemplateEditor)multiPageEditorPart).getEditorMap();
        if (!(templateEditorPart instanceof TextEditor)) {
            return;
        }
        JETTextEditor fEditor = (JETTextEditor)templateEditorPart;
        IDocumentProvider fDocumentProvider = fEditor.getDocumentProvider();
        if (fDocumentProvider == null) {
            IFile templateFile = jetTemplateEditor.getTemplateFile();
            WorkbenchPage templateActivePage = jetTemplateEditor.getTemplateActivePage();
            try {
                if (templateActivePage == null || templateFile == null) {
                    return;
                }
                fEditor = (JETTextEditor)IDE.openEditor((IWorkbenchPage)templateActivePage, (IFile)templateFile, (boolean)false);
                templateActivePage.setEditorAreaVisible(false);
            }
            catch (Exception e) {
                Activator.getDefault();
                Activator.log(e);
            }
            fDocumentProvider = fEditor.getDocumentProvider();
        }
        if (fEditor == null) {
            // empty if block
        }
        if ((fDocument = fDocumentProvider.getDocument((Object)fEditor.getEditorInput())) == null) {
            return;
        }
        Map<String, Position> mappings = JetEditorHelper.getMappings(pattern, editors);
        if (mappings == null || mappings.size() == 0) {
            return;
        }
        List<Problem> javaContentProblems = JETEditorHelper.evaluateProblems((JETTextEditor)fEditor, (IDocument)fDocument);
        JETCompilationUnit cUnit = fEditor.requestCompilationUnit();
        List cUnitProblems = cUnit.getProblems();
        javaContentProblems.addAll(cUnitProblems);
        EList allParameters = editor.getPattern().getAllParameters();
        EList allVariables = editor.getPattern().getAllVariables();
        javaContentProblems = JetEditorHelper.clearProblemsForParameterAndVariable(allParameters, javaContentProblems);
        javaContentProblems = JetEditorHelper.clearProblemsForParameterAndVariable(allVariables, javaContentProblems);
        for (String id : editors.keySet()) {
            IDocumentProvider documentProvider;
            IAnnotationModel annotationModel;
            JETAnnotationModel jetAnnotationModel;
            JetTextEditor textEditor = (JetTextEditor)((Object)editors.get(id));
            List<Problem> problems = javaContentProblems;
            Position position = mappings.get(id);
            if (position == null) continue;
            int startOffset = position.offset;
            int endOffset = position.offset + position.length - 1;
            if (problems == null || problems.size() == 0 || (jetAnnotationModel = (JETAnnotationModel)(annotationModel = (documentProvider = textEditor.getDocumentProvider()).getAnnotationModel((Object)textEditor.getEditorInput()))) == null) continue;
            jetAnnotationModel.setFireChanges(false);
            Iterator it = jetAnnotationModel.getAnnotationIterator();
            while (it.hasNext()) {
                Annotation annotation = (Annotation)it.next();
                if (!(annotation instanceof JETProblemAnnotation) && !(annotation instanceof MarkerAnnotation)) continue;
                jetAnnotationModel.removeAnnotation(annotation);
            }
            for (Problem problem : problems) {
                JETProblemAnnotation annotation = new JETProblemAnnotation(problem);
                Position posi = JetEditorHelper.createPositionFromProblem(problem);
                if (posi == null) continue;
                int offset = posi.offset;
                if (startOffset == 0 && offset == -1) {
                    jetAnnotationModel.addAnnotation((Annotation)annotation, posi);
                }
                if (offset < startOffset || offset > endOffset) continue;
                posi.setOffset(offset - startOffset);
                jetAnnotationModel.addAnnotation((Annotation)annotation, posi);
            }
            jetAnnotationModel.setFireChanges(true);
            jetAnnotationModel.fireAnnotationModelChanged();
        }
    }

    public static List<Problem> clearProblemsForParameterAndVariable(EList filters, List<Problem> problems) {
        if (filters == null || filters.size() == 0) {
            return problems;
        }
        Iterator iterator = filters.iterator();
        ArrayList<Problem> newProblems = new ArrayList<Problem>();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            String filter = "";
            if (next instanceof PatternParameter) {
                filter = ((PatternParameter)next).getName();
            } else if (next instanceof PatternVariable) {
                filter = ((PatternVariable)next).getName();
            }
            filter = String.valueOf(filter) + " cannot be resolved";
            for (Problem problem : problems) {
                if (problem.getMessage().equals(filter)) continue;
                newProblems.add(problem);
            }
        }
        return newProblems;
    }

    public static Position createPositionFromProblem(Problem problem) {
        int start = problem.getStart();
        int end = problem.getEnd();
        if (end == 0 && start == 0) {
            return new Position(0, 0);
        }
        int length = end - start + 1;
        if (length < 0) {
            return null;
        }
        return new Position(start, length);
    }

    public static Map<String, Position> getMappings(Pattern pattern, Map<String, TextEditor> editors) {
        EList methods = pattern.getMethods();
        HashMap<String, Position> mappings = new HashMap<String, Position>();
        int startOffset = 0;
        for (PatternMethod method : methods) {
            String id = method.getID();
            TextEditor textEditor = editors.get(id);
            if (textEditor == null) continue;
            ISourceViewer viewer = ((JetTextEditor)textEditor).getViewer();
            if (viewer == null || viewer.getDocument() == null) {
                return null;
            }
            int length = viewer.getDocument().getLength();
            mappings.put(id, new Position(startOffset, length));
            startOffset = startOffset + length + 1;
        }
        return mappings;
    }

    public static void refreshPublicTemplateEditor(JetTextEditor editor) {
        MultiPageEditorPart multiPageEditorPart = JetEditorHelper.getMultiPageEditorPart((TextEditor)editor);
        if (multiPageEditorPart == null) {
            return;
        }
        IEditorPart templateEditorPart = ((JetTemplateEditor)multiPageEditorPart).getTemplateFileEditorPart();
        Pattern pattern = editor.getPattern();
        if (templateEditorPart == null) {
            return;
        }
        IEditorInput editorInput = templateEditorPart.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFile templateFile = ((IFileEditorInput)editorInput).getFile();
            JetEditorHelper.refreshPublicTemplateEditor(pattern, templateFile, editor);
        }
    }

    public static MultiPageEditorPart getMultiPageEditorPart(TextEditor editor) {
        IWorkbenchPartSite site = editor.getSite();
        if (site instanceof MultiPageEditorSite) {
            return ((MultiPageEditorSite)site).getMultiPageEditor();
        }
        return null;
    }

    public static InputStream getInputStreamOfEditor(JetTextEditor editor) {
        ISourceViewer viewer = editor.getViewer();
        if (viewer == null) {
            return null;
        }
        IDocument document = viewer.getDocument();
        return new ByteArrayInputStream(document.get().getBytes());
    }

    public static ICompletionProposal[] getAssistResult(ICompletionProposal[] proposals, List<ICompletionProposal> proposalsAdd) {
        int i;
        ICompletionProposal[] result = new ICompletionProposal[proposalsAdd.size() + proposals.length];
        if (proposalsAdd.size() > 0) {
            i = 0;
            while (i < proposalsAdd.size()) {
                result[i] = proposalsAdd.get(i);
                ++i;
            }
        }
        if (proposals.length > 0) {
            i = 0;
            while (i < proposals.length) {
                result[i + proposalsAdd.size()] = proposals[i];
                ++i;
            }
        }
        return result;
    }

    private static final class JETJavaContentProblemRequestor
    implements IProblemRequestor {
        private List problems;
        private List javaProblems;
        private IDocument jetDocument;
        private Map mappingPositions;

        private JETJavaContentProblemRequestor(List problems, Map mappings, IDocument jetDocument) {
            this.problems = problems;
            this.mappingPositions = mappings;
            this.javaProblems = new ArrayList();
            this.jetDocument = jetDocument;
        }

        public List getProblems() {
            return this.problems;
        }

        public void acceptProblem(IProblem problem) {
            this.javaProblems.add(problem);
        }

        public void beginReporting() {
            this.javaProblems.clear();
        }

        public void endReporting() {
            for (IProblem javaProblem : this.javaProblems) {
                int javaProblemOffset = javaProblem.getSourceStart();
                int problemLength = javaProblem.getSourceEnd() - javaProblemOffset + 1;
                JETASTElement astElement = this.getElementForJavaOffset(javaProblemOffset);
                Position pos = (Position)this.mappingPositions.get(astElement);
                int astElementJavaContentStart = pos == null ? -1 : pos.getOffset();
                int jetOffset = pos == null ? 0 : JETEditorHelper.getASTElementContentStart((JETASTElement)astElement, (IDocument)this.jetDocument) + (javaProblemOffset - astElementJavaContentStart);
                URI baseLocation = URI.create("");
                Problem problem = new Problem(baseLocation, "", javaProblem.isWarning() ? ProblemSeverity.WARNING : ProblemSeverity.ERROR, -1, javaProblem.getMessage(), (Object[])javaProblem.getArguments(), jetOffset, jetOffset + problemLength, -1, -1);
                this.problems.add(problem);
            }
        }

        public boolean isActive() {
            return true;
        }

        private JETASTElement getElementForJavaOffset(int javaOffset) {
            for (JETASTElement element : this.mappingPositions.keySet()) {
                Position pos = (Position)this.mappingPositions.get(element);
                if (pos.getOffset() > javaOffset || javaOffset >= pos.getOffset() + pos.getLength()) continue;
                return element;
            }
            return null;
        }
    }
}

