/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.jet.editor;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.pattern.ui.editors.templateEditor.MethodEditorActivationListener;
import org.eclipse.egf.pattern.ui.jet.editor.JetDocumentProvider;
import org.eclipse.egf.pattern.ui.jet.editor.JetEditorHelper;
import org.eclipse.egf.pattern.ui.jet.editor.JetSourceViewerConfigure;
import org.eclipse.jet.internal.editor.JETTextEditor;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class JetTextEditor
extends JETTextEditor {
    private RefreshUIJob job;
    private Pattern pattern;
    private ActivationListener fActivationListener;

    public JetTextEditor(Pattern pattern) throws CoreException, IOException {
        this.pattern = pattern;
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new JetSourceViewerConfigure(this));
        this.setDocumentProvider((IDocumentProvider)new JetDocumentProvider(this));
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.fActivationListener = new ActivationListener(site.getWorkbenchWindow().getPartService(), (TextEditor)this);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public final ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
    }

    public RefreshUIJob getJob() {
        return this.job;
    }

    public void dispose() {
        if (this.fActivationListener != null) {
            this.fActivationListener.dispose();
            this.fActivationListener = null;
        }
        super.dispose();
    }

    class ActivationListener
    extends MethodEditorActivationListener {
        public ActivationListener(IPartService partService, TextEditor editor) {
            super(partService, editor);
        }

        protected void handleActivation() {
            JetTextEditor.this.safelySanityCheckState(JetTextEditor.this.getEditorInput());
        }
    }

    class JetModifyListener
    implements ModifyListener {
        JetModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (JetTextEditor.this.job == null) {
                JetTextEditor.this.job = new RefreshUIJob("RefreshTemplateEditor");
            }
            JetTextEditor.this.job.start();
        }
    }

    class RefreshUIJob
    extends Job {
        private long timestamp;
        private boolean lazy;

        public RefreshUIJob(String name) {
            super(name);
            this.timestamp = -1L;
            this.lazy = false;
        }

        private void start() {
            if (!this.lazy) {
                this.schedule(1000L);
            } else if (System.currentTimeMillis() - this.timestamp > 999L && !this.lazy) {
                this.lazy = true;
            }
            this.timestamp = System.currentTimeMillis();
        }

        protected IStatus run(IProgressMonitor monitor) {
            JetEditorHelper.refreshPublicTemplateEditor(JetTextEditor.this);
            if (this.lazy) {
                this.schedule();
                this.lazy = false;
            }
            return Status.OK_STATUS;
        }
    }
}

