/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.reflog.command;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.commit.command.UnifiedDiffHandler;
import org.eclipse.egit.ui.internal.reflog.command.AbstractReflogCommandHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.ui.handlers.HandlerUtil;

public class ReflogUnifiedDiffHandler
extends AbstractReflogCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection ssel;
        Repository repository = this.getRepository(event);
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (ssel = (IStructuredSelection)selection).size() == 2) {
            List items = ssel.toList();
            ReflogEntry first = (ReflogEntry)Adapters.adapt(items.get(0), ReflogEntry.class);
            ReflogEntry second = (ReflogEntry)Adapters.adapt(items.get(1), ReflogEntry.class);
            RevCommit tip = null;
            RevCommit base = null;
            try {
                Throwable throwable = null;
                Object var11_13 = null;
                try (RevWalk w = new RevWalk(repository);){
                    if (first != null) {
                        tip = w.parseCommit((AnyObjectId)first.getNewId());
                    }
                    if (second != null) {
                        base = w.parseCommit((AnyObjectId)second.getNewId());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new ExecutionException(e.getMessage(), (Throwable)e);
            }
            if (tip != null && base != null) {
                UnifiedDiffHandler.show(new RepositoryCommit(repository, tip), new RepositoryCommit(repository, base));
            }
        }
        return null;
    }
}

