/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveableFilter;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.ide.ResourceUtil;

class SaveFilter
implements ISaveableFilter {
    private final IResource[] roots;

    public SaveFilter(IResource[] roots) {
        this.roots = roots;
    }

    public boolean select(Saveable saveable, IWorkbenchPart[] containingParts) {
        if (this.isDescendantOfRoots(saveable)) {
            return true;
        }
        IWorkbenchPart[] iWorkbenchPartArray = containingParts;
        int n = containingParts.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart editorPart;
            IWorkbenchPart workbenchPart = iWorkbenchPartArray[n2];
            if (workbenchPart instanceof IEditorPart && this.isEditingDescendantOf(editorPart = (IEditorPart)workbenchPart)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDescendantOfRoots(Saveable saveable) {
        ResourceMapping mapping = ResourceUtil.getResourceMapping((Object)saveable);
        if (mapping == null) {
            IFile file = ResourceUtil.getFile((Object)saveable);
            if (file == null) return false;
            return this.isDescendantOfRoots((IResource)file);
        }
        try {
            ResourceTraversal[] traversals;
            ResourceTraversal[] resourceTraversalArray = traversals = mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, null);
            int n = traversals.length;
            int n2 = 0;
            block2: while (true) {
                IResource[] resources;
                if (n2 >= n) {
                    return false;
                }
                ResourceTraversal traversal = resourceTraversalArray[n2];
                IResource[] iResourceArray = resources = traversal.getResources();
                int n3 = resources.length;
                int n4 = 0;
                while (true) {
                    if (n4 >= n3) {
                        ++n2;
                        continue block2;
                    }
                    IResource resource = iResourceArray[n4];
                    if (this.isDescendantOfRoots(resource)) {
                        return true;
                    }
                    ++n4;
                }
                break;
            }
        }
        catch (CoreException e) {
            Activator.logError(NLS.bind((String)"An internal error occurred while determining the resources for {0}", (Object)saveable.getName()), e);
            return false;
        }
    }

    private boolean isDescendantOfRoots(IResource resource) {
        IResource[] iResourceArray = this.roots;
        int n = this.roots.length;
        int n2 = 0;
        while (n2 < n) {
            IResource root = iResourceArray[n2];
            if (root.getFullPath().isPrefixOf(resource.getFullPath())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isEditingDescendantOf(IEditorPart part) {
        IFile file = ResourceUtil.getFile((IEditorInput)part.getEditorInput());
        if (file != null) {
            return this.isDescendantOfRoots((IResource)file);
        }
        return false;
    }
}

