/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.json.text.ui;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.service.util.ProgressMonitorAdapter;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.validation.LayoutOptionValidator;
import org.eclipse.elk.graph.EMapPropertyHolder;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.impl.ElkPropertyToValueMapEntryImpl;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyValueProxy;
import org.eclipse.elk.graph.util.GraphIdentifierGenerator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ConvertGraphHandler
extends AbstractHandler {
    private static final String PARAM_TARGET_EXT = "org.eclipse.elk.graph.json.text.convert.targetExtension";
    private static final String EXT_ELK_TEXT = "elkj";
    private static final String EXT_ELK_XMI = "elkg";
    private String targetExtension;
    @Inject
    private LayoutOptionValidator layoutOptionValidator;
    private static final List<? extends IProperty<?>> EXCLUDED_OPTIONS = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IProperty[]{CoreOptions.POSITION, CoreOptions.BEND_POINTS, CoreOptions.JUNCTION_POINTS}));

    public final Object execute(ExecutionEvent event) throws ExecutionException {
        boolean _not;
        this.targetExtension = event.getParameter(PARAM_TARGET_EXT);
        boolean _isValidTargetExtension = this.isValidTargetExtension(this.targetExtension);
        boolean bl = _not = !_isValidTargetExtension;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Invalid target extension: ");
            _builder.append(this.targetExtension);
            Status status = new Status(4, "org.eclipse.elk.graph.json.text.ui", _builder.toString());
            StatusManager.getManager().handle((IStatus)status, 3);
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            final Iterable files = Iterables.filter((Iterable)((IStructuredSelection)selection).toList(), IFile.class);
            Job job = new Job("Convert models"){

                protected IStatus run(IProgressMonitor monitor) {
                    ProgressMonitorAdapter elkMonitor = new ProgressMonitorAdapter(monitor);
                    elkMonitor.begin("Convert models", (float)IterableExtensions.size((Iterable)files));
                    Consumer<IFile> _function = file -> {
                        boolean _not;
                        boolean _isCanceled = elkMonitor.isCanceled();
                        boolean bl = _not = !_isCanceled;
                        if (_not) {
                            ConvertGraphHandler.this.convert((IFile)file, elkMonitor.subTask(1.0f));
                        }
                    };
                    files.forEach(_function);
                    elkMonitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        return null;
    }

    private boolean isValidTargetExtension(String targetExtension) {
        return Objects.equals(targetExtension, EXT_ELK_TEXT) || Objects.equals(targetExtension, EXT_ELK_XMI);
    }

    public void convert(IFile file, IElkProgressMonitor monitor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Convert ");
        String _name = file.getName();
        _builder.append(_name);
        monitor.begin(_builder.toString(), 3.0f);
        try {
            try {
                EList<EObject> sourceModels = this.readModel(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false));
                monitor.worked(1.0f);
                Functions.Function1 _function = it -> this.transform((EObject)it);
                List targetModels = IterableExtensions.toList((Iterable)IterableExtensions.map(sourceModels, (Functions.Function1)_function));
                monitor.worked(1.0f);
                this.saveModel(targetModels, this.createTarget(file));
            }
            catch (Throwable _t) {
                if (!(_t instanceof Exception)) {
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                Exception exception = (Exception)_t;
                Status status = new Status(4, "org.eclipse.elk.graph.json.text.ui", "Error while converting the selected graph.", (Throwable)exception);
                StatusManager.getManager().handle((IStatus)status, 3);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected EObject transform(EObject model) {
        EObject copy = EcoreUtil.copy((EObject)model);
        if (this.targetExtension.equals(EXT_ELK_TEXT) && copy instanceof ElkNode) {
            ElkNode graph = (ElkNode)copy;
            GraphIdentifierGenerator.forGraph((ElkNode)graph).assertValid().assertExists().assertUnique().execute();
        }
        return copy;
    }

    private URI createTarget(IFile file) {
        IPath basePath = file.getFullPath();
        String name = basePath.removeFileExtension().lastSegment();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(name);
        _builder.append(".");
        _builder.append(this.targetExtension);
        Path targetPath = new Path(_builder.toString());
        int i = 0;
        IContainer parent = file.getParent();
        while (parent.exists((IPath)targetPath)) {
            Path _path;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(name);
            int _plusPlus = i++;
            _builder_1.append((Object)_plusPlus);
            _builder_1.append(".");
            _builder_1.append(this.targetExtension);
            targetPath = _path = new Path(_builder_1.toString());
        }
        targetPath = parent.getFullPath().append((IPath)targetPath);
        return URI.createPlatformResourceURI((String)targetPath.toString(), (boolean)false);
    }

    private EList<EObject> readModel(URI uri) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(uri, true);
        return resource.getContents();
    }

    private void saveModel(List<EObject> models, URI uri) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(uri);
        resource.getContents().addAll(models);
        resource.save(Collections.EMPTY_MAP);
    }

    protected void removeInvalidProperties(ElkNode graph) {
        ArrayList toRemove = CollectionLiterals.newArrayList();
        Procedures.Procedure1 _function = element -> {
            Consumer<Map.Entry> _function_1 = entry -> {
                boolean _not;
                boolean _isValid = this.isValid((IProperty<?>)((IProperty)entry.getKey()), entry.getValue(), (EMapPropertyHolder)element);
                boolean bl = _not = !_isValid;
                if (_not) {
                    toRemove.add((ElkPropertyToValueMapEntryImpl)entry);
                }
            };
            element.getProperties().forEach(_function_1);
        };
        IteratorExtensions.forEach((Iterator)Iterators.filter((Iterator)graph.eAllContents(), EMapPropertyHolder.class), (Procedures.Procedure1)_function);
        Consumer<ElkPropertyToValueMapEntryImpl> _function_1 = it -> EcoreUtil.remove((EObject)it);
        toRemove.forEach(_function_1);
    }

    private boolean isValid(IProperty<?> property, Object value, EMapPropertyHolder container) {
        LayoutOptionData _xifexpression = null;
        _xifexpression = property instanceof LayoutOptionData ? (LayoutOptionData)property : LayoutMetaDataService.getInstance().getOptionData(property.getId());
        LayoutOptionData option = _xifexpression;
        if (option == null) {
            return false;
        }
        boolean _contains = EXCLUDED_OPTIONS.contains(option);
        if (_contains) {
            return false;
        }
        Object _xifexpression_1 = null;
        if (value instanceof String) {
            _xifexpression_1 = option.parseValue((String)value);
        } else {
            Object _xifexpression_2 = null;
            _xifexpression_2 = value instanceof IPropertyValueProxy ? ((IPropertyValueProxy)value).resolveValue((IProperty)option) : value;
            _xifexpression_1 = _xifexpression_2;
        }
        Object parsedValue = _xifexpression_1;
        if (parsedValue == null) {
            return false;
        }
        if (container instanceof ElkGraphElement) {
            List issues;
            boolean _isEmpty;
            boolean _not_2;
            boolean _not;
            boolean _contains_1;
            boolean _matched = false;
            if (container instanceof ElkNode) {
                boolean _not2;
                _matched = true;
                boolean bl = _not2 = !option.getTargets().contains(LayoutOptionData.Target.NODES) && (((ElkNode)container).getChildren().isEmpty() || !option.getTargets().contains(LayoutOptionData.Target.PARENTS));
                if (_not2) {
                    return false;
                }
            }
            if (!_matched && container instanceof ElkEdge) {
                _matched = true;
                _contains_1 = option.getTargets().contains(LayoutOptionData.Target.EDGES);
                boolean bl = _not = !_contains_1;
                if (_not) {
                    return false;
                }
            }
            if (!_matched && container instanceof ElkPort) {
                _matched = true;
                _contains_1 = option.getTargets().contains(LayoutOptionData.Target.PORTS);
                boolean bl = _not = !_contains_1;
                if (_not) {
                    return false;
                }
            }
            if (!_matched && container instanceof ElkLabel) {
                _matched = true;
                _contains_1 = option.getTargets().contains(LayoutOptionData.Target.LABELS);
                boolean bl = _not = !_contains_1;
                if (_not) {
                    return false;
                }
            }
            if (container instanceof ElkNode && option.getTargets().contains(LayoutOptionData.Target.NODES)) {
                boolean _isSupportedByAlgorithm = this.isSupportedByAlgorithm(option, (ElkGraphElement)((ElkNode)container).getParent());
                boolean bl = _not = !_isSupportedByAlgorithm;
                if (_not) {
                    return false;
                }
            } else {
                boolean _not_1;
                boolean _isSupportedByAlgorithm_1 = this.isSupportedByAlgorithm(option, (ElkGraphElement)container);
                boolean bl = _not_1 = !_isSupportedByAlgorithm_1;
                if (_not_1) {
                    return false;
                }
            }
            boolean bl = _not_2 = !(_isEmpty = (issues = this.layoutOptionValidator.checkProperty((IProperty)option, parsedValue, (ElkGraphElement)container)).isEmpty());
            return !_not_2;
        }
        return false;
    }

    private boolean isSupportedByAlgorithm(LayoutOptionData option, ElkGraphElement element) {
        boolean _equals = Objects.equals(option, CoreOptions.ALGORITHM);
        if (_equals) {
            return true;
        }
        LayoutAlgorithmData algorithm = ConvertGraphHandler.getAlgorithm(element);
        if (algorithm != null && algorithm.knowsOption((IProperty)option)) {
            return true;
        }
        ElkNode parent = (ElkNode)EcoreUtil2.getContainerOfType((EObject)element, ElkNode.class);
        while (parent != null) {
            algorithm = ConvertGraphHandler.getAlgorithm((ElkGraphElement)parent);
            if (algorithm != null && algorithm.knowsOption((IProperty)option)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    protected void removeUnnecessaryLayouts(ElkNode graph) {
        ArrayList toRemove = CollectionLiterals.newArrayList();
        Procedures.Procedure1 _function = edge -> {
            EList _sections = edge.getSections();
            Iterables.addAll((Collection)toRemove, (Iterable)_sections);
        };
        IteratorExtensions.forEach((Iterator)Iterators.filter((Iterator)graph.eAllContents(), ElkEdge.class), (Procedures.Procedure1)_function);
        Consumer<ElkEdgeSection> _function_1 = it -> EcoreUtil.remove((EObject)it);
        toRemove.forEach(_function_1);
    }

    public static LayoutAlgorithmData getAlgorithm(ElkGraphElement element) {
        ElkNode node;
        ElkNode _switchResult = null;
        boolean _matched = false;
        if (element instanceof ElkNode) {
            _matched = true;
            _switchResult = (ElkNode)element;
        }
        if (!_matched && element instanceof ElkPort) {
            ElkNode _parent_2;
            _matched = true;
            ElkNode _elvis = null;
            ElkNode _parent = ((ElkPort)element).getParent();
            ElkNode _parent_1 = null;
            if (_parent != null) {
                _parent_1 = _parent.getParent();
            }
            _elvis = _parent_1 != null ? _parent_1 : (_parent_2 = ((ElkPort)element).getParent());
            _switchResult = _elvis;
        }
        if (!_matched && element instanceof ElkEdge) {
            _matched = true;
            _switchResult = ((ElkEdge)element).getContainingNode();
        }
        if (!_matched && element instanceof ElkLabel) {
            ElkNode _parent;
            ElkNode _elvis;
            _matched = true;
            ElkNode _xblockexpression = null;
            ElkGraphElement parent = ((ElkLabel)element).getParent();
            while (parent instanceof ElkLabel) {
                parent = ((ElkLabel)parent).getParent();
            }
            ElkNode _switchResult_1 = null;
            boolean _matched_1 = false;
            if (parent instanceof ElkNode) {
                _matched_1 = true;
                _elvis = null;
                _parent = ((ElkNode)parent).getParent();
                _elvis = _parent != null ? _parent : (ElkNode)parent;
                _switchResult_1 = _elvis;
            }
            if (!_matched_1 && parent instanceof ElkPort) {
                ElkNode _parent_2;
                _matched_1 = true;
                _elvis = null;
                _parent = ((ElkPort)parent).getParent();
                ElkNode _parent_1 = null;
                if (_parent != null) {
                    _parent_1 = _parent.getParent();
                }
                _elvis = _parent_1 != null ? _parent_1 : (_parent_2 = ((ElkPort)parent).getParent());
                _switchResult_1 = _elvis;
            }
            if (!_matched_1 && parent instanceof ElkEdge) {
                _matched_1 = true;
                _switchResult_1 = ((ElkEdge)parent).getContainingNode();
            }
            _switchResult = _xblockexpression = _switchResult_1;
        }
        if ((node = _switchResult) != null) {
            boolean _not;
            String algorithmId = (String)node.getProperty(CoreOptions.ALGORITHM);
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)algorithmId);
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                return LayoutMetaDataService.getInstance().getAlgorithmDataBySuffix(algorithmId);
            }
        }
        return null;
    }
}

