/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.graphiti;

import com.google.common.collect.BiMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.elk.alg.graphiti.GraphElementIndicator;
import org.eclipse.elk.alg.graphiti.GraphitiLayoutCommand;
import org.eclipse.elk.core.math.ElkMargin;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.service.IDiagramLayoutConnector;
import org.eclipse.elk.core.service.LayoutMapping;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.Property;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementEditPart;
import org.eclipse.graphiti.ui.internal.util.gef.ScalableRootEditPartAnimated;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.swt.SWTException;
import org.eclipse.ui.IWorkbenchPart;

@Singleton
public class GraphitiDiagramLayoutConnector
implements IDiagramLayoutConnector {
    public static final IProperty<Command> LAYOUT_COMMAND = new Property("graphiti.applyLayoutCommand");
    public static final IProperty<List<Connection>> CONNECTIONS = new Property("graphiti.connections");
    public static final IProperty<KVector> COORDINATE_OFFSET = new Property("graphiti.coordinateOffset");
    @Inject
    private GraphElementIndicator graphElemIndicator;
    private static final float MIN_SIZE = 3.0f;
    private static final double HEAD_LOCATION = 0.7;
    private static final double TAIL_LOCATION = 0.3;

    public LayoutMapping buildLayoutGraph(IWorkbenchPart workbenchPart, Object diagramPart) {
        ElkNode topNode;
        EditPart editorContent;
        PictogramElement pe;
        LayoutMapping mapping = new LayoutMapping(workbenchPart);
        mapping.setProperty(CONNECTIONS, new LinkedList());
        Shape rootElement = null;
        ArrayList<Shape> selectedElements = null;
        if (diagramPart instanceof Shape) {
            rootElement = (Shape)diagramPart;
        } else if (diagramPart instanceof IPictogramElementEditPart) {
            PictogramElement pe2 = ((IPictogramElementEditPart)diagramPart).getPictogramElement();
            if (pe2 instanceof Shape) {
                rootElement = (Shape)pe2;
            }
        } else if (diagramPart instanceof Collection) {
            Collection selection = (Collection)diagramPart;
            LinkedList<Shape> shapes = new LinkedList<Shape>();
            for (Object object : selection) {
                PictogramElement pe3;
                Shape shape = null;
                if (object instanceof Shape) {
                    shape = (Shape)object;
                } else if (object instanceof IPictogramElementEditPart && (pe3 = ((IPictogramElementEditPart)object).getPictogramElement()) instanceof Shape) {
                    shape = (Shape)pe3;
                }
                if (shape == null) continue;
                if (rootElement != null) {
                    Shape parent = GraphitiDiagramLayoutConnector.commonParent(rootElement, shape);
                    if (parent != null) {
                        rootElement = parent;
                    }
                } else {
                    rootElement = shape;
                }
                shapes.add(shape);
            }
            if (rootElement != null) {
                selectedElements = new ArrayList<Shape>(shapes.size());
                for (Shape shape : shapes) {
                    while (shape != null && shape.getContainer() != rootElement) {
                        shape = shape.getContainer();
                    }
                    if (selectedElements.contains(shape)) continue;
                    selectedElements.add(shape);
                }
            }
        }
        if (rootElement == null && workbenchPart instanceof DiagramEditor && (pe = ((IPictogramElementEditPart)(editorContent = ((DiagramEditor)workbenchPart).getGraphicalViewer().getContents())).getPictogramElement()) instanceof Shape) {
            rootElement = (Shape)pe;
        }
        if (rootElement == null) {
            throw new UnsupportedOperationException("Not supported by this layout connector: Workbench part " + workbenchPart + ", Element " + diagramPart);
        }
        mapping.setParentElement((Object)rootElement);
        if (rootElement instanceof Diagram) {
            topNode = ElkGraphUtil.createGraph();
            GraphicsAlgorithm ga = rootElement.getGraphicsAlgorithm();
            topNode.setLocation((double)ga.getX(), (double)ga.getY());
            topNode.setDimensions((double)ga.getWidth(), (double)ga.getHeight());
            mapping.getGraphMap().put((Object)topNode, (Object)rootElement);
        } else {
            topNode = this.createNode(mapping, null, rootElement);
        }
        mapping.setLayoutGraph(topNode);
        if (selectedElements != null && !selectedElements.isEmpty()) {
            double minx = 2.147483647E9;
            double miny = 2.147483647E9;
            for (Shape shape : selectedElements) {
                ElkNode node = this.createNode(mapping, topNode, shape);
                minx = Math.min(minx, node.getX());
                miny = Math.min(miny, node.getY());
                if (!(shape instanceof ContainerShape)) continue;
                this.buildLayoutGraphRecursively(mapping, (ContainerShape)shape, node);
            }
            mapping.setProperty(COORDINATE_OFFSET, (Object)new KVector(minx, miny));
        } else if (rootElement instanceof ContainerShape) {
            this.buildLayoutGraphRecursively(mapping, (ContainerShape)rootElement, topNode);
        }
        for (Connection entry : (List)mapping.getProperty(CONNECTIONS)) {
            this.createEdge(mapping, entry);
        }
        return mapping;
    }

    protected static Shape commonParent(Shape shape1, Shape shape2) {
        Shape s1 = shape1;
        Shape s2 = shape2;
        do {
            if (GraphitiDiagramLayoutConnector.isParent(s1, s2)) {
                return s1;
            }
            if (GraphitiDiagramLayoutConnector.isParent(s2, s1)) {
                return s2;
            }
            s1 = s1.getContainer();
            s2 = s2.getContainer();
        } while (s1 != null && s2 != null);
        return null;
    }

    protected static boolean isParent(Shape parent, Shape child) {
        Shape shape = child;
        do {
            if (shape != parent) continue;
            return true;
        } while ((shape = shape.getContainer()) != null);
        return false;
    }

    public void applyLayout(LayoutMapping mapping, IPropertyHolder settings) {
        boolean zoomToFit = (Boolean)settings.getProperty(CoreOptions.ZOOM_TO_FIT);
        Object layoutGraphObj = mapping.getParentElement();
        if (zoomToFit && layoutGraphObj instanceof EditPart) {
            double oldScale;
            double desiredHeight;
            double scaleY;
            GraphicalViewer viewer = ((IPictogramElementEditPart)layoutGraphObj).getConfigurationProvider().getDiagramContainer().getGraphicalViewer();
            ZoomManager zoomManager = ((ScalableRootEditPartAnimated)viewer.getRootEditPart()).getZoomManager();
            ElkNode parentNode = mapping.getLayoutGraph();
            Dimension available = zoomManager.getViewport().getClientArea().getSize();
            double desiredWidth = parentNode.getWidth();
            double scaleX = Math.min((double)available.width / desiredWidth, zoomManager.getMaxZoom());
            double scale = Math.min(scaleX, scaleY = Math.min((double)available.height / (desiredHeight = parentNode.getHeight()), zoomManager.getMaxZoom()));
            if (scale < (oldScale = zoomManager.getZoom())) {
                zoomManager.setViewLocation(new Point(0, 0));
                zoomManager.setZoom(scale);
                zoomManager.setViewLocation(new Point(0, 0));
            }
            this.transferLayout(mapping);
            this.applyLayout(mapping);
            if (scale > oldScale) {
                zoomManager.setViewLocation(new Point(0, 0));
                zoomManager.setZoom(scale);
                zoomManager.setViewLocation(new Point(0, 0));
            }
        } else {
            this.transferLayout(mapping);
            this.applyLayout(mapping);
        }
    }

    protected void transferLayout(LayoutMapping mapping) {
        DiagramEditor diagramEditor = (DiagramEditor)mapping.getWorkbenchPart();
        GraphitiLayoutCommand command = new GraphitiLayoutCommand(diagramEditor.getEditingDomain(), diagramEditor.getDiagramTypeProvider().getFeatureProvider(), this);
        for (Map.Entry entry : mapping.getGraphMap().entrySet()) {
            command.add((ElkGraphElement)entry.getKey(), (PictogramElement)entry.getValue());
        }
        mapping.setProperty(LAYOUT_COMMAND, (Object)command);
        KVector offset = (KVector)mapping.getProperty(COORDINATE_OFFSET);
        if (offset != null) {
            GraphitiDiagramLayoutConnector.addOffset(mapping.getLayoutGraph(), offset);
        }
    }

    protected static void addOffset(ElkNode parentNode, KVector offset) {
        double minx = 2.147483647E9;
        double miny = 2.147483647E9;
        for (ElkNode child : parentNode.getChildren()) {
            minx = Math.min(minx, child.getX());
            miny = Math.min(miny, child.getY());
        }
        offset.add(-minx, -miny);
        ElkUtil.translate((ElkNode)parentNode, (double)offset.x, (double)offset.y);
    }

    protected void applyLayout(LayoutMapping mapping) {
        TransactionalEditingDomain editingDomain = ((DiagramEditor)mapping.getWorkbenchPart()).getEditingDomain();
        editingDomain.getCommandStack().execute((Command)mapping.getProperty(LAYOUT_COMMAND));
    }

    protected void buildLayoutGraphRecursively(LayoutMapping mapping, ContainerShape parentElement, ElkNode parentNode) {
        for (Shape shape : parentElement.getChildren()) {
            if (!this.graphElemIndicator.isNodeShape(shape)) continue;
            ElkNode node = this.createNode(mapping, parentNode, shape);
            if (!(shape instanceof ContainerShape)) continue;
            this.buildLayoutGraphRecursively(mapping, (ContainerShape)shape, node);
        }
    }

    protected ElkNode createNode(LayoutMapping mapping, ElkNode parentNode, Shape shape) {
        ElkNode childNode = ElkGraphUtil.createNode((ElkNode)parentNode);
        ElkPadding padding = this.computePadding((PictogramElement)shape);
        if (padding != null) {
            childNode.setProperty(CoreOptions.PADDING, (Object)padding);
        }
        ElkMargin nodeMargins = this.computeMargins((PictogramElement)shape);
        childNode.setProperty(CoreOptions.MARGINS, (Object)nodeMargins);
        GraphicsAlgorithm nodeGa = shape.getGraphicsAlgorithm();
        if (parentNode == null) {
            childNode.setLocation((double)nodeGa.getX() + nodeMargins.left, (double)nodeGa.getY() + nodeMargins.top);
        } else {
            ElkMargin parentMargins = (ElkMargin)parentNode.getProperty(CoreOptions.MARGINS);
            childNode.setLocation((double)nodeGa.getX() + nodeMargins.left - parentMargins.left, (double)nodeGa.getY() + nodeMargins.top - parentMargins.top);
        }
        childNode.setDimensions((double)nodeGa.getWidth() - nodeMargins.left - nodeMargins.right, (double)nodeGa.getHeight() - nodeMargins.top - nodeMargins.bottom);
        childNode.setProperty(CoreOptions.NODE_SIZE_MINIMUM, (Object)new KVector(3.0, 3.0));
        mapping.getGraphMap().put((Object)childNode, (Object)shape);
        if (shape instanceof ContainerShape) {
            for (Shape child : ((ContainerShape)shape).getChildren()) {
                if (!this.graphElemIndicator.isNodeLabel(child)) continue;
                this.createLabel((ElkGraphElement)childNode, child, -nodeMargins.left, -nodeMargins.top);
            }
        }
        for (Anchor anchor : shape.getAnchors()) {
            if (this.graphElemIndicator.isPortAnchor(anchor)) {
                if (anchor instanceof BoxRelativeAnchor) {
                    this.createPort(mapping, childNode, (BoxRelativeAnchor)anchor);
                } else if (anchor instanceof FixPointAnchor) {
                    this.createPort(mapping, childNode, (FixPointAnchor)anchor);
                }
            }
            ((List)mapping.getProperty(CONNECTIONS)).addAll(anchor.getOutgoingConnections());
        }
        return childNode;
    }

    protected ElkMargin computeMargins(PictogramElement pictogramElement) {
        GraphicsAlgorithm graphicsAlgorithm = pictogramElement.getGraphicsAlgorithm();
        GraphicsAlgorithm visibleGa = this.findVisibleGa(graphicsAlgorithm);
        ElkMargin margins = new ElkMargin();
        while (visibleGa != null && visibleGa != graphicsAlgorithm) {
            margins.left += (double)visibleGa.getX();
            margins.top += (double)visibleGa.getY();
            GraphicsAlgorithm parentGa = visibleGa.getParentGraphicsAlgorithm();
            margins.right += (double)(parentGa.getWidth() - visibleGa.getX() - visibleGa.getWidth());
            margins.bottom += (double)(parentGa.getHeight() - visibleGa.getY() - visibleGa.getHeight());
            visibleGa = parentGa;
        }
        return margins;
    }

    protected ElkPadding computePadding(PictogramElement pictogramElement) {
        return null;
    }

    protected ElkPort createPort(LayoutMapping mapping, ElkNode parentNode, BoxRelativeAnchor bra) {
        ElkPort port = ElkGraphUtil.createPort((ElkNode)parentNode);
        GraphicsAlgorithm referencedGa = bra.getReferencedGraphicsAlgorithm();
        if (referencedGa == null) {
            return null;
        }
        mapping.getGraphMap().put((Object)port, (Object)bra);
        double relWidth = bra.getRelativeWidth();
        double relHeight = bra.getRelativeHeight();
        double parentWidth = referencedGa.getWidth();
        double parentHeight = referencedGa.getHeight();
        double xPos = relWidth * parentWidth;
        double yPos = relHeight * parentHeight;
        GraphicsAlgorithm portGa = bra.getGraphicsAlgorithm();
        if (portGa != null) {
            xPos += (double)portGa.getX();
            yPos += (double)portGa.getY();
            port.setDimensions((double)portGa.getWidth(), (double)portGa.getHeight());
        }
        port.setLocation(xPos, yPos);
        return port;
    }

    protected ElkPort createPort(LayoutMapping mapping, ElkNode parentNode, FixPointAnchor fpa) {
        ElkPort port = ElkGraphUtil.createPort((ElkNode)parentNode);
        mapping.getGraphMap().put((Object)port, (Object)fpa);
        double xPos = fpa.getLocation().getX();
        double yPos = fpa.getLocation().getY();
        GraphicsAlgorithm portGa = fpa.getGraphicsAlgorithm();
        if (portGa != null) {
            xPos += (double)portGa.getX();
            yPos += (double)portGa.getY();
            port.setDimensions((double)portGa.getWidth(), (double)portGa.getHeight());
        }
        port.setLocation(xPos, yPos);
        return port;
    }

    protected ElkLabel createLabel(ElkGraphElement element, Shape shape, double offsetx, double offsety) {
        ElkLabel label = ElkGraphUtil.createLabel((ElkGraphElement)element);
        GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
        int xpos = ga.getX();
        int ypos = ga.getY();
        int width = ga.getWidth();
        int height = ga.getHeight();
        if (ga instanceof AbstractText) {
            AbstractText abstractText = (AbstractText)ga;
            String labelText = abstractText.getValue();
            label.setText(labelText);
            IGaService gaService = Graphiti.getGaService();
            Font font = gaService.getFont(abstractText, true);
            IDimension textSize = null;
            try {
                textSize = GraphitiUi.getUiLayoutService().calculateTextSize(labelText, font);
            }
            catch (SWTException sWTException) {}
            if (textSize != null) {
                int diff;
                if (textSize.getWidth() < width) {
                    diff = width - textSize.getWidth();
                    switch (gaService.getHorizontalAlignment(abstractText, true)) {
                        case ALIGNMENT_CENTER: {
                            xpos += diff / 2;
                            break;
                        }
                        case ALIGNMENT_RIGHT: {
                            xpos += diff;
                            break;
                        }
                    }
                    width -= diff;
                }
                if (textSize.getHeight() < height) {
                    diff = height - textSize.getHeight();
                    switch (gaService.getVerticalAlignment(abstractText, true)) {
                        case ALIGNMENT_MIDDLE: {
                            ypos += diff / 2;
                            break;
                        }
                        case ALIGNMENT_BOTTOM: {
                            ypos += diff;
                            break;
                        }
                    }
                    height -= diff;
                }
            }
        }
        label.setLocation((double)xpos + offsetx, (double)ypos + offsety);
        label.setDimensions((double)width, (double)height);
        return label;
    }

    protected ElkEdge createEdge(LayoutMapping mapping, Connection connection) {
        Anchor targetAnchor;
        BiMap inverseGraphMap = mapping.getGraphMap().inverse();
        ElkConnectableShape targetShape = (ElkConnectableShape)inverseGraphMap.get((Object)(targetAnchor = connection.getEnd()));
        if (targetShape == null) {
            return null;
        }
        Anchor sourceAnchor = connection.getStart();
        ElkConnectableShape sourceShape = (ElkConnectableShape)inverseGraphMap.get((Object)sourceAnchor);
        if (sourceShape == null) {
            return null;
        }
        ElkEdge edge = ElkGraphUtil.createSimpleEdge((ElkConnectableShape)sourceShape, (ElkConnectableShape)targetShape);
        ElkNode referenceNode = edge.getContainingNode();
        KVector offset = new KVector();
        ElkUtil.toAbsolute((KVector)offset, (ElkNode)referenceNode);
        ElkEdgeSection edgeSection = ElkGraphUtil.createEdgeSection((ElkEdge)edge);
        KVector sourcePoint = this.calculateAnchorEnds(sourceShape, referenceNode);
        edgeSection.setStartLocation(sourcePoint.x, sourcePoint.y);
        KVector targetPoint = this.calculateAnchorEnds(targetShape, referenceNode);
        edgeSection.setEndLocation(targetPoint.x, targetPoint.y);
        KVectorChain allPoints = new KVectorChain();
        allPoints.add((Object)sourcePoint);
        if (connection instanceof FreeFormConnection) {
            for (org.eclipse.graphiti.mm.algorithms.styles.Point point : ((FreeFormConnection)connection).getBendpoints()) {
                KVector v = new KVector((double)point.getX(), (double)point.getY());
                v.sub(offset);
                allPoints.add((Object)v);
                ElkGraphUtil.createBendPoint((ElkEdgeSection)edgeSection, (double)v.x, (double)v.y);
            }
        }
        allPoints.add((Object)targetPoint);
        mapping.getGraphMap().put((Object)edge, (Object)connection);
        for (ConnectionDecorator decorator : connection.getConnectionDecorators()) {
            if (!this.graphElemIndicator.isEdgeLabel(decorator)) continue;
            this.createEdgeLabel(mapping, edge, decorator, allPoints);
        }
        return edge;
    }

    protected ElkLabel createEdgeLabel(LayoutMapping mapping, ElkEdge parentEdge, ConnectionDecorator decorator, KVectorChain allPoints) {
        ElkLabel label = ElkGraphUtil.createLabel((ElkGraphElement)parentEdge);
        mapping.getGraphMap().put((Object)label, (Object)decorator);
        EdgeLabelPlacement placement = EdgeLabelPlacement.CENTER;
        if (decorator.isLocationRelative()) {
            if (decorator.getLocation() >= 0.7) {
                placement = EdgeLabelPlacement.HEAD;
            } else if (decorator.getLocation() <= 0.3) {
                placement = EdgeLabelPlacement.TAIL;
            }
        }
        label.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)placement);
        KVector labelPos = decorator.isLocationRelative() ? allPoints.pointOnLine(decorator.getLocation() * allPoints.totalLength()) : allPoints.pointOnLine(decorator.getLocation());
        GraphicsAlgorithm ga = decorator.getGraphicsAlgorithm();
        labelPos.x += (double)ga.getX();
        labelPos.y += (double)ga.getY();
        label.setLocation(labelPos.x, labelPos.y);
        if (ga instanceof AbstractText) {
            AbstractText text = (AbstractText)ga;
            String labelText = text.getValue();
            label.setText(labelText);
            IGaService gaService = Graphiti.getGaService();
            Font font = gaService.getFont(text, true);
            if (labelText != null) {
                IDimension textSize = null;
                try {
                    textSize = GraphitiUi.getUiLayoutService().calculateTextSize(labelText, font);
                }
                catch (SWTException sWTException) {}
                if (textSize != null) {
                    label.setDimensions((double)textSize.getWidth(), (double)textSize.getHeight());
                }
            }
        }
        return label;
    }

    public KVector calculateAnchorEnds(ElkConnectableShape shape, ElkNode referenceNode) {
        ElkNode node = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)shape);
        KVector pos = new KVector();
        if (shape instanceof ElkPort) {
            pos.x = shape.getX() + shape.getWidth() / 2.0;
            pos.y = shape.getY() + shape.getHeight() / 2.0;
            pos.x += node.getX();
            pos.y += node.getY();
        } else {
            pos.x = node.getWidth() / 2.0 + node.getX();
            pos.y = node.getHeight() / 2.0 + node.getY();
        }
        ElkUtil.toAbsolute((KVector)pos, (ElkNode)node.getParent());
        if (referenceNode != null) {
            ElkUtil.toRelative((KVector)pos, (ElkNode)referenceNode);
        }
        return pos;
    }

    protected GraphicsAlgorithm findVisibleGa(GraphicsAlgorithm graphicsAlgorithm) {
        if (graphicsAlgorithm != null) {
            if (graphicsAlgorithm.getLineVisible().booleanValue() || graphicsAlgorithm.getFilled().booleanValue()) {
                return graphicsAlgorithm;
            }
            for (GraphicsAlgorithm ga : graphicsAlgorithm.getGraphicsAlgorithmChildren()) {
                GraphicsAlgorithm result = this.findVisibleGa(ga);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }
}

