/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.seconditeration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.alg.rectpacking.util.Block;
import org.eclipse.elk.alg.rectpacking.util.RectRow;
import org.eclipse.elk.graph.ElkNode;

public final class InitialPlacement {
    private InitialPlacement() {
    }

    protected static List<RectRow> place(List<ElkNode> rectangles, double boundingWidth, double nodeNodeSpacing) {
        ArrayList<RectRow> rows = new ArrayList<RectRow>();
        RectRow row = new RectRow(0.0, nodeNodeSpacing);
        double drawingHeight = 0.0;
        row.addBlock(new Block(0.0, 0.0, row, nodeNodeSpacing));
        double currentWidth = 0.0;
        for (ElkNode rect : rectangles) {
            Block block = row.getLastBlock();
            double potentialRowWidth = currentWidth + rect.getWidth() + (row.getChildren().get(0).getChildren().isEmpty() ? 0.0 : nodeNodeSpacing);
            if (potentialRowWidth > boundingWidth) {
                currentWidth = 0.0;
                rows.add(row);
                row = new RectRow(drawingHeight += row.getHeight() + nodeNodeSpacing, nodeNodeSpacing);
                block = new Block(0.0, row.getY(), row, nodeNodeSpacing);
                row.addBlock(block);
                currentWidth = 0.0;
            }
            if (block.getChildren().isEmpty() || InitialPlacement.isSimilarHeight(block, rect, nodeNodeSpacing)) {
                block.addChild(rect);
            } else {
                Block newBlock = new Block(block.getX() + block.getWidth() + nodeNodeSpacing, row.getY(), row, nodeNodeSpacing);
                row.addBlock(newBlock);
                newBlock.addChild(rect);
            }
            currentWidth = rect.getX() + rect.getWidth();
        }
        rows.add(row);
        return rows;
    }

    public static boolean placeRectInBlock(RectRow row, Block block, ElkNode rect, double boundingWidth, double nodeNodeSpacing) {
        if (InitialPlacement.isSimilarHeight(block, rect, nodeNodeSpacing)) {
            if (block.getLastRowNewX() + rect.getWidth() + nodeNodeSpacing <= boundingWidth && (block.getLastRowY() - row.getY() + rect.getHeight() <= row.getHeight() || row.getChildren().size() == 1)) {
                block.addChild(rect);
                return true;
            }
            if (block.getX() + rect.getWidth() <= boundingWidth && (block.getY() + block.getHeight() + rect.getHeight() + nodeNodeSpacing <= row.getHeight() || row.getChildren().size() == 1)) {
                block.addChildInNewRow(rect);
                return true;
            }
        }
        return false;
    }

    public static boolean isSimilarHeight(Block block, ElkNode rect, double nodeNodeSpacing) {
        if (rect.getHeight() >= block.getSmallestRectHeight() && rect.getHeight() <= block.getMinHeight()) {
            return true;
        }
        return block.getAverageHeight() * 0.5 <= rect.getHeight() && block.getAverageHeight() * 1.5 >= rect.getHeight();
    }
}

