/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.managedbuild.cross.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.managedbuild.cross.Activator;

public class PersistentPreferences
extends org.eclipse.embedcdt.core.preferences.PersistentPreferences {
    public static final String BUILD_TOOLS_PATH_KEY = "buildTools.path";
    public static final String GLOBAL_BUILDTOOLS_PATH_STRICT = "global.buildTools.path.strict";
    public static final String WORKSPACE_BUILDTOOLS_PATH_STRICT = "workspace.buildTools.path.strict";
    public static final String PROJECT_BUILDTOOLS_PATH_STRICT = "project.buildTools.path.strict";
    public static final String BUILD_TOOLS_SEARCH_PATH_KEY = "buildTools.search.path";
    public static final String BUILD_TOOLS_SEARCH_PATH_OS_KEY = "buildTools.search.path.%s";
    public static final String BUILD_TOOLS_XPACK_NAMES = "buildTools.xpack.names";
    public static final String TOOLCHAIN_NAME_KEY = "toolchain.name";
    private static final String TOOLCHAIN_PATH_KEY = "toolchain.path.%d";
    private static final String TOOLCHAIN_SEARCH_PATH_KEY = "toolchain.search.path.%d";
    private static final String TOOLCHAIN_SEARCH_PATH_OS_KEY = "toolchain.search.path.%s.%d";
    private static final String TOOLCHAIN_XPACK_NAMES_KEY = "toolchain.xpack.names.%d";
    public static final String GLOBAL_TOOLCHAIN_PATH_STRICT = "global.toolchain.path.strict";
    public static final String WORKSPACE_TOOLCHAIN_PATH_STRICT = "workspace.toolchain.path.strict";
    public static final String PROJECT_TOOLCHAIN_PATH_STRICT = "project.toolchain.path.strict";

    public PersistentPreferences(String pluginId) {
        super(pluginId);
    }

    private String getCommonString(String key, String defaultValue, IProject project) {
        String value = PersistentPreferences.getPreferenceValueForId((String)"org.eclipse.embedcdt.managedbuild.cross", (String)key, null, (IProject)project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        value = PersistentPreferences.getPreferenceValueForId((String)"ilg.gnumcueclipse.managedbuild.cross", (String)key, null, (IProject)project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return defaultValue;
    }

    public String getToolchainName() {
        String toolchainName = this.getString(TOOLCHAIN_NAME_KEY, null);
        if (toolchainName != null && !toolchainName.isEmpty()) {
            return toolchainName;
        }
        return "";
    }

    public void putToolchainName(String toolchainName) {
        this.putString(TOOLCHAIN_NAME_KEY, toolchainName);
    }

    public static String getToolchainKey(String toolchainName) {
        int hash = Math.abs(toolchainName.trim().hashCode());
        String key = String.format(TOOLCHAIN_PATH_KEY, hash);
        return key;
    }

    public String getToolchainPath(String toolchainName, IProject project) {
        String value = project != null ? this.getString(PersistentPreferences.getToolchainKey(toolchainName), null, project) : this.getString(PersistentPreferences.getToolchainKey(toolchainName), null);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putToolchainPath(String toolchainName, String path) {
        this.putString(PersistentPreferences.getToolchainKey(toolchainName), path);
    }

    public void putToolchainPath(String toolchainName, String path, IProject project) {
        this.putProjectString(PersistentPreferences.getToolchainKey(toolchainName), path, project);
    }

    public static String getToolchainSearchKey(String toolchainName) {
        int hash = Math.abs(toolchainName.trim().hashCode());
        String key = String.format(TOOLCHAIN_SEARCH_PATH_KEY, hash);
        return key;
    }

    public static String getToolchainSearchOsKey(String toolchainName) {
        int hash = Math.abs(toolchainName.trim().hashCode());
        String os = EclipseUtils.getOsFamily();
        String key = String.format(TOOLCHAIN_SEARCH_PATH_OS_KEY, os, hash);
        return key;
    }

    public static String getToolchainXpackKey(String toolchainName) {
        int hash = Math.abs(toolchainName.trim().hashCode());
        String key = String.format(TOOLCHAIN_XPACK_NAMES_KEY, hash);
        return key;
    }

    public String getBuildToolsPath(IProject project) {
        String value = this.getCommonString(BUILD_TOOLS_PATH_KEY, "", project);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PersistentPreferences.getBuildToolsPath(\"" + project.getName() + "\") = \"" + value + "\"");
        }
        return value;
    }
}

