/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.core;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.embedcdt.core.Activator;

public class CProjectPacksStorage {
    public static final String STORAGE_NAME = "ilg.gnumcueclipse.managedbuild.packs";
    public static final String PACK_TYPE = "pack.type";
    public static final String CMSIS_DEVICE_NAME = "cmsis.device.name";
    public static final String CMSIS_DEVICE_VENDOR_NAME = "cmsis.device.vendor.name";
    public static final String CMSIS_DEVICE_VENDOR_ID = "cmsis.device.vendor.id";
    public static final String CMSIS_FAMILY_NAME = "cmsis.family.name";
    public static final String CMSIS_SUBFAMILY_NAME = "cmsis.subfamily.name";
    public static final String CMSIS_CORE_NAME = "cmsis.core.name";
    public static final String CMSIS_COMPILER_DEFINE = "cmsis.compiler.define";
    public static final String CMSIS_DEVICE_PACK_VENDOR = "cmsis.device.pack.vendor";
    public static final String CMSIS_DEVICE_PACK_NAME = "cmsis.device.pack.name";
    public static final String CMSIS_DEVICE_PACK_VERSION = "cmsis.device.pack.version";
    public static final String CMSIS_BOARD_NAME = "cmsis.board.name";
    public static final String CMSIS_BOARD_REVISION = "cmsis.board.revision";
    public static final String CMSIS_BOARD_VENDOR_NAME = "cmsis.board.vendor.name";
    public static final String CMSIS_BOARD_CLOCK = "cmsis.board.clock";
    public static final String CMSIS_BOARD_PACK_VENDOR = "cmsis.board.pack.vendor";
    public static final String CMSIS_BOARD_PACK_NAME = "cmsis.board.pack.name";
    public static final String CMSIS_BOARD_PACK_VERSION = "cmsis.board.pack.version";
    public static final String DEVICE_KEY = "device.id";
    public static final String DEVICE_VENDOR_NAME = "device.vendor.name";
    public static final String DEVICE_VENDOR_ID = "device.vendor.id";
    public static final String DEVICE_COMPILER_DEFINES = "device.compiler.defines";
    public static final String DEVICE_COMPILER_HEADERS = "device.compiler.headers";
    public static final String FAMILY_KEY = "family.id";
    public static final String SUBFAMILY_KEY = "subfamily.key";
    public static final String CORE_NAME = "core.name";
    public static final String CORE_ARCH = "core.arch";
    public static final String DEVICE_PACK_NAME = "device.pack.name";
    public static final String DEVICE_PACK_VERSION = "device.pack.version";
    public static final String BOARD_KEY = "board.id";
    public static final String BOARD_REVISION = "board.revision";
    public static final String BOARD_VENDOR_NAME = "board.vendor.name";
    public static final String BOARD_VENDOR_ID = "board.vendor.id";
    public static final String BOARD_COMPILER_DEFINES = "board.compiler.defines";
    public static final String BOARD_COMPILER_HEADERS = "board.compiler.headers";
    public static final String BOARD_CLOCK = "board.clock";
    public static final String BOARD_PACK_NAME = "board.pack.name";
    public static final String BOARD_PACK_VERSION = "board.pack.version";
    private ICStorageElement fStorage;
    private Configuration fConfig;
    private ICConfigurationDescription fConfigDesc;

    public CProjectPacksStorage(IConfiguration config) throws CoreException {
        this(config, STORAGE_NAME);
    }

    public CProjectPacksStorage(IConfiguration config, String storageId) throws CoreException {
        if (config instanceof Configuration) {
            this.fConfig = (Configuration)config;
            this.fConfigDesc = this.fConfig.getConfigurationDescription();
            this.fStorage = this.fConfigDesc.getStorage(storageId, true);
            if (this.fStorage == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.embedcdt.core", "Storage " + storageId + " not found."));
            }
            if (Activator.getInstance().isDebugging()) {
                System.out.println("CProjectPacksStorage() " + this.fStorage + " " + (this.fConfigDesc.isReadOnly() ? "ro" : "rw"));
            }
        } else {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.embedcdt.core", "CProjectPacksStorage() requires Configuration"));
        }
    }

    public void update() {
    }

    public void clear() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("CProjectPacksStorage.clear()");
        }
        this.fStorage.clear();
    }

    public Map<String, String> getOptions() {
        assert (this.fStorage != null);
        HashMap<String, String> map = new HashMap<String, String>();
        ICStorageElement[] iCStorageElementArray = this.fStorage.getChildrenByName("option");
        int n = iCStorageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement child = iCStorageElementArray[n2];
            if (child.hasAttribute("id")) {
                map.put(child.getAttribute("id"), child.getAttribute("value"));
            }
            ++n2;
        }
        return map;
    }

    public String getOption(String id) {
        assert (id != null);
        assert (this.fStorage != null);
        ICStorageElement[] iCStorageElementArray = this.fStorage.getChildrenByName("option");
        int n = iCStorageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement child = iCStorageElementArray[n2];
            if (child.hasAttribute("id") && id.equals(child.getAttribute("id"))) {
                String value = child.getAttribute("value");
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("CProjectPacksStorage.getOption(" + id + ") = " + value);
                }
                return value;
            }
            ++n2;
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("CProjectPacksStorage.getOption(" + id + ") = null");
        }
        return null;
    }

    public String getOption(String id, String defaultValue) {
        String result = this.getOption(id);
        if (result != null && result.length() > 0) {
            return result;
        }
        return defaultValue;
    }

    public void setOption(String id, String value) {
        assert (id != null);
        assert (this.fStorage != null);
        ICStorageElement option = null;
        ICStorageElement[] iCStorageElementArray = this.fStorage.getChildrenByName("option");
        int n = iCStorageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement child = iCStorageElementArray[n2];
            if (id.equals(child.getAttribute("id"))) {
                if (option == null) {
                    option = child;
                } else {
                    this.fStorage.removeChild(child);
                }
            }
            ++n2;
        }
        if (option == null) {
            option = this.fStorage.createChild("option");
            option.setAttribute("id", id);
        }
        value = value == null ? "" : value.trim();
        if (Activator.getInstance().isDebugging()) {
            System.out.println("CProjectPacksStorage.setOption(" + id + "," + value + ") ");
        }
        option.setAttribute("value", value);
    }

    public void setNonEmptyOption(String id, String value) {
        if (value != null && (value = value.trim()).length() > 0) {
            this.setOption(id, value);
        }
    }

    public void setMemory(String section, String start, String size, String startup) {
        ICStorageElement memory = null;
        ICStorageElement[] iCStorageElementArray = this.fStorage.getChildrenByName("memory");
        int n = iCStorageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement child = iCStorageElementArray[n2];
            if (section.equals(child.getAttribute("section"))) {
                if (memory == null) {
                    memory = child;
                } else {
                    this.fStorage.removeChild(child);
                }
            }
            ++n2;
        }
        if (memory == null) {
            memory = this.fStorage.createChild("memory");
            memory.setAttribute("section", section);
        }
        memory.setAttribute("start", start);
        memory.setAttribute("size", size);
        memory.setAttribute("startup", startup);
    }

    public Map<String, String[]> getMemoryMap() {
        TreeMap<String, String[]> map = new TreeMap<String, String[]>();
        ICStorageElement[] memory = this.fStorage.getChildrenByName("memory");
        if (memory != null) {
            ICStorageElement[] iCStorageElementArray = memory;
            int n = memory.length;
            int n2 = 0;
            while (n2 < n) {
                ICStorageElement child = iCStorageElementArray[n2];
                String section = child.getAttribute("section");
                String[] arr = new String[]{section, child.getAttribute("start"), child.getAttribute("size"), child.getAttribute("startup")};
                map.put(section, arr);
                ++n2;
            }
        }
        return map;
    }
}

