/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.packs.jobs;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.embedcdt.packs.core.ConsoleStream;
import org.eclipse.embedcdt.packs.core.data.PacksStorage;
import org.eclipse.embedcdt.packs.core.tree.Node;
import org.eclipse.embedcdt.packs.data.DataManager;
import org.eclipse.embedcdt.packs.data.Utils;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.console.MessageConsoleStream;

public class RemoveJob
extends Job {
    private static boolean fgRunning = false;
    private MessageConsoleStream fOut = ConsoleStream.getConsoleOut();
    private TreeSelection fSelection;
    private IProgressMonitor fMonitor;
    private DataManager fDataManager;

    public RemoveJob(String name, TreeSelection selection) {
        super(name);
        this.fSelection = selection;
        this.fDataManager = DataManager.getInstance();
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status;
        if (fgRunning) {
            return Status.CANCEL_STATUS;
        }
        fgRunning = true;
        this.fMonitor = monitor;
        long beginTime = System.currentTimeMillis();
        this.fOut.println();
        this.fOut.println(org.eclipse.embedcdt.packs.core.Utils.getCurrentDateTime());
        this.fOut.println("Removing packs...");
        LinkedList<Node> packsToRemove = new LinkedList<Node>();
        Object[] objectArray = this.fSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            Node node = (Node)obj;
            if (node.isType("version") & node.isBooleanProperty("installed")) {
                packsToRemove.add(node);
            }
            ++n2;
        }
        int workUnits = packsToRemove.size();
        monitor.beginTask("Remove packs", workUnits);
        LinkedList<Node> removedPacksList = new LinkedList<Node>();
        for (Node versionNode : packsToRemove) {
            if (monitor.isCanceled()) break;
            String packFullName = versionNode.getProperty("archive.name");
            monitor.subTask(packFullName);
            this.fOut.println("Remove \"" + packFullName + "\".");
            try {
                String dest = versionNode.getProperty("dest.folder");
                IPath versionFolderPath = PacksStorage.getFolderPath().append(dest);
                this.fOut.println("Recursive erase \"" + versionFolderPath + "\".");
                Utils.deleteFolderRecursive((File)versionFolderPath.toFile());
                this.fMonitor.worked(1);
                versionNode.setBooleanProperty("installed", false);
                removedPacksList.add(versionNode);
                Utils.reportInfo((String)("CMSIS Pack " + packFullName + " removed."));
            }
            catch (IOException e) {
                this.fOut.println(Utils.reportError((String)e.getMessage()));
                break;
            }
        }
        int count = removedPacksList.size();
        if (count > 0) {
            this.fDataManager.notifyUpdateView("update.versions", removedPacksList);
            this.fDataManager.notifyInstallRemove();
        }
        if (monitor.isCanceled()) {
            this.fOut.println("Job cancelled.");
            status = Status.CANCEL_STATUS;
        } else {
            long endTime = System.currentTimeMillis();
            long duration = endTime - beginTime;
            if (duration == 0L) {
                duration = 1L;
            }
            if (count == 1) {
                this.fOut.println("1 pack removed.");
            } else {
                this.fOut.println(String.valueOf(count) + " packs removed.");
            }
            this.fOut.print("Remove completed in ");
            this.fOut.println(String.valueOf(duration) + "ms.");
            status = Status.OK_STATUS;
        }
        fgRunning = false;
        return status;
    }
}

