/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.memory;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.embedcdt.debug.gdbjtag.viewmodel.peripheral.PeripheralRegisterVMNode;

public class PeripheralMemoryRegion
implements Comparable<PeripheralMemoryRegion> {
    private long fAddressOffset;
    private long fSizeBytes;
    private List<PeripheralRegisterVMNode> fVMNodes;
    private MemoryByte[] fBytes;

    public PeripheralMemoryRegion(long offset, long sizeBytes) {
        this.fAddressOffset = offset;
        this.fSizeBytes = sizeBytes;
        this.fVMNodes = new LinkedList<PeripheralRegisterVMNode>();
    }

    public long getAddressOffset() {
        return this.fAddressOffset;
    }

    public long getSizeBytes() {
        return this.fSizeBytes;
    }

    public void addNode(PeripheralRegisterVMNode node) {
        this.fVMNodes.add(node);
    }

    public List<PeripheralRegisterVMNode> getNodes() {
        return this.fVMNodes;
    }

    public boolean isContiguous(PeripheralMemoryRegion region) {
        return region.fAddressOffset <= this.fAddressOffset + this.fSizeBytes;
    }

    public void concatenate(PeripheralMemoryRegion region) {
        assert (region.fAddressOffset <= this.fAddressOffset + this.fSizeBytes);
        if (region.fAddressOffset + region.fSizeBytes > this.fAddressOffset + this.fSizeBytes) {
            this.fSizeBytes = region.fAddressOffset + region.fSizeBytes - this.fAddressOffset;
        }
        this.fVMNodes.addAll(region.getNodes());
    }

    public void setBytes(MemoryByte[] bytes) {
        this.fBytes = bytes;
    }

    public MemoryByte[] getBytes() {
        return this.fBytes;
    }

    @Override
    public int compareTo(PeripheralMemoryRegion comp) {
        return Long.signum(this.getAddressOffset() - comp.getAddressOffset());
    }

    public String toString() {
        return String.format("[Region 0x%08X, 0x%X, %d nodes]", this.fAddressOffset, this.fSizeBytes, this.fVMNodes.size());
    }
}

