/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.debug.gdbjtag.viewmodel.peripherals;

import ilg.gnumcueclipse.core.EclipseUtils;
import ilg.gnumcueclipse.debug.gdbjtag.Activator;
import ilg.gnumcueclipse.debug.gdbjtag.datamodel.IPeripheralDMContext;
import ilg.gnumcueclipse.debug.gdbjtag.datamodel.PeripheralDMContext;
import ilg.gnumcueclipse.debug.gdbjtag.memory.MemoryBlockMonitor;
import ilg.gnumcueclipse.debug.gdbjtag.memory.PeripheralMemoryBlockRetrieval;
import ilg.gnumcueclipse.debug.gdbjtag.services.IPeripheralsService;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IElementPropertiesProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelImage;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ICheckUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PeripheralsVMNode
extends AbstractDMVMNode
implements IElementLabelProvider,
IElementPropertiesProvider,
IElementEditor {
    public static final String PROPERTY_NAME = "prop.name";
    public static final String PROPERTY_ADDRESS = "prop.address";
    public static final String PROPERTY_DESCRIPTION = "prop.description";
    public static final String PROPERTY_ISSYSTEM = "prop.isSystem";
    private IElementLabelProvider fLabelProvider = this.createLabelProvider();
    private IDMContext[] fPeripherals;

    protected IDMVMContext createVMContext(IDMContext context) {
        return new PeripheralsVMContext(context);
    }

    public PeripheralsVMNode(AbstractDMVMProvider provider, DsfSession session, Class<? extends IDMContext> dmcClassType) {
        super(provider, session, dmcClassType);
    }

    public PeripheralsVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, IPeripheralDMContext.class);
    }

    public int getDeltaFlags(Object event) {
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            return 1024;
        }
        return 0;
    }

    public void buildDelta(Object event, VMDelta parent, int nodeOffset, RequestMonitor requestMonitor) {
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            parent.setFlags(parent.getFlags() | 0x400);
        }
        requestMonitor.done();
    }

    public CellEditor getCellEditor(IPresentationContext context, String columnId, Object element, Composite parent) {
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public void update(final IPropertiesUpdate[] updates) {
        block4: {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("PeripheralsVMNode.update() properties " + (Object)this + ", " + updates.length + " objs");
            }
            try {
                this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        PeripheralsVMNode.this.updatePropertiesInSessionThread(updates);
                    }
                });
                break block4;
            }
            catch (RejectedExecutionException v0) {
                var5_2 = updates;
                var4_3 = updates.length;
                var3_4 = 0;
                ** while (var3_4 < var4_3)
            }
lbl-1000:
            // 1 sources

            {
                update = var5_2[var3_4];
                this.handleFailedUpdate((IViewerUpdate)update);
                ++var3_4;
                continue;
            }
        }
    }

    public void update(ILabelUpdate[] updates) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralsVMNode.update() labels " + (Object)((Object)this) + ", " + updates.length + " objs");
        }
        int i = 0;
        while (i < updates.length) {
            ILabelUpdate update = updates[i];
            IPresentationContext presentationContext = update.getPresentationContext();
            TreePath path = update.getElementPath();
            if (update instanceof ICheckUpdate && Boolean.TRUE.equals(presentationContext.getProperty("org.eclipse.debug.ui.check"))) {
                try {
                    boolean checked = this.getChecked(path, presentationContext);
                    boolean grayed = this.getGrayed(path, presentationContext);
                    ((ICheckUpdate)update).setChecked(checked, grayed);
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        this.fLabelProvider.update(updates);
    }

    protected boolean checkUpdate(IViewerUpdate update) {
        return super.checkUpdate(update);
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralsVMNode.updateElementsInSessionThread() " + (Object)((Object)this) + " " + update);
        }
        DsfServicesTracker tracker = this.getServicesTracker();
        IPeripheralsService peripheralsService = (IPeripheralsService)tracker.getService(IPeripheralsService.class);
        final IRunControl.IContainerDMContext containerDMContext = (IRunControl.IContainerDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IContainerDMContext.class);
        if (peripheralsService == null || containerDMContext == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        if (this.fPeripherals != null) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("PeripheralsVMNode.updateElementsInSessionThread() use cached values");
            }
            this.fillUpdateWithVMCs(update, this.fPeripherals);
            update.done();
            return;
        }
        Executor executor = ImmediateExecutor.getInstance();
        peripheralsService.getPeripherals(containerDMContext, (DataRequestMonitor<IPeripheralDMContext[]>)new ViewerDataRequestMonitor<IPeripheralDMContext[]>(executor, (IViewerUpdate)update){

            public void handleCompleted() {
                if (this.isSuccess()) {
                    PeripheralsVMNode.this.fPeripherals = (IDMContext[])this.getData();
                    PeripheralsVMNode.this.fillUpdateWithVMCs(update, PeripheralsVMNode.this.fPeripherals);
                    PeripheralsVMNode.this.addPersistentPeripherals(containerDMContext);
                    update.done();
                } else {
                    EclipseUtils.showStatusErrorMessage((String)this.getStatus().getMessage());
                    PeripheralsVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                }
            }
        });
    }

    private void addPersistentPeripherals(final IRunControl.IContainerDMContext containerDMContext) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralsVMNode.addPersistentPeripherals()");
        }
        final ArrayList<String> persistentPeripherals = new ArrayList<String>();
        Object object = containerDMContext.getAdapter(PeripheralMemoryBlockRetrieval.class);
        if (object instanceof PeripheralMemoryBlockRetrieval) {
            persistentPeripherals.addAll(((PeripheralMemoryBlockRetrieval)((Object)object)).getPersistentPeripherals());
        }
        if (persistentPeripherals.isEmpty()) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IMemoryBlockRetrieval retrieval = (IMemoryBlockRetrieval)containerDMContext.getAdapter(PeripheralMemoryBlockRetrieval.class);
                for (String peripheralName : persistentPeripherals) {
                    int i = 0;
                    while (i < PeripheralsVMNode.this.fPeripherals.length) {
                        PeripheralDMContext peripheralDMContext = (PeripheralDMContext)PeripheralsVMNode.this.fPeripherals[i];
                        if (peripheralName.equals(peripheralDMContext.getName())) {
                            if (Activator.getInstance().isDebugging()) {
                                System.out.println(PeripheralsVMNode.this.fPeripherals[i] + " must be rendered");
                            }
                            MemoryBlockMonitor.getInstance().addMemoryBlock(workbenchWindow, peripheralDMContext, retrieval);
                        }
                        ++i;
                    }
                }
                MemoryBlockMonitor.getInstance().showMemoryView(workbenchWindow);
            }
        });
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void updatePropertiesInSessionThread(IPropertiesUpdate[] updates) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralsVMNode.updatePropertiesInSessionThread() " + (Object)((Object)this) + ", " + updates.length + " objs");
        }
        IPropertiesUpdate[] iPropertiesUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertiesUpdate update = iPropertiesUpdateArray[n2];
            IPeripheralDMContext peripheralDMContext = (IPeripheralDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IPeripheralDMContext.class);
            if (peripheralDMContext == null) {
                this.handleFailedUpdate((IViewerUpdate)update);
                return;
            }
            this.setProperties(update, peripheralDMContext);
            update.done();
            ++n2;
        }
    }

    protected IElementLabelProvider createLabelProvider() {
        PropertiesBasedLabelProvider labelProvider = new PropertiesBasedLabelProvider();
        LabelImage labelImage = new LabelImage(){

            public void updateAttribute(ILabelUpdate update, int columnIndex, IStatus status, Map<String, Object> properties) {
                ImageDescriptor descriptor = null;
                Boolean isSystem = (Boolean)properties.get(PeripheralsVMNode.PROPERTY_ISSYSTEM);
                descriptor = isSystem != null && isSystem != false ? Activator.getInstance().getImageDescriptor("system_peripheral") : Activator.getInstance().getImageDescriptor("peripheral");
                if (descriptor != null) {
                    update.setImageDescriptor(descriptor, columnIndex);
                }
            }
        };
        LabelAttribute[] labelAttributes = new LabelAttribute[]{new LabelText("{0}", new String[]{PROPERTY_NAME, PROPERTY_ISSYSTEM}), labelImage};
        LabelColumnInfo labelColumnInfo = new LabelColumnInfo(labelAttributes);
        labelProvider.setColumnInfo("column.peripheral", labelColumnInfo);
        labelAttributes = new LabelAttribute[]{new LabelText("{0}", new String[]{PROPERTY_ADDRESS})};
        labelColumnInfo = new LabelColumnInfo(labelAttributes);
        labelProvider.setColumnInfo("column.address", labelColumnInfo);
        labelAttributes = new LabelAttribute[]{new LabelText("{0}", new String[]{PROPERTY_DESCRIPTION})};
        labelColumnInfo = new LabelColumnInfo(labelAttributes);
        labelProvider.setColumnInfo("column.description", labelColumnInfo);
        return labelProvider;
    }

    protected void setProperties(IPropertiesUpdate update, IPeripheralDMContext context) {
        assert (context != null);
        update.setProperty(PROPERTY_NAME, (Object)context.getName());
        update.setProperty(PROPERTY_ADDRESS, (Object)context.getHexAddress());
        update.setProperty(PROPERTY_DESCRIPTION, (Object)context.getDescription());
        update.setProperty(PROPERTY_ISSYSTEM, (Object)new Boolean(context.isSystem()));
    }

    protected boolean getChecked(TreePath treePath, IPresentationContext presentationContext) throws CoreException {
        Object pathSegment = treePath.getLastSegment();
        if (pathSegment instanceof PeripheralsVMContext) {
            PeripheralsVMContext peripheralVMContext = (PeripheralsVMContext)((Object)pathSegment);
            PeripheralDMContext peripheralDMContext = (PeripheralDMContext)peripheralVMContext.getDMContext();
            return peripheralDMContext.hasMemoryMonitor();
        }
        return false;
    }

    protected boolean getGrayed(TreePath treePath, IPresentationContext presentationContext) throws CoreException {
        return false;
    }

    public String toString() {
        return "PeripheralsVMNode(" + this.getSession().getId() + ")";
    }

    public class PeripheralsVMContext
    extends AbstractDMVMNode.DMVMContext {
        protected PeripheralsVMContext(IDMContext context) {
            super((AbstractDMVMNode)PeripheralsVMNode.this, context);
        }
    }
}

