/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.packs.core.data;

import ilg.gnumcueclipse.core.Xml;
import ilg.gnumcueclipse.packs.core.jstree.JsArray;
import ilg.gnumcueclipse.packs.core.jstree.JsObject;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class XmlJsGenericParser {
    public static final String PROPERTY_XML_CONTENT = "$CONTENT";

    public String isCollection(String name, Element el) {
        return null;
    }

    public String isMalformedCollectionMember(String name, Element el) {
        return null;
    }

    public JsObject parse(Document document) {
        Element el = document.getDocumentElement();
        JsObject tree = new JsObject();
        String nodeName = el.getNodeName();
        tree.putProperty(nodeName, this.parseRecusive(el, null));
        return tree;
    }

    private JsObject parseRecusive(Element el, String skipName) {
        String nodeName = el.getNodeName();
        String collectionDef = this.isCollection(nodeName, el);
        if (collectionDef != null) {
            String[] arr = collectionDef.split("[|]");
            if (arr.length == 2) {
                return this.parseCollection(el, arr[0], arr[1]);
            }
            System.out.println("Internal error, collection definition " + collectionDef);
        }
        JsObject node = new JsObject();
        NamedNodeMap attributes = el.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                String attributeName = attributes.item(i).getNodeName();
                node.putProperty(attributeName, el.getAttribute(attributeName));
                ++i;
            }
        }
        List children = Xml.getChildrenElementsList((Element)el);
        for (Element child : children) {
            String childName = child.getNodeName();
            if (childName.equals(skipName)) continue;
            String malformedCollectionDef = this.isMalformedCollectionMember(childName, el);
            if (malformedCollectionDef != null) {
                String[] arr = malformedCollectionDef.split("[|]");
                if (arr.length == 2) {
                    this.parseMalformedCollection(node, child, arr[0], arr[1]);
                    continue;
                }
                System.out.println("Internal error, collection definition " + malformedCollectionDef);
            }
            Object value = null;
            List grandChildren = Xml.getChildrenElementsList((Element)child);
            if (grandChildren.isEmpty()) {
                String content = Xml.getElementContent((Element)child);
                NamedNodeMap childAttributes = child.getAttributes();
                if (childAttributes == null || childAttributes.getLength() == 0) {
                    value = content;
                } else {
                    JsObject subNode = new JsObject();
                    value = subNode;
                    subNode.putNonEmptyProperty(PROPERTY_XML_CONTENT, content);
                    int i = 0;
                    while (i < childAttributes.getLength()) {
                        String attributeName = childAttributes.item(i).getNodeName();
                        subNode.putProperty(attributeName, child.getAttribute(attributeName));
                        ++i;
                    }
                }
            } else {
                value = this.parseRecusive(child, null);
            }
            Object propertyValue = node.getProperty(childName);
            if (propertyValue == null) {
                node.putProperty(childName, value);
                continue;
            }
            JsArray array = null;
            node.removeProperty(childName);
            if (propertyValue instanceof JsArray) {
                array = (JsArray)propertyValue;
            } else {
                array = new JsArray();
                if (propertyValue instanceof JsObject) {
                    array.add((JsObject)propertyValue);
                } else if (propertyValue instanceof String) {
                    array.add((String)propertyValue);
                }
            }
            node.putProperty(childName, array);
            array.add(value);
        }
        return node;
    }

    private JsObject parseCollection(Element el, String collection, String name) {
        JsObject node = new JsObject();
        List children = Xml.getChildrenElementsList((Element)el, (String)collection);
        for (Element child : children) {
            Element nameElement = Xml.getFirstChildElement((Element)child, (String)name);
            String content = Xml.getElementContent((Element)nameElement);
            if (node.hasProperty(content)) {
                System.out.println("Collection property " + content + " already defined, ignored.");
                continue;
            }
            node.putProperty(content, this.parseRecusive(child, name));
        }
        return node;
    }

    private void parseMalformedCollection(JsObject node, Element el, String collection, String name) {
        Object collectionNode = node.getProperty(collection);
        if (collectionNode == null) {
            collectionNode = new JsObject();
            node.putProperty(collection, collectionNode);
        } else if (!(collectionNode instanceof JsObject)) {
            System.out.println("Malformed collection " + collection + " already defined, ignored.");
            return;
        }
        Element nameElement = Xml.getFirstChildElement((Element)el, (String)name);
        String content = Xml.getElementContent((Element)nameElement);
        if (((JsObject)collectionNode).hasProperty(content)) {
            System.out.println("Collection property " + content + " already defined, ignored.");
            return;
        }
        ((JsObject)collectionNode).putProperty(content, this.parseRecusive(el, name));
    }
}

