/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.templates.core.processes;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateEngineHelper;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessHelper;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.core.templateengine.process.processes.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.embedcdt.internal.templates.core.Activator;
import org.eclipse.embedcdt.templates.core.Utils;

public class ConditionalCopyFoldersRecursive
extends ProcessRunner {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        IProject projectHandle = null;
        ProcessArgument[][] folders = null;
        String condition = null;
        ProcessArgument[] processArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument arg = processArgumentArray[n2];
            String argName = arg.getName();
            if (argName.equals("projectName")) {
                projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(arg.getSimpleValue());
            } else if (argName.equals("folders")) {
                folders = arg.getComplexArrayValue();
            } else if (argName.equals("condition")) {
                condition = arg.getSimpleValue();
            }
            ++n2;
        }
        if (projectHandle == null) {
            throw new ProcessFailureException(this.getProcessMessage(processId, 4, "projectName not specified"));
        }
        if (folders == null) {
            throw new ProcessFailureException(this.getProcessMessage(processId, 4, "No folders"));
        }
        if (!Utils.isConditionSatisfied(condition)) {
            return;
        }
        int i = 0;
        while (i < folders.length) {
            void folder = folders[i];
            String folderSourcePath = null;
            String folderTargetPath = null;
            String pattern = null;
            boolean recursive = false;
            boolean replaceable = false;
            void var18_23 = folder;
            int n3 = ((void)var18_23).length;
            int n4 = 0;
            while (n4 < n3) {
                void arg = var18_23[n4];
                String argName = arg.getName();
                if (argName.equals("source")) {
                    folderSourcePath = arg.getSimpleValue();
                } else if (argName.equals("target")) {
                    folderTargetPath = arg.getSimpleValue();
                } else if (argName.equals("pattern")) {
                    pattern = arg.getSimpleValue().trim();
                } else if (argName.equals("replaceable")) {
                    replaceable = arg.getSimpleValue().trim().equals("true");
                } else if (argName.equals("recursive")) {
                    recursive = arg.getSimpleValue().trim().equals("true");
                }
                ++n4;
            }
            if (folderSourcePath == null) {
                throw new ProcessFailureException(this.getProcessMessage(processId, 4, "No source"));
            }
            if (folderTargetPath == null || folderTargetPath.isEmpty()) {
                folderTargetPath = folderSourcePath;
            }
            File sourceDir = new File(folderSourcePath);
            File targetDir = new File(folderTargetPath);
            this.copyFolderRecursive(template, processId, projectHandle, sourceDir, targetDir, pattern, replaceable, recursive);
            ++i;
        }
        try {
            projectHandle.refreshLocal(2, null);
        }
        catch (CoreException e) {
            throw new ProcessFailureException(String.valueOf(Messages.getString((String)"AddFiles.7")) + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyFolderRecursive(TemplateCore template, String processId, IProject projectHandle, File sourceDir, File targetDir, String pattern, boolean replaceable, boolean recursive) throws ProcessFailureException {
        File actualSourceDir = sourceDir;
        try {
            if (!sourceDir.isAbsolute()) {
                URL folderURL = TemplateEngineHelper.getTemplateResourceURLRelativeToTemplate((TemplateCore)template, (String)sourceDir.toString());
                if (folderURL == null) {
                    throw new ProcessFailureException(this.getProcessMessage(processId, 4, String.valueOf(Messages.getString((String)"AddFiles.1")) + sourceDir.toString()));
                }
                actualSourceDir = new File(folderURL.getFile());
            }
        }
        catch (IOException e) {
            Activator.log((Throwable)e);
        }
        if (!actualSourceDir.isDirectory()) return;
        File[] fileArray = actualSourceDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            String fileName = child.getName();
            if (pattern != null && pattern.length() > 0 && !fileName.matches(pattern)) {
                if (Activator.getInstance().isDebugging()) {
                    System.out.println(String.valueOf(fileName) + " skipped");
                }
            } else if (child.isDirectory()) {
                if (recursive) {
                    this.copyFolderRecursive(template, processId, projectHandle, new File(actualSourceDir, fileName), new File(targetDir, fileName), pattern, replaceable, recursive);
                } else if (Activator.getInstance().isDebugging()) {
                    System.out.println(String.valueOf(fileName) + " skipped");
                }
            } else {
                URL sourceURL;
                try {
                    sourceURL = child.toURL();
                }
                catch (MalformedURLException e2) {
                    throw new ProcessFailureException(String.valueOf(Messages.getString((String)"AddFiles.2")) + sourceDir.toString());
                }
                InputStream contents = null;
                if (replaceable) {
                    String fileContents;
                    try {
                        fileContents = ProcessHelper.readFromFile((URL)sourceURL);
                    }
                    catch (IOException e) {
                        throw new ProcessFailureException(String.valueOf(Messages.getString((String)"AddFiles.3")) + sourceDir.toString());
                    }
                    fileContents = ProcessHelper.getValueAfterExpandingMacros((String)fileContents, (Set)ProcessHelper.getReplaceKeys((String)fileContents), (Map)template.getValueStore());
                    contents = new ByteArrayInputStream(fileContents.getBytes());
                } else {
                    try {
                        contents = sourceURL.openStream();
                    }
                    catch (IOException e) {
                        throw new ProcessFailureException(this.getProcessMessage(processId, 4, String.valueOf(Messages.getString((String)"AddFiles.4")) + sourceDir.toString()));
                    }
                }
                try {
                    File concat;
                    IFile iFile;
                    IFolder iFolder = projectHandle.getFolder(targetDir.toString());
                    if (!iFolder.exists()) {
                        ProcessHelper.mkdirs((IProject)projectHandle, (IFolder)projectHandle.getFolder(iFolder.getProjectRelativePath()));
                    }
                    if ((iFile = projectHandle.getFile((concat = new File(targetDir, fileName)).getPath())).exists()) {
                        if (!replaceable) throw new ProcessFailureException(Messages.getString((String)"AddFiles.5"));
                        iFile.setContents(contents, true, true, null);
                    } else {
                        iFile.create(contents, true, null);
                        iFile.refreshLocal(1, null);
                    }
                }
                catch (CoreException e) {
                    throw new ProcessFailureException(String.valueOf(Messages.getString((String)"AddFiles.6")) + e.getMessage(), (Throwable)e);
                }
            }
            ++n2;
        }
    }
}

