/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.web.servlets;

import com.google.inject.Injector;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.parsley.composite.DialogControlFactory;
import org.eclipse.emf.parsley.config.Configurator;
import org.eclipse.emf.parsley.runtime.util.PolymorphicDispatcher;
import org.eclipse.emf.parsley.ui.provider.FeaturesProvider;
import org.eclipse.emf.parsley.ui.provider.FormFeatureCaptionProvider;
import org.eclipse.emf.parsley.ui.provider.ViewerLabelProvider;
import org.eclipse.emf.parsley.web.servlets.Application;
import org.eclipse.emf.parsley.web.servlets.DefaultRealm;
import org.eclipse.emf.parsley.web.servlets.JsonParsleyServlet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Text;

public class JsonDetailsServlet
extends JsonParsleyServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Injector injector = Application.getInstance(request).getInjector();
        Configurator configurator = Application.getInstance(request).getConfigurator();
        PrintWriter out = this.prepareOutput(response);
        String id = request.getParameter("id");
        String entity = request.getParameter("s");
        if (id != null) {
            String label;
            String imagePath;
            EClass clazz;
            out.write("{ ");
            Object element = Application.getInstance(request).get(id);
            EObject eObject = (EObject)element;
            ViewerLabelProvider labelProvider = (ViewerLabelProvider)injector.getInstance(ILabelProvider.class);
            DialogControlFactory dialogControlFactory = (DialogControlFactory)injector.getInstance(DialogControlFactory.class);
            FormFeatureCaptionProvider formFeatureCaptionProvider = (FormFeatureCaptionProvider)injector.getInstance(FormFeatureCaptionProvider.class);
            PolymorphicDispatcher imageDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"image", (int)1, (int)1, (Object)labelProvider);
            if (eObject != null) {
                clazz = eObject.eClass();
                imagePath = (String)imageDispatcher.invoke(new Object[]{element});
                label = labelProvider.getText((Object)eObject);
            } else {
                clazz = configurator.getEClass((Object)entity);
                imagePath = "";
                label = "";
            }
            List features = ((FeaturesProvider)injector.getInstance(FeaturesProvider.class)).getFeatures(clazz);
            out.write("\"icon\" : \"" + (imagePath != null ? imagePath : "") + "\" ");
            out.write(", \"label\" : \"" + label + "\" ");
            if (eObject == null) {
                eObject = EcoreUtil.create((EClass)clazz);
                Resource resource = Application.getInstance(request).getResource(entity);
                resource.getContents().add((Object)eObject);
                id = Application.getInstance(request).put(eObject);
            }
            EObject eObject1 = eObject;
            new DefaultRealm();
            dialogControlFactory.init(null, eObject1, (Composite)Application.getInstance(request).getShell());
            out.write(", \"id\" : \"" + id + "\" ");
            for (EStructuralFeature eStructuralFeature : features) {
                out.write(",");
                String featureName = eStructuralFeature.getName();
                String featureCaption = formFeatureCaptionProvider.getText(clazz, eStructuralFeature);
                out.write("\"" + featureName + "\" : {" + "\"caption\": \"" + featureCaption + "\",");
                String value = labelProvider.getText(eObject.eGet(eStructuralFeature));
                new DefaultRealm();
                Control control = dialogControlFactory.create(eStructuralFeature);
                if (control instanceof Text) {
                    Text text = (Text)control;
                    boolean multiLine = (text.getStyle() & 2) > 0;
                    String type = multiLine ? "textarea" : "text";
                    out.write(" \"type\": \"" + type + "\",");
                } else if (control instanceof Combo) {
                    String proposalsList = "";
                    Combo combo = (Combo)control;
                    String[] proposals = combo.getItems();
                    boolean first = true;
                    String[] stringArray = proposals;
                    int n = proposals.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String proposal = stringArray[n2];
                        if (!first) {
                            proposalsList = String.valueOf(proposalsList) + ",";
                        }
                        proposalsList = String.valueOf(proposalsList) + "\"" + proposal + "\"";
                        first = false;
                        ++n2;
                    }
                    out.write(" \"type\": \"combo\",");
                    out.write(" \"proposals\": [" + proposalsList + "],");
                } else if (control instanceof Button) {
                    out.write(" \"type\": \"button\",");
                } else if (control instanceof DateTime) {
                    out.write(" \"type\": \"datetime\",");
                }
                out.write(" \"value\": \"" + (value == null ? "" : value) + "\"" + "} ");
            }
            out.write("} ");
        }
        this.closeOutput(out);
    }
}

