/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.edit.action;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.parsley.edit.action.EditingDomainValidateAction;
import org.eclipse.emf.parsley.edit.action.EditingMenuBuilder;
import org.eclipse.emf.parsley.edit.domain.EditingDomainPresetStrategy;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class EditingActionManager {
    @Inject
    private EditingMenuBuilder editingMenuBuilder;
    @Inject
    private Provider<EditingDomainPresetStrategy> editingDomainStrategyProvider;

    public void initializeActions(IActionBars actionBars) {
        this.createActions();
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.editingMenuBuilder.getDeleteAction());
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.editingMenuBuilder.getCutAction());
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.editingMenuBuilder.getCopyAction());
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.editingMenuBuilder.getPasteAction());
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.editingMenuBuilder.getUndoAction());
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.editingMenuBuilder.getRedoAction());
    }

    public void createActions() {
        this.editingMenuBuilder.createActions();
        ISharedImages sharedImages = this.getSharedImages();
        this.editingMenuBuilder.getDeleteAction().setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.editingMenuBuilder.getCutAction().setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.editingMenuBuilder.getCopyAction().setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.editingMenuBuilder.getPasteAction().setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.editingMenuBuilder.getUndoAction().setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        this.editingMenuBuilder.getRedoAction().setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
    }

    protected ISharedImages getSharedImages() {
        return new ISharedImages(){

            public Image getImage(String symbolicName) {
                return this.getImageDescriptor(symbolicName).createImage();
            }

            public ImageDescriptor getImageDescriptor(String symbolicName) {
                return WorkbenchImages.getImageDescriptor((String)symbolicName);
            }
        };
    }

    public void shareGlobalActions(IPage page, IActionBars actionBars) {
        if (!(page instanceof IPropertySheetPage)) {
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.editingMenuBuilder.getDeleteAction());
            actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.editingMenuBuilder.getCutAction());
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.editingMenuBuilder.getCopyAction());
            actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.editingMenuBuilder.getPasteAction());
        }
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.editingMenuBuilder.getUndoAction());
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.editingMenuBuilder.getRedoAction());
    }

    public void setEditingDomain(EditingDomain editingDomain) {
        if (editingDomain != null) {
            EditingDomainPresetStrategy strategy = (EditingDomainPresetStrategy)this.editingDomainStrategyProvider.get();
            strategy.setEditingDomain(editingDomain);
            this.editingMenuBuilder.setEditingDomainFinderStrategy(strategy);
        }
    }

    public void updateSelection(ISelection selection) {
        this.editingMenuBuilder.updateSelection(selection);
    }

    public void updateUndoRedo() {
        this.editingMenuBuilder.updateUndoRedo();
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        this.editingMenuBuilder.menuAboutToShow(menuManager);
    }

    public void emfMenuAboutToShow(IMenuManager menuManager) {
        this.editingMenuBuilder.emfMenuAboutToShow(menuManager);
    }

    public EditingDomainValidateAction createValidateAction() {
        return this.editingMenuBuilder.createValidateAction();
    }

    public ControlAction createControlAction() {
        return this.editingMenuBuilder.createControlAction();
    }
}

