/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfatic.ui.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.emfatic.core.generator.ecore.GenerationPhase;
import org.eclipse.emf.emfatic.core.generator.ecore.TokenText;
import org.eclipse.emf.emfatic.core.generator.ecore.TokenTextBlankSep;
import org.eclipse.emf.emfatic.core.lang.gen.ast.Annotation;
import org.eclipse.emf.emfatic.core.lang.gen.ast.Attribute;
import org.eclipse.emf.emfatic.core.lang.gen.ast.BoundExceptWildcard;
import org.eclipse.emf.emfatic.core.lang.gen.ast.ClassDecl;
import org.eclipse.emf.emfatic.core.lang.gen.ast.ClassMemberDecls;
import org.eclipse.emf.emfatic.core.lang.gen.ast.CommaListBoundExceptWild;
import org.eclipse.emf.emfatic.core.lang.gen.ast.CompUnit;
import org.eclipse.emf.emfatic.core.lang.gen.ast.DataTypeDecl;
import org.eclipse.emf.emfatic.core.lang.gen.ast.EmfaticASTNode;
import org.eclipse.emf.emfatic.core.lang.gen.ast.EmfaticASTNodeVisitor;
import org.eclipse.emf.emfatic.core.lang.gen.ast.EmfaticTokenNode;
import org.eclipse.emf.emfatic.core.lang.gen.ast.EnumDecl;
import org.eclipse.emf.emfatic.core.lang.gen.ast.KeyEqualsValue;
import org.eclipse.emf.emfatic.core.lang.gen.ast.Operation;
import org.eclipse.emf.emfatic.core.lang.gen.ast.Param;
import org.eclipse.emf.emfatic.core.lang.gen.ast.Params;
import org.eclipse.emf.emfatic.core.lang.gen.ast.QualifiedID;
import org.eclipse.emf.emfatic.core.lang.gen.ast.Reference;
import org.eclipse.emf.emfatic.core.lang.gen.ast.SubPackageDecl;
import org.eclipse.emf.emfatic.core.lang.gen.ast.TopLevelDecls;
import org.eclipse.emf.emfatic.core.lang.gen.ast.TypeParam;
import org.eclipse.emf.emfatic.core.lang.gen.ast.TypeParamsInfo;
import org.eclipse.gymnast.runtime.core.ast.ASTNode;
import org.eclipse.gymnast.runtime.core.outline.IOutlineBuilder;
import org.eclipse.gymnast.runtime.core.outline.OutlineNode;
import org.eclipse.swt.graphics.Image;

public class EmfaticOutlineBuilder
implements IOutlineBuilder {
    CompUnit compUnit = null;
    Map<ASTNode, OutlineNode> a2o = new HashMap<ASTNode, OutlineNode>();
    private static EcoreItemProviderAdapterFactory _adapterFactory;
    private static Image _packageImage;
    private static Image _classImage;
    private static Image _enumImage;
    private static Image _dataTypeImage;
    private static Image _operationImage;
    private static Image _annotationImage;
    private static Image _attributeImage;
    private static Image _referenceImage;
    private static Image _typeParamImage;
    private static Image _paramImage;
    private static Image _genericExceptionImage;
    private static Image _genericElementTypeImage;
    private static Image _genericSuperTypeImage;
    private static Image _genericWildcardImage;

    public OutlineNode[] buildOutline(ASTNode parseRoot) {
        this.a2o.clear();
        if (parseRoot instanceof CompUnit && parseRoot != null && ((CompUnit)parseRoot).getPackageDecl() != null) {
            this.compUnit = (CompUnit)parseRoot;
            Image image = EmfaticOutlineBuilder.getPackageImage();
            String packageName = GenerationPhase.getIDText((QualifiedID)this.compUnit.getPackageDecl().getName());
            OutlineNode outlineNode = new OutlineNode((ASTNode)this.compUnit.getPackageDecl(), packageName, image);
            this.a2o.put((ASTNode)this.compUnit.getPackageDecl().getName(), outlineNode);
            this.a2o.put((ASTNode)this.compUnit.getPackageDecl().getPackage_KW(), outlineNode);
            this.a2o.put((ASTNode)this.compUnit.getPackageDecl().getSemi(), outlineNode);
            this.doPackageContents(outlineNode, this.compUnit.getTopLevelDecls());
            this.compUnit.setCst2Outline(this.a2o);
            OutlineNode[] outlineNodes = new OutlineNode[]{outlineNode};
            return outlineNodes;
        }
        return null;
    }

    private void doPackageContents(final OutlineNode parentNode, TopLevelDecls topLevelDecls) {
        new EmfaticASTNodeVisitor(){

            private void addAttribute(Attribute c, OutlineNode outlineNode) {
                Attribute at = c;
                String strTypeWithMulti = TokenTextBlankSep.Get((EmfaticASTNode)c.getTypeWithMulti());
                String strName = GenerationPhase.getIDText((EmfaticTokenNode)at.getName());
                OutlineNode n = new OutlineNode((ASTNode)at.getName(), String.valueOf(strName) + " : " + strTypeWithMulti, EmfaticOutlineBuilder.getAttributeImage());
                EmfaticOutlineBuilder.this.a2o.put((ASTNode)at, n);
                ASTNode[] atAnns = at.getAnnotations().getChildren();
                this.annotate(atAnns, n);
                outlineNode.addChild(n);
            }

            private void addClassDeclMembers(ClassDecl classDecl, OutlineNode outlineNode) {
                ClassMemberDecls ms = classDecl.getClassMemberDecls();
                ASTNode[] ans = classDecl.getAnnotations().getChildren();
                this.annotate(ans, outlineNode);
                ASTNode[] aSTNodeArray = ms.getChildren();
                int n = aSTNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ASTNode c = aSTNodeArray[n2];
                    if (c instanceof Attribute) {
                        this.addAttribute((Attribute)c, outlineNode);
                    }
                    if (c instanceof Reference) {
                        this.addReference((Reference)c, outlineNode);
                    }
                    if (c instanceof Operation) {
                        this.addOperation((Operation)c, outlineNode);
                    }
                    ++n2;
                }
            }

            private void addOperation(Operation c, OutlineNode outlineNode) {
                Operation o = c;
                String strResultType = TokenTextBlankSep.Get((EmfaticASTNode)o.getResType());
                String strName = GenerationPhase.getIDText((EmfaticTokenNode)o.getName());
                OutlineNode n = new OutlineNode((ASTNode)o.getName(), String.valueOf(strName) + " : " + strResultType, EmfaticOutlineBuilder.getOperationImage());
                EmfaticOutlineBuilder.this.a2o.put((ASTNode)o, n);
                ASTNode[] oAnns = o.getAnnotations().getChildren();
                this.annotate(oAnns, n);
                outlineNode.addChild(n);
                CommaListBoundExceptWild excs = c.getExceptions();
                this.addExceptions(excs, n);
                TypeParamsInfo tpi = c.getTypeParamsInfo();
                this.addTypeParams(tpi, n);
                this.addParams(o.getParams(), n);
            }

            private void addExceptions(CommaListBoundExceptWild excs, OutlineNode n) {
                if (excs == null) {
                    return;
                }
                ASTNode[] aSTNodeArray = excs.getChildren();
                int n2 = aSTNodeArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    ASTNode en = aSTNodeArray[n3];
                    if (en instanceof BoundExceptWildcard) {
                        BoundExceptWildcard bew = (BoundExceptWildcard)en;
                        OutlineNode e = null;
                        String strText = TokenText.Get((EmfaticASTNode)bew);
                        e = bew.getOneOrMoreTypeArgs() != null ? new OutlineNode(en, strText, EmfaticOutlineBuilder.getGenericExceptionImage()) : new OutlineNode(en, strText);
                        EmfaticOutlineBuilder.this.a2o.put((ASTNode)bew, e);
                        n.addChild(e);
                    }
                    ++n3;
                }
            }

            private void addParams(Params params, OutlineNode on) {
                ASTNode[] ps;
                if (params == null) {
                    return;
                }
                ASTNode[] aSTNodeArray = ps = params.getChildren();
                int n = ps.length;
                int n2 = 0;
                while (n2 < n) {
                    ASTNode pn = aSTNodeArray[n2];
                    if (pn instanceof Param) {
                        Param p = (Param)pn;
                        String strTypeWithMulti = TokenTextBlankSep.Get((EmfaticASTNode)p.getTypeWithMulti());
                        String strName = GenerationPhase.getIDText((EmfaticTokenNode)p.getName());
                        OutlineNode n3 = new OutlineNode((ASTNode)p, String.valueOf(strName) + " : " + strTypeWithMulti, EmfaticOutlineBuilder.getParamImage());
                        EmfaticOutlineBuilder.this.a2o.put((ASTNode)p, n3);
                        on.addChild(n3);
                    }
                    ++n2;
                }
            }

            private void addReference(Reference c, OutlineNode outlineNode) {
                Reference r = c;
                String strTypeWithMulti = TokenTextBlankSep.Get((EmfaticASTNode)c.getTypeWithMulti());
                String strName = GenerationPhase.getIDText((EmfaticTokenNode)r.getName());
                OutlineNode n = new OutlineNode((ASTNode)r.getName(), String.valueOf(strName) + " : " + strTypeWithMulti, EmfaticOutlineBuilder.getReferenceImage());
                EmfaticOutlineBuilder.this.a2o.put((ASTNode)r, n);
                ASTNode[] rAnns = r.getAnnotations().getChildren();
                this.annotate(rAnns, n);
                outlineNode.addChild(n);
            }

            private void addTypeParams(TypeParamsInfo tpi, OutlineNode outlineNode) {
                ASTNode[] tps;
                if (tpi == null || tpi.getOneOrMoreTypeParams() == null) {
                    return;
                }
                ASTNode[] aSTNodeArray = tps = tpi.getOneOrMoreTypeParams().getChildren();
                int n = tps.length;
                int n2 = 0;
                while (n2 < n) {
                    ASTNode tpn = aSTNodeArray[n2];
                    if (tpn instanceof TypeParam) {
                        TypeParam tp = (TypeParam)tpn;
                        String strTypeVarName = GenerationPhase.getIDText((EmfaticTokenNode)tp.getTypeVarName());
                        OutlineNode n3 = new OutlineNode((ASTNode)tp, strTypeVarName, EmfaticOutlineBuilder.getTypeParamImage());
                        EmfaticOutlineBuilder.this.a2o.put((ASTNode)tp, n3);
                        outlineNode.addChild(n3);
                        if (tp.getTypeBoundsInfo() != null && tp.getTypeBoundsInfo().getOneOrMoreTypeParamBounds() != null) {
                            ASTNode[] boundNodes;
                            ASTNode[] aSTNodeArray2 = boundNodes = tp.getTypeBoundsInfo().getOneOrMoreTypeParamBounds().getChildren();
                            int n4 = boundNodes.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                ASTNode bound = aSTNodeArray2[n5];
                                String boundLabel = TokenTextBlankSep.Get((EmfaticASTNode)((EmfaticASTNode)bound));
                                OutlineNode n22 = new OutlineNode(bound, boundLabel);
                                EmfaticOutlineBuilder.this.a2o.put(bound, n22);
                                n3.addChild(n22);
                                ++n5;
                            }
                        }
                    }
                    ++n2;
                }
            }

            private void annotate(ASTNode[] as, OutlineNode on) {
                ASTNode[] aSTNodeArray = as;
                int n = as.length;
                int n2 = 0;
                while (n2 < n) {
                    ASTNode astNode = aSTNodeArray[n2];
                    Annotation astAnn = (Annotation)astNode;
                    String strSource = TokenText.Get((EmfaticASTNode)astAnn.getSource());
                    OutlineNode n3 = new OutlineNode(astNode, strSource, EmfaticOutlineBuilder.getAnnotationImage());
                    EmfaticOutlineBuilder.this.a2o.put((ASTNode)astAnn, n3);
                    ASTNode[] aSTNodeArray2 = astAnn.getKeyEqualsValueList().getChildren();
                    int n4 = aSTNodeArray2.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        ASTNode kv = aSTNodeArray2[n5];
                        if (kv instanceof KeyEqualsValue) {
                            String strKey = kv.getChild(0).getChild(0).getFirstChild().getText();
                            String strValue = kv.getChild(2).getChild(0).getText();
                            String strKV = String.valueOf(strKey) + " = " + strValue;
                            OutlineNode n22 = new OutlineNode(kv, strKV, null);
                            EmfaticOutlineBuilder.this.a2o.put(kv, n22);
                            n3.addChild(n22);
                        }
                        ++n5;
                    }
                    on.addChild(n3);
                    ++n2;
                }
            }

            public boolean beginVisit(ClassDecl classDecl) {
                String name = classDecl.getName().getText();
                Image image = EmfaticOutlineBuilder.getClassImage();
                OutlineNode outlineNode = new OutlineNode((ASTNode)classDecl, name, image);
                EmfaticOutlineBuilder.this.a2o.put((ASTNode)classDecl, outlineNode);
                this.addTypeParams(classDecl.getTypeParamsInfo(), outlineNode);
                this.addClassDeclMembers(classDecl, outlineNode);
                parentNode.addChild(outlineNode);
                return false;
            }

            public boolean beginVisit(DataTypeDecl dataTypeDecl) {
                String name = dataTypeDecl.getName().getText();
                Image image = EmfaticOutlineBuilder.getDataTypeImage();
                OutlineNode outlineNode = new OutlineNode((ASTNode)dataTypeDecl, name, image);
                EmfaticOutlineBuilder.this.a2o.put((ASTNode)dataTypeDecl, outlineNode);
                parentNode.addChild(outlineNode);
                return false;
            }

            public boolean beginVisit(EnumDecl enumDecl) {
                String name = enumDecl.getName().getText();
                Image image = EmfaticOutlineBuilder.getEnumImage();
                OutlineNode outlineNode = new OutlineNode((ASTNode)enumDecl, name, image);
                EmfaticOutlineBuilder.this.a2o.put((ASTNode)enumDecl, outlineNode);
                parentNode.addChild(outlineNode);
                return false;
            }

            public boolean beginVisit(SubPackageDecl subPackageDecl) {
                String name = GenerationPhase.getIDText((EmfaticTokenNode)subPackageDecl.getName());
                Image image = EmfaticOutlineBuilder.getPackageImage();
                OutlineNode outlineNode = new OutlineNode((ASTNode)subPackageDecl, name, image);
                EmfaticOutlineBuilder.this.a2o.put((ASTNode)subPackageDecl.getName(), outlineNode);
                EmfaticOutlineBuilder.this.a2o.put((ASTNode)subPackageDecl.getPackage_KW(), outlineNode);
                EmfaticOutlineBuilder.this.a2o.put((ASTNode)subPackageDecl.getLcurly(), outlineNode);
                parentNode.addChild(outlineNode);
                EmfaticOutlineBuilder.this.doPackageContents(outlineNode, subPackageDecl.getTopLevelDecls());
                return false;
            }
        }.visit((EmfaticASTNode)topLevelDecls);
    }

    private static AdapterFactory getAdapterFactory() {
        if (_adapterFactory == null) {
            _adapterFactory = new EcoreItemProviderAdapterFactory();
        }
        return _adapterFactory;
    }

    static Image getPackageImage() {
        if (_packageImage == null) {
            EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
            _packageImage = EmfaticOutlineBuilder.getImage(ePackage);
        }
        return _packageImage;
    }

    static Image getClassImage() {
        if (_classImage == null) {
            EClass ePackage = EcoreFactory.eINSTANCE.createEClass();
            _classImage = EmfaticOutlineBuilder.getImage(ePackage);
        }
        return _classImage;
    }

    static Image getEnumImage() {
        if (_enumImage == null) {
            EEnum ePackage = EcoreFactory.eINSTANCE.createEEnum();
            _enumImage = EmfaticOutlineBuilder.getImage(ePackage);
        }
        return _enumImage;
    }

    static Image getDataTypeImage() {
        if (_dataTypeImage == null) {
            EDataType ePackage = EcoreFactory.eINSTANCE.createEDataType();
            _dataTypeImage = EmfaticOutlineBuilder.getImage(ePackage);
        }
        return _dataTypeImage;
    }

    public static Image getOperationImage() {
        if (_operationImage == null) {
            EOperation eOperation = EcoreFactory.eINSTANCE.createEOperation();
            _operationImage = EmfaticOutlineBuilder.getImage(eOperation);
        }
        return _operationImage;
    }

    public static Image getAnnotationImage() {
        if (_annotationImage == null) {
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            _annotationImage = EmfaticOutlineBuilder.getImage(eAnnotation);
        }
        return _annotationImage;
    }

    public static Image getAttributeImage() {
        if (_attributeImage == null) {
            EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
            _attributeImage = EmfaticOutlineBuilder.getImage(eAttribute);
        }
        return _attributeImage;
    }

    public static Image getReferenceImage() {
        if (_referenceImage == null) {
            EReference eReference = EcoreFactory.eINSTANCE.createEReference();
            _referenceImage = EmfaticOutlineBuilder.getImage(eReference);
        }
        return _referenceImage;
    }

    static Image getTypeParamImage() {
        if (_typeParamImage == null) {
            ETypeParameter etp = EcoreFactory.eINSTANCE.createETypeParameter();
            _typeParamImage = EmfaticOutlineBuilder.getImage(etp);
        }
        return _typeParamImage;
    }

    static Image getParamImage() {
        if (_paramImage == null) {
            EParameter ep = EcoreFactory.eINSTANCE.createEParameter();
            _paramImage = EmfaticOutlineBuilder.getImage(ep);
        }
        return _paramImage;
    }

    static Image getGenericExceptionImage() {
        if (_genericExceptionImage == null) {
            _genericExceptionImage = (Image)EcoreEditPlugin.INSTANCE.getImage("full/obj16/EGenericException");
        }
        return _genericExceptionImage;
    }

    static Image getGenericElementTypeImage() {
        if (_genericElementTypeImage == null) {
            _genericElementTypeImage = (Image)EcoreEditPlugin.INSTANCE.getImage("full/obj16/EGenericElementType");
        }
        return _genericElementTypeImage;
    }

    static Image getGenericSuperTypeImage() {
        if (_genericSuperTypeImage == null) {
            _genericSuperTypeImage = (Image)EcoreEditPlugin.INSTANCE.getImage("full/obj16/EGenericSuperType");
        }
        return _genericSuperTypeImage;
    }

    static Image getGenericWildcardImage() {
        if (_genericWildcardImage == null) {
            _genericWildcardImage = (Image)EcoreEditPlugin.INSTANCE.getImage("full/obj16/EGenericWildcard");
        }
        return _genericWildcardImage;
    }

    private static Image getImage(Object eObject) {
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)EmfaticOutlineBuilder.getAdapterFactory().adapt(eObject, IItemLabelProvider.class);
        Object imageObject = itemLabelProvider.getImage(eObject);
        Image image = ExtendedImageRegistry.getInstance().getImage(imageObject);
        return image;
    }

    public static Image overlayImage(Image first, Image second) {
        ArrayList<Image> images = new ArrayList<Image>(2);
        images.add(first);
        images.add(second);
        ComposedImage imageObject = new ComposedImage(images);
        Image image = (Image)imageObject.getImages().get(0);
        return image;
    }
}

