/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.custom.model.impl;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.custom.model.VCustomDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.spi.core.services.structuralchange.EMFFormsStructuralChangeTester;
import org.eclipse.emfforms.spi.core.services.structuralchange.StructuralChangeTesterInternal;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component
public class StructuralChangeCustomDMRTester
implements StructuralChangeTesterInternal {
    private EMFFormsStructuralChangeTester emfFormsStructuralChangeTester;
    private BundleContext bundleContext;
    private ServiceReference<EMFFormsStructuralChangeTester> emfFormsStructuralChangeTesterServiceReference;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        if (this.emfFormsStructuralChangeTesterServiceReference != null) {
            bundleContext.ungetService(this.emfFormsStructuralChangeTesterServiceReference);
            this.emfFormsStructuralChangeTester = null;
        }
    }

    private EMFFormsStructuralChangeTester getEMFFormsStructuralChangeTester() {
        if (this.emfFormsStructuralChangeTester == null) {
            this.emfFormsStructuralChangeTesterServiceReference = this.bundleContext.getServiceReference(EMFFormsStructuralChangeTester.class);
            if (this.emfFormsStructuralChangeTesterServiceReference == null) {
                throw new IllegalStateException("No EMFFormsDomainExpander available!");
            }
            this.emfFormsStructuralChangeTester = (EMFFormsStructuralChangeTester)this.bundleContext.getService(this.emfFormsStructuralChangeTesterServiceReference);
        }
        return this.emfFormsStructuralChangeTester;
    }

    void setEMFFormsStructuralChangeTester(EMFFormsStructuralChangeTester emfFormsStructuralChangeTester) {
        this.emfFormsStructuralChangeTester = emfFormsStructuralChangeTester;
    }

    public double isApplicable(VDomainModelReference reference) {
        if (VCustomDomainModelReference.class.isInstance(reference)) {
            return 5.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public boolean isStructureChanged(VDomainModelReference reference, EObject domainRootObject, ModelChangeNotification notification) {
        VCustomDomainModelReference customDMR = (VCustomDomainModelReference)VCustomDomainModelReference.class.cast(reference);
        if (!customDMR.isControlChecked()) {
            return false;
        }
        boolean result = true;
        for (VDomainModelReference dmr : customDMR.getDomainModelReferences()) {
            result &= this.getEMFFormsStructuralChangeTester().isStructureChanged(dmr, domainRootObject, notification);
        }
        return result;
    }
}

