/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.accesscontrol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.AccessControl;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.Messages;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.PAPrivileges;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.ACUserContainer;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.AuthenticationControlType;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.factory.AuthenticationControlFactory;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers.AbstractAuthenticationControl;
import org.eclipse.emf.emfstore.internal.server.core.MethodInvocation;
import org.eclipse.emf.emfstore.internal.server.core.MonitorProvider;
import org.eclipse.emf.emfstore.internal.server.core.helper.EmfStoreMethod;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.exceptions.SessionTimedOutException;
import org.eclipse.emf.emfstore.internal.server.model.AuthenticationInformation;
import org.eclipse.emf.emfstore.internal.server.model.ClientVersionInfo;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.ProjectAdminRole;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.Role;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.ServerAdmin;
import org.eclipse.emf.emfstore.internal.server.model.dao.ACDAOFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessControlImpl
implements AccessControl {
    private static final String MONITOR_NAME = "authentication";
    private final Map<SessionId, ACUserContainer> sessionUserMap;
    private EnumMap<EmfStoreMethod.MethodId, AccessLevel> accessMap;
    private AbstractAuthenticationControl authenticationControl;
    private final ACDAOFacade daoFacade;

    public AccessControlImpl(ACDAOFacade acDAOFacade) throws FatalESException {
        this.daoFacade = acDAOFacade;
        this.sessionUserMap = new LinkedHashMap<SessionId, ACUserContainer>();
        AuthenticationControlType authenticationControlType = ServerConfiguration.AUTHENTICATION_POLICY_DEFAULT;
        String property = ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.policy");
        if (property != null) {
            authenticationControlType = AuthenticationControlType.valueOf(property);
        }
        this.authenticationControl = AuthenticationControlFactory.INSTANCE.createAuthenticationControl(authenticationControlType);
    }

    private void initAccessMap() {
        if (this.accessMap != null) {
            return;
        }
        this.accessMap = new EnumMap(EmfStoreMethod.MethodId.class);
        this.addAccessMapping(AccessLevel.PROJECT_READ, EmfStoreMethod.MethodId.GETPROJECT, EmfStoreMethod.MethodId.GETEMFPROPERTIES, EmfStoreMethod.MethodId.GETHISTORYINFO, EmfStoreMethod.MethodId.GETCHANGES, EmfStoreMethod.MethodId.RESOLVEVERSIONSPEC, EmfStoreMethod.MethodId.DOWNLOADFILECHUNK);
        this.addAccessMapping(AccessLevel.PROJECT_WRITE, EmfStoreMethod.MethodId.SETEMFPROPERTIES, EmfStoreMethod.MethodId.TRANSMITPROPERTY, EmfStoreMethod.MethodId.UPLOADFILECHUNK, EmfStoreMethod.MethodId.CREATEVERSION, EmfStoreMethod.MethodId.GETBRANCHES);
        this.addAccessMapping(AccessLevel.PROJECT_ADMIN, EmfStoreMethod.MethodId.DELETEPROJECT, EmfStoreMethod.MethodId.REMOVETAG, EmfStoreMethod.MethodId.ADDTAG);
        this.addAccessMapping(AccessLevel.SERVER_ADMIN, EmfStoreMethod.MethodId.IMPORTPROJECTHISTORYTOSERVER, EmfStoreMethod.MethodId.EXPORTPROJECTHISTORYFROMSERVER, EmfStoreMethod.MethodId.REGISTEREPACKAGE);
        if (ServerConfiguration.isProjectAdminPrivileg(PAPrivileges.ShareProject)) {
            this.addAccessMapping(AccessLevel.PROJECT_ADMIN, EmfStoreMethod.MethodId.CREATEPROJECT, EmfStoreMethod.MethodId.CREATEEMPTYPROJECT);
        } else {
            this.addAccessMapping(AccessLevel.SERVER_ADMIN, EmfStoreMethod.MethodId.CREATEPROJECT, EmfStoreMethod.MethodId.CREATEEMPTYPROJECT);
        }
        this.addAccessMapping(AccessLevel.NONE, EmfStoreMethod.MethodId.GETPROJECTLIST, EmfStoreMethod.MethodId.RESOLVEUSER);
    }

    private void addAccessMapping(AccessLevel type, EmfStoreMethod.MethodId ... operationTypes) {
        EmfStoreMethod.MethodId[] methodIdArray = operationTypes;
        int n = operationTypes.length;
        int n2 = 0;
        while (n2 < n) {
            EmfStoreMethod.MethodId opType = methodIdArray[n2];
            this.accessMap.put(opType, type);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthenticationInformation logIn(String username, String password, ClientVersionInfo clientVersionInfo) throws AccessControlException {
        Object object = MonitorProvider.getInstance().getMonitor(MONITOR_NAME);
        synchronized (object) {
            ACUser user = this.resolveUser(username);
            AuthenticationInformation authenticationInformation = this.authenticationControl.logIn(user, user.getName(), password, clientVersionInfo);
            this.sessionUserMap.put(authenticationInformation.getSessionId(), new ACUserContainer(user));
            ACUser resolvedUser = this.resolveUser(authenticationInformation.getSessionId());
            authenticationInformation.setResolvedACUser(resolvedUser);
            return authenticationInformation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout(SessionId sessionId) throws AccessControlException {
        Object object = MonitorProvider.getInstance().getMonitor(MONITOR_NAME);
        synchronized (object) {
            if (sessionId == null) {
                throw new AccessControlException(Messages.AccessControlImpl_SessionID_Is_Null);
            }
            this.sessionUserMap.remove(sessionId);
        }
    }

    private ACUser resolveUser(String username) throws AccessControlException {
        Boolean ignoreCase = Boolean.parseBoolean(ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.matchusers.ignorecase", Boolean.FALSE.toString()));
        Object object = MonitorProvider.getInstance().getMonitor();
        synchronized (object) {
            for (ACUser user : this.daoFacade.getUsers()) {
                if (ignoreCase.booleanValue()) {
                    if (!user.getName().equalsIgnoreCase(username)) continue;
                    return user;
                }
                if (!user.getName().equals(username)) continue;
                return user;
            }
            throw new AccessControlException();
        }
    }

    @Override
    public void checkSession(SessionId sessionId) throws AccessControlException {
        if (!this.sessionUserMap.containsKey(sessionId)) {
            throw new SessionTimedOutException(Messages.AccessControlImpl_SessionID_Unknown);
        }
    }

    @Override
    public void checkWriteAccess(SessionId sessionId, ProjectId projectId, Set<EObject> modelElements) throws AccessControlException {
        this.checkSession(sessionId);
        ACUser user = this.getUser(sessionId);
        ArrayList<Role> roles = new ArrayList<Role>();
        roles.addAll((Collection<Role>)user.getRoles());
        roles.addAll(this.getRolesFromGroups((ACOrgUnit)user));
        if (!this.canWrite(roles, projectId, null)) {
            throw new AccessControlException(Messages.AccessControlImpl_Insufficient_Rights);
        }
    }

    private boolean canWrite(List<Role> roles, ProjectId projectId, EObject modelElement) throws AccessControlException {
        for (Role role : roles) {
            if (!role.canModify(projectId, modelElement) && !role.canCreate(projectId, modelElement) && !role.canDelete(projectId, modelElement)) continue;
            return true;
        }
        return false;
    }

    private boolean canRead(List<Role> roles, ProjectId projectId, EObject modelElement) throws AccessControlException {
        for (Role role : roles) {
            if (!role.canRead(projectId, modelElement)) continue;
            return true;
        }
        return false;
    }

    private List<Role> getRolesFromGroups(ACOrgUnit orgUnit) {
        ArrayList<Role> roles = new ArrayList<Role>();
        for (ACGroup group : this.getGroups(orgUnit)) {
            roles.addAll((Collection<Role>)group.getRoles());
        }
        return roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ACGroup> getGroups(ACOrgUnit orgUnit) {
        Object object = MonitorProvider.getInstance().getMonitor();
        synchronized (object) {
            ArrayList<ACGroup> groups = new ArrayList<ACGroup>();
            for (ACGroup group : this.daoFacade.getGroups()) {
                if (!group.getMembers().contains((Object)orgUnit)) continue;
                groups.add(group);
                for (ACGroup g : this.getGroups((ACOrgUnit)group)) {
                    if (groups.contains(g)) continue;
                    groups.add(g);
                }
            }
            return groups;
        }
    }

    private ACOrgUnit getOrgUnit(ACOrgUnitId orgUnitId) throws AccessControlException {
        Object object = MonitorProvider.getInstance().getMonitor();
        synchronized (object) {
            for (ACUser user : this.daoFacade.getUsers()) {
                if (!user.getId().equals(orgUnitId)) continue;
                return user;
            }
            for (ACGroup group : this.daoFacade.getGroups()) {
                if (!group.getId().equals(orgUnitId)) continue;
                return group;
            }
            throw new AccessControlException(Messages.AccessControlImpl_Given_OrgUnit_Does_Not_Exist);
        }
    }

    private ACUser getUser(ACOrgUnitId orgUnitId) throws AccessControlException {
        Object object = MonitorProvider.getInstance().getMonitor();
        synchronized (object) {
            for (ACUser user : this.daoFacade.getUsers()) {
                if (!user.getId().equals(orgUnitId)) continue;
                return user;
            }
            throw new AccessControlException(Messages.AccessControlImpl_Given_User_Does_Not_Exist);
        }
    }

    @Override
    public void checkReadAccess(SessionId sessionId, ProjectId projectId, Set<EObject> modelElements) throws AccessControlException {
        this.checkSession(sessionId);
        ACUser user = this.getUser(sessionId);
        ArrayList<Role> roles = new ArrayList<Role>();
        roles.addAll((Collection<Role>)user.getRoles());
        roles.addAll(this.getRolesFromGroups((ACOrgUnit)user));
        if (!this.canRead(roles, projectId, null)) {
            throw new AccessControlException(Messages.AccessControlImpl_Insufficient_Rights);
        }
    }

    @Override
    public boolean checkProjectAdminAccess(SessionId sessionId, ProjectId projectId, PAPrivileges privileg) throws AccessControlException {
        this.checkSession(sessionId);
        ACUser user = this.getUser(sessionId);
        ArrayList<Role> roles = new ArrayList<Role>();
        roles.addAll((Collection<Role>)user.getRoles());
        roles.addAll(this.getRolesFromGroups((ACOrgUnit)user));
        for (Role role : roles) {
            if (!this.isServerAdminRole(role)) continue;
            return true;
        }
        for (Role role : roles) {
            if (!this.isProjectAdminRole(role)) continue;
            if (!ServerConfiguration.isProjectAdminPrivileg(privileg)) {
                throw new AccessControlException(Messages.AccessControlImpl_PARole_Missing_Privilege);
            }
            if (projectId == null) {
                return false;
            }
            ProjectAdminRole paRole = (ProjectAdminRole)ProjectAdminRole.class.cast(role);
            if (!paRole.canAdministrate(projectId)) {
                throw new AccessControlException(Messages.AccessControlImpl_PARole_Missing_Privilege);
            }
            return false;
        }
        throw new AccessControlException(Messages.AccessControlImpl_Insufficient_Rights);
    }

    @Override
    public boolean checkProjectAdminAccessForOrgUnit(SessionId sessionId, ACOrgUnitId orgUnitId) throws AccessControlException {
        List<Role> allRoles = this.getAllRoles(orgUnitId);
        LinkedHashSet involvedProjects = new LinkedHashSet();
        ACUser user = this.getUser(sessionId);
        boolean hasServerAdminRole = this.hasServerAdminRole((ACOrgUnit)user);
        for (Role role : allRoles) {
            if ((this.isServerAdminRole(role) || this.isProjectAdminRole(role)) && !hasServerAdminRole) {
                throw new AccessControlException(Messages.AccessControlImpl_Not_Allowed_To_Remove_Other_Admin);
            }
            involvedProjects.addAll(role.getProjects());
        }
        if (hasServerAdminRole) {
            return true;
        }
        ProjectAdminRole paRole = null;
        for (Role role : user.getRoles()) {
            if (!this.isProjectAdminRole(role)) continue;
            paRole = (ProjectAdminRole)role;
            break;
        }
        if (paRole.getProjects().containsAll(involvedProjects)) {
            return false;
        }
        throw new AccessControlException(Messages.AccessControlImpl_Insufficient_Rights);
    }

    private boolean hasServerAdminRole(ACOrgUnit orgUnit) {
        for (Role role : orgUnit.getRoles()) {
            if (!this.isServerAdminRole(role)) continue;
            return true;
        }
        return false;
    }

    private List<Role> getAllRoles(ACOrgUnitId orgUnitId) throws AccessControlException {
        ACOrgUnit orgUnit = this.getOrgUnit(orgUnitId);
        List<ACGroup> groups = this.getGroups(orgUnit);
        ArrayList<Role> roles = new ArrayList<Role>();
        for (ACGroup group : groups) {
            roles.addAll((Collection<Role>)group.getRoles());
        }
        roles.addAll((Collection<Role>)orgUnit.getRoles());
        return roles;
    }

    @Override
    public boolean checkProjectAdminAccess(SessionId sessionId, ProjectId projectId) throws AccessControlException {
        this.checkSession(sessionId);
        ACUser user = this.getUser(sessionId);
        ArrayList<Role> roles = new ArrayList<Role>();
        roles.addAll((Collection<Role>)user.getRoles());
        roles.addAll(this.getRolesFromGroups((ACOrgUnit)user));
        for (Role role : roles) {
            if (!this.isServerAdminRole(role)) continue;
            return true;
        }
        for (Role role : roles) {
            if (projectId == null && this.isProjectAdminRole(role)) {
                return false;
            }
            if (!role.canAdministrate(projectId)) continue;
            return false;
        }
        throw new AccessControlException(Messages.AccessControlImpl_Insufficient_Rights);
    }

    private boolean isServerAdminRole(Role role) {
        return ServerAdmin.class.isInstance(role);
    }

    private boolean isProjectAdminRole(Role role) {
        return ProjectAdminRole.class.isInstance(role);
    }

    @Override
    public void checkServerAdminAccess(SessionId sessionId) throws AccessControlException {
        this.checkSession(sessionId);
        ACUser user = this.getUser(sessionId);
        ArrayList<Role> roles = new ArrayList<Role>();
        roles.addAll((Collection<Role>)user.getRoles());
        roles.addAll(this.getRolesFromGroups((ACOrgUnit)user));
        for (Role role : roles) {
            if (!(role instanceof ServerAdmin)) continue;
            return;
        }
        throw new AccessControlException(Messages.AccessControlImpl_Insufficient_Rights);
    }

    @Override
    public ACUser resolveUser(SessionId sessionId) throws AccessControlException {
        this.checkSession(sessionId);
        ACUser tmpUser = this.sessionUserMap.get(sessionId).getRawUser();
        return this.copyAndResolveUser(tmpUser);
    }

    @Override
    public ACUser resolveUser(ACOrgUnitId id) throws AccessControlException {
        ACUser tmpUser = this.getUser(id);
        return this.copyAndResolveUser(tmpUser);
    }

    private ACUser copyAndResolveUser(ACUser tmpUser) {
        ACUser user = (ACUser)ModelUtil.clone((EObject)tmpUser);
        for (Role role : this.getRolesFromGroups((ACOrgUnit)tmpUser)) {
            user.getRoles().add((Object)((Role)ModelUtil.clone((EObject)role)));
        }
        for (ACGroup group : this.getGroups((ACOrgUnit)tmpUser)) {
            if (user.getEffectiveGroups().contains((Object)group)) continue;
            ACGroup copy = (ACGroup)ModelUtil.clone((EObject)group);
            user.getEffectiveGroups().add((Object)copy);
            copy.getMembers().clear();
        }
        return user;
    }

    private ACUser getUser(SessionId sessionId) throws AccessControlException {
        try {
            return this.sessionUserMap.get(sessionId).getUser();
        }
        catch (AccessControlException e) {
            this.sessionUserMap.remove(sessionId);
            throw e;
        }
    }

    @Override
    public void checkAccess(MethodInvocation op) throws AccessControlException {
        this.initAccessMap();
        AccessLevel accessType = this.accessMap.get((Object)op.getType());
        if (accessType == null) {
            throw new AccessControlException(Messages.AccessControlImpl_No_Access);
        }
        switch (accessType) {
            case PROJECT_READ: {
                ProjectId projectId = this.getProjectIdFromParameters(op);
                this.checkReadAccess(op.getSessionId(), projectId, null);
                break;
            }
            case PROJECT_WRITE: {
                ProjectId projectId = this.getProjectIdFromParameters(op);
                this.checkWriteAccess(op.getSessionId(), projectId, null);
                break;
            }
            case PROJECT_ADMIN: {
                ProjectId projectId = this.getProjectIdFromParameters(op);
                this.checkProjectAdminAccess(op.getSessionId(), projectId);
                break;
            }
            case SERVER_ADMIN: {
                this.checkServerAdminAccess(op.getSessionId());
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new AccessControlException(Messages.AccessControlImpl_Unknown_Access_Type);
            }
        }
    }

    private ProjectId getProjectIdFromParameters(MethodInvocation op) {
        Object[] objectArray = op.getParameters();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof ProjectId) {
                return (ProjectId)obj;
            }
            ++n2;
        }
        return null;
    }

    public AbstractAuthenticationControl getAuthenticationControl() {
        return this.authenticationControl;
    }

    @Override
    public void setAuthenticationControl(AbstractAuthenticationControl authenticationControl) {
        this.authenticationControl = authenticationControl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AccessLevel {
        PROJECT_READ,
        PROJECT_WRITE,
        PROJECT_ADMIN,
        SERVER_ADMIN,
        NONE;

    }
}

