/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.transaction;

import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.tdb1.base.file.FileException;
import org.apache.jena.tdb1.store.DatasetGraphTDB;
import org.apache.jena.tdb1.sys.FileRef;
import org.apache.jena.tdb1.sys.SystemTDB;
import org.apache.jena.tdb1.transaction.BlockMgrJournal;
import org.apache.jena.tdb1.transaction.DatasetGraphTxn;
import org.apache.jena.tdb1.transaction.Journal;
import org.apache.jena.tdb1.transaction.JournalEntryType;
import org.apache.jena.tdb1.transaction.ObjectFileTrans;
import org.apache.jena.tdb1.transaction.TDBTransactionException;
import org.apache.jena.tdb1.transaction.TransactionLifecycle;
import org.apache.jena.tdb1.transaction.TransactionManager;
import org.apache.jena.tdb1.transaction.TxnState;

public class Transaction {
    private final long id;
    private final String label;
    private final TransactionManager txnMgr;
    private final Journal journal;
    private final TxnType txnType;
    private final TxnType originalTxnType;
    private final ReadWrite mode;
    private final List<ObjectFileTrans> objectFileTrans = new ArrayList<ObjectFileTrans>();
    private final List<BlockMgrJournal> blkMgrs = new ArrayList<BlockMgrJournal>();
    private final List<TransactionLifecycle> others = new ArrayList<TransactionLifecycle>();
    private final DatasetGraphTDB basedsg;
    private final long version;
    private final List<Iterator<?>> iterators;
    private DatasetGraphTxn activedsg;
    private TxnState state;
    private TxnOutcome outcome;
    private boolean changesPending;
    private int count = 0;
    private int peekCount = 0;

    public Transaction(DatasetGraphTDB dsg, long version2, TxnType txnType, ReadWrite mode, long id, TxnType originalTxnType, String label, TransactionManager txnMgr) {
        this.id = id;
        if (label == null) {
            label = "Txn";
        }
        label = (String)label + "[" + id + "]";
        switch (mode) {
            case READ: {
                label = (String)label + "/R";
                break;
            }
            case WRITE: {
                label = (String)label + "/W";
            }
        }
        this.label = label;
        this.txnMgr = txnMgr;
        this.basedsg = dsg;
        this.version = version2;
        this.txnType = txnType;
        this.originalTxnType = originalTxnType;
        this.mode = mode;
        this.journal = txnMgr == null ? null : txnMgr.getJournal();
        this.activedsg = null;
        this.iterators = null;
        this.state = TxnState.ACTIVE;
        this.outcome = TxnOutcome.UNFINISHED;
        this.changesPending = mode == ReadWrite.WRITE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        Transaction transaction = this;
        synchronized (transaction) {
            switch (this.mode) {
                case READ: {
                    this.outcome = TxnOutcome.R_COMMITED;
                    break;
                }
                case WRITE: {
                    if (this.state != TxnState.ACTIVE) {
                        throw new TDBTransactionException("Transaction has already committed or aborted");
                    }
                    this.journal.startWrite();
                    try {
                        this.writerPrepareCommit();
                        this.journal.commitWrite();
                    }
                    catch (TDBTransactionException ex) {
                        this.journal.abortWrite();
                        throw ex;
                    }
                    catch (Throwable th) {
                        SystemTDB.errlog.error("Unhandled throwable in commit()", th);
                        this.journal.abortWrite();
                        throw th;
                    }
                    finally {
                        this.journal.endWrite();
                    }
                    this.outcome = TxnOutcome.W_COMMITED;
                }
            }
            this.state = TxnState.COMMITED;
        }
        try {
            this.txnMgr.notifyCommit(this);
        }
        catch (RuntimeException ex) {
            if (this.isIOException(ex)) {
                SystemTDB.errlog.warn("IOException after commit point : transaction commited but internal status not recorded properly : " + ex.getMessage());
            } else {
                SystemTDB.errlog.warn("Exception after commit point : transaction commited but internal status not recorded properly", ex);
            }
            throw new TDBTransactionException("Exception after commit point - transaction did commit", ex);
        }
    }

    private void writerPrepareCommit() {
        this.abandonIfInterruped("Thread interrupt before 'commit' - transaction did not commit");
        try {
            this.prepare();
        }
        catch (RuntimeException ex) {
            if (this.isIOException(ex)) {
                SystemTDB.errlog.warn("IOException during 'prepare' : attempting transaction abort: " + ex.getMessage());
            } else {
                SystemTDB.errlog.warn("Exception during 'prepare' : attempting transaction abort", ex);
            }
            this.abandonTxn();
            SystemTDB.errlog.warn("Exception during 'prepare' : transaction aborted", ex);
            throw new TDBTransactionException("Abort during prepare - transaction did not commit", ex);
        }
        this.abandonIfInterruped("Thread interrupt during 'prepare' phase - transaction did not commit");
        try {
            this.journal.write(JournalEntryType.Commit, FileRef.Journal, null);
            this.journal.sync();
        }
        catch (FileException ex) {
            if (ex.getCause() instanceof ClosedByInterruptException) {
                this.journal.reopen();
                this.rollback();
                SystemTDB.errlog.warn("Thread interrupt during I/O in 'commit' : transaction rollback: " + ex.getMessage());
                throw new TDBTransactionException("Thread interrupt during I/O in 'commit' : transaction rollback.", ex);
            }
            if (this.isIOException(ex)) {
                SystemTDB.errlog.warn("IOException during 'commit' : transaction may have committed. Attempting rollback: " + ex.getMessage());
            } else {
                SystemTDB.errlog.warn("Exception during 'commit' : transaction may have committed. Attempting rollback. Details:", ex);
            }
            if (this.abandonTxn()) {
                SystemTDB.errlog.warn("Transaction rollback");
                throw new TDBTransactionException("Exception during 'commit' - transaction rollback.", ex);
            }
            SystemTDB.errlog.error("Transaction rollback failed. System unstable.\nPlease contact users@jena.apache.org, giving details of the environment and this incident.");
            throw new Error("Exception during 'rollback' - System unstable.", ex);
        }
        catch (Throwable ex) {
            SystemTDB.errlog.warn("Unexpected Throwable during 'commit' : transaction may have committed. Attempting rollback: ", ex);
            if (this.abandonTxn()) {
                SystemTDB.errlog.warn("Transaction rollback");
                throw new TDBTransactionException("Exception during 'commit' - transaction rollback.", ex);
            }
            SystemTDB.errlog.error("Transaction rollback failed. System unstable.");
            throw new TDBTransactionException("Exception during 'rollback' - System unstable.", ex);
        }
        try {
            this.committed();
        }
        catch (RuntimeException ex) {
            if (this.isIOException(ex)) {
                SystemTDB.errlog.warn("IOException during 'committed'" + ex.getMessage());
            } else {
                SystemTDB.errlog.warn("Exception during 'committed': " + ex.getMessage(), ex);
            }
            throw new TDBTransactionException("Exception during 'committed' - transaction did commit", ex);
        }
    }

    private void abandonIfInterruped(String msg) {
        if (Thread.interrupted()) {
            this.abandonTxn();
            Thread.currentThread().interrupt();
            throw new TDBTransactionException(msg);
        }
    }

    private boolean abandonTxn() {
        try {
            this.journal.abortWrite();
            this.rollback();
            return true;
        }
        catch (Throwable th) {
            SystemTDB.errlog.warn("Exception during system 'abort'", th);
            return false;
        }
    }

    private boolean isIOException(Throwable ex) {
        while (ex != null) {
            if (ex instanceof IOException) {
                return true;
            }
            ex = ex.getCause();
        }
        return false;
    }

    void forAllComponents(Consumer<TransactionLifecycle> action) {
        this.objectFileTrans.forEach(action);
        this.blkMgrs.forEach(action);
        this.others.forEach(action);
    }

    private void prepare() {
        this.state = TxnState.PREPARING;
        this.forAllComponents(x -> x.commitPrepare(this));
    }

    private void committed() {
        this.forAllComponents(x -> x.committed(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        Transaction transaction = this;
        synchronized (transaction) {
            switch (this.mode) {
                case READ: {
                    this.state = TxnState.ABORTED;
                    this.outcome = TxnOutcome.R_ABORTED;
                    break;
                }
                case WRITE: {
                    if (this.state != TxnState.ACTIVE) {
                        throw new TDBTransactionException("Transaction has already committed or aborted");
                    }
                    this.rollback();
                }
            }
        }
        try {
            this.txnMgr.notifyAbort(this);
        }
        catch (RuntimeException ex) {
            if (this.isIOException(ex)) {
                SystemTDB.errlog.warn("IOException during post-abort (transaction did abort): " + ex.getMessage());
            } else {
                SystemTDB.errlog.warn("Exception during post-abort (transaction did abort)", ex);
            }
            throw new TDBTransactionException("Exception after abort point - transaction did abort", ex);
        }
    }

    private void rollback() {
        try {
            this.forAllComponents(x -> x.abort(this));
        }
        catch (RuntimeException ex) {
            if (this.isIOException(ex)) {
                SystemTDB.errlog.warn("IOException during 'abort' : " + ex.getMessage());
            } else {
                SystemTDB.errlog.warn("Exception during 'abort'", ex);
            }
            throw new TDBTransactionException("Exception during rollback abort - transaction did abort", ex);
        }
        this.state = TxnState.ABORTED;
        this.outcome = TxnOutcome.W_ABORTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        JenaTransactionException throwThis = null;
        Transaction transaction = this;
        synchronized (transaction) {
            switch (this.state) {
                case CLOSED: {
                    return;
                }
                case ACTIVE: {
                    if (this.mode == ReadWrite.READ) {
                        this.commit();
                        this.outcome = TxnOutcome.R_CLOSED;
                        break;
                    }
                    this.abort();
                    String msg = "end() called for WRITE transaction without commit or abort having been called. This causes a forced abort.";
                    throwThis = new JenaTransactionException(msg);
                    break;
                }
            }
            this.state = TxnState.CLOSED;
            if (this.iterators != null) {
                this.iterators.clear();
            }
        }
        this.txnMgr.notifyClose(this);
        if (throwThis != null) {
            throw throwThis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalEnacted() {
        Transaction transaction = this;
        synchronized (transaction) {
            if (!this.changesPending) {
                Log.warn(this, "Transaction was a read transaction or a write transaction that has already been flushed");
            }
            this.changesPending = false;
        }
    }

    public TxnType getTxnType() {
        return this.originalTxnType;
    }

    public TxnType getCurrentTxnType() {
        return this.txnType;
    }

    public ReadWrite getTxnMode() {
        return this.mode;
    }

    public boolean isRead() {
        return this.mode == ReadWrite.READ;
    }

    public boolean isWrite() {
        return this.mode == ReadWrite.WRITE;
    }

    public TxnState getState() {
        return this.state;
    }

    public long getTxnId() {
        return this.id;
    }

    public TransactionManager getTxnMgr() {
        return this.txnMgr;
    }

    public DatasetGraphTxn getActiveDataset() {
        return this.activedsg;
    }

    public long getVersion() {
        return this.version;
    }

    void setActiveDataset(DatasetGraphTxn activedsg) {
        this.activedsg = activedsg;
        if (activedsg.getTransaction() != this) {
            Log.warn(this, "Active DSG does not point to this transaction; " + this);
        }
    }

    Journal getJournal() {
        return this.journal;
    }

    public void addIterator(Iterator<?> iter) {
        ++this.count;
        this.peekCount = Math.max(this.peekCount, this.count);
        if (this.iterators != null) {
            this.iterators.add(iter);
        }
    }

    public void removeIterator(Iterator<?> iter) {
        --this.count;
        if (this.iterators != null) {
            this.iterators.remove(iter);
        }
        if (this.count == 0) {
            this.peekCount = 0;
        }
    }

    void addComponent(ObjectFileTrans oft) {
        this.objectFileTrans.add(oft);
    }

    void addComponent(BlockMgrJournal blkMgr) {
        this.blkMgrs.add(blkMgr);
    }

    void addAdditionaComponent(TransactionLifecycle tlc) {
        this.others.add(tlc);
    }

    public DatasetGraphTDB getBaseDataset() {
        return this.basedsg;
    }

    public String toString() {
        return "Transaction: " + this.id + " : Mode=" + this.mode + " : State=" + this.state + " : " + this.basedsg.getLocation().getDirectoryPath();
    }

    public String getLabel() {
        return this.label;
    }

    static enum TxnOutcome {
        UNFINISHED,
        W_ABORTED,
        W_COMMITED,
        R_CLOSED,
        R_ABORTED,
        R_COMMITED;

    }
}

