/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;

public class ValueInt
extends Value {
    public static final int PRECISION = 10;
    public static final int DISPLAY_SIZE = 11;
    private static final int STATIC_SIZE = 128;
    private static final int DYNAMIC_SIZE = 256;
    private static final ValueInt[] STATIC_CACHE = new ValueInt[128];
    private static final ValueInt[] DYNAMIC_CACHE = new ValueInt[256];
    private final int value;

    private ValueInt(int n) {
        this.value = n;
    }

    public static ValueInt get(int n) {
        if (n >= 0 && n < 128) {
            return STATIC_CACHE[n];
        }
        ValueInt valueInt = DYNAMIC_CACHE[n & 0xFF];
        if (valueInt == null || valueInt.value != n) {
            ValueInt.DYNAMIC_CACHE[n & 0xFF] = valueInt = new ValueInt(n);
        }
        return valueInt;
    }

    public Value add(Value value) throws SQLException {
        ValueInt valueInt = (ValueInt)value;
        if (SysProperties.OVERFLOW_EXCEPTIONS) {
            return this.checkRange((long)this.value + (long)valueInt.value);
        }
        return ValueInt.get(this.value + valueInt.value);
    }

    private ValueInt checkRange(long l) throws SQLException {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw Message.getSQLException(90110, DataType.getDataType((int)4).name);
        }
        return ValueInt.get((int)l);
    }

    public int getSignum() {
        return this.value == 0 ? 0 : (this.value < 0 ? -1 : 1);
    }

    public Value negate() throws SQLException {
        if (SysProperties.OVERFLOW_EXCEPTIONS) {
            return this.checkRange(-((long)this.value));
        }
        return ValueInt.get(-this.value);
    }

    public Value subtract(Value value) throws SQLException {
        ValueInt valueInt = (ValueInt)value;
        if (SysProperties.OVERFLOW_EXCEPTIONS) {
            return this.checkRange((long)this.value - (long)valueInt.value);
        }
        return ValueInt.get(this.value - valueInt.value);
    }

    public Value multiply(Value value) throws SQLException {
        ValueInt valueInt = (ValueInt)value;
        if (SysProperties.OVERFLOW_EXCEPTIONS) {
            return this.checkRange((long)this.value * (long)valueInt.value);
        }
        return ValueInt.get(this.value * valueInt.value);
    }

    public Value divide(Value value) throws SQLException {
        ValueInt valueInt = (ValueInt)value;
        if (valueInt.value == 0) {
            throw Message.getSQLException(22012, this.getSQL());
        }
        return ValueInt.get(this.value / valueInt.value);
    }

    public String getSQL() {
        return this.getString();
    }

    public int getType() {
        return 4;
    }

    public int getInt() {
        return this.value;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueInt valueInt = (ValueInt)value;
        if (this.value == valueInt.value) {
            return 0;
        }
        return this.value > valueInt.value ? 1 : -1;
    }

    public String getString() {
        return String.valueOf(this.value);
    }

    public long getPrecision() {
        return 10L;
    }

    public int hashCode() {
        return this.value;
    }

    public Object getObject() {
        return this.value;
    }

    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setInt(n, this.value);
    }

    public int getDisplaySize() {
        return 11;
    }

    public boolean equals(Object object) {
        return object instanceof ValueInt && this.value == ((ValueInt)object).value;
    }

    static {
        for (int i = 0; i < 128; ++i) {
            ValueInt.STATIC_CACHE[i] = new ValueInt(i);
        }
    }
}

