/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.model.element;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.model.SimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.TypeHelper;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkBlock;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.util.SimulinkUtil;
import org.eclipse.epsilon.emc.simulink.util.StateflowUtil;
import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public class StateflowBlock
extends SimulinkModelElement {
    private static final String SIMPLE_TYPE = "?.classhandle.get('Name');";
    private static final String DELETE_SF = "?.delete;";
    private Double id;
    private HashMap<String, Object> properties = new HashMap();

    public StateflowBlock(SimulinkModel model, MatlabEngine engine, String type, StateflowBlock parent) throws MatlabException, EolRuntimeException {
        super(model, engine);
        this.setType(type);
        this.buildFromStateflow(parent);
    }

    public StateflowBlock(SimulinkModel model, MatlabEngine engine, String type) throws MatlabException {
        super(model, engine);
        this.setType(type);
    }

    public StateflowBlock(SimulinkModel model, MatlabEngine engine, Double stateflowId) throws MatlabException {
        super(model, engine);
        this.id = stateflowId;
        this.setType();
    }

    public StateflowBlock(SimulinkModel model, MatlabEngine engine, Integer stateflowId) throws MatlabException {
        this(model, engine, stateflowId.doubleValue());
    }

    public StateflowBlock(SimulinkModel model, MatlabEngine engine, String type, Double stateflowId) throws MatlabException {
        super(model, engine);
        this.id = stateflowId;
        this.setType();
    }

    public StateflowBlock(SimulinkModel model, MatlabEngine engine, String type, Integer stateflowId) throws MatlabException {
        this(model, engine, type, stateflowId.doubleValue());
    }

    private void setType(String type) throws MatlabException {
        if (type != null && type.startsWith("Stateflow")) {
            this.type = type;
        } else {
            this.setType();
        }
    }

    private void setType() throws MatlabException {
        if (this.id != null) {
            String handle = StateflowUtil.getBlockHandleFromId(this.model, this.engine, this.id);
            this.type = "Stateflow." + (String)this.engine.evalWithResult(SIMPLE_TYPE, handle);
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    private boolean isUnset() {
        return this.id == null;
    }

    @Override
    public Object getProperty(String property) throws EolIllegalPropertyException {
        if (this.isUnset()) {
            return this.properties.get(property.toLowerCase());
        }
        if (property.equalsIgnoreCase("parent") || property.equalsIgnoreCase("up")) {
            try {
                return this.getParent();
            }
            catch (EolRuntimeException eolRuntimeException) {
                throw new EolIllegalPropertyException((Object)this, property, null, null);
            }
        }
        try {
            String h = StateflowUtil.getBlockHandle(this);
            return this.engine.evalWithResult("?.?;", h, property);
        }
        catch (MatlabException matlabException) {
            throw new EolIllegalPropertyException((Object)this, property, null, null);
        }
    }

    @Override
    public void setProperty(String property, Object value) throws EolIllegalPropertyException {
        block10: {
            try {
                if (property.equalsIgnoreCase("parent") || property.equalsIgnoreCase("up")) {
                    if (value instanceof StateflowBlock) {
                        try {
                            this.setParent((StateflowBlock)value);
                            break block10;
                        }
                        catch (EolRuntimeException eolRuntimeException) {
                            throw new EolIllegalPropertyException((Object)this, property, null, null);
                        }
                    }
                    throw new EolIllegalPropertyException((Object)this, property, null, null);
                }
                if (this.isUnset()) {
                    this.properties.put(property.toLowerCase(), value);
                } else {
                    String valueStr;
                    String escaped = "?";
                    String randomHandle = "";
                    if (value instanceof StateflowBlock) {
                        randomHandle = StateflowUtil.getBlockHandle((StateflowBlock)value);
                        value = randomHandle;
                    }
                    if (!(!(value instanceof String) || value.equals(randomHandle) || (valueStr = (String)value).startsWith("'") && valueStr.endsWith("'") || valueStr.startsWith("[") && valueStr.endsWith("]"))) {
                        escaped = "'" + escaped + "'";
                    }
                    String cmd = "?.? = " + escaped + ";";
                    String h = StateflowUtil.getBlockHandle(this);
                    this.engine.eval(cmd, h, property, value);
                }
            }
            catch (MatlabException matlabException) {
                throw new EolIllegalPropertyException((Object)this, property, null, null);
            }
        }
    }

    public Double getId() {
        return this.id;
    }

    @Override
    public String getPath() {
        if (this.id != null) {
            try {
                String handle = StateflowUtil.getBlockHandleFromId(this.model, this.engine, this.id);
                return (String)this.engine.evalWithResult("?.path;", handle);
            }
            catch (MatlabException matlabException) {}
        }
        return null;
    }

    public ISimulinkModelElement getParent() throws EolRuntimeException {
        try {
            String h = StateflowUtil.getBlockHandle(this);
            try {
                Double parentId = (Double)this.engine.evalWithResult("?.up.id;", h);
                return new StateflowBlock(this.model, this.engine, parentId);
            }
            catch (MatlabException matlabException) {
                String path = (String)this.engine.evalWithResult("?.path;", h);
                return new SimulinkBlock(path, this.model, this.engine);
            }
        }
        catch (MatlabException e1) {
            throw new EolRuntimeException(e1.getMessage());
        }
    }

    public void setParent(StateflowBlock parent) throws EolRuntimeException, MatlabException {
        if (!this.isUnset()) {
            this.changeParent(parent);
        } else {
            this.buildFromStateflow(parent);
            this.applyProperties();
        }
    }

    private void applyProperties() throws EolIllegalPropertyException {
        for (String key : this.properties.keySet()) {
            this.setProperty(key, this.properties.get(key));
        }
        this.properties.clear();
    }

    private void changeParent(StateflowBlock parent) throws EolRuntimeException {
        throw new EolRuntimeException("Changing parent is not yet implemented");
    }

    private void buildFromStateflow(StateflowBlock parent) throws EolRuntimeException {
        if (!parent.isUnset()) {
            try {
                String parentHandle = StateflowUtil.getBlockHandle(parent);
                this.engine.eval("block = ?(?);", this.getType(), parentHandle);
                this.id = (Double)this.engine.evalWithResult("block.id;");
            }
            catch (MatlabException e) {
                throw new EolRuntimeException(e.getMessage());
            }
        } else {
            throw new EolRuntimeException("Parent was not a valid entity");
        }
    }

    public Collection<StateflowBlock> getChildren() {
        try {
            String handle = StateflowUtil.getBlockHandle(this);
            Object children = this.engine.evalWithSetupAndResult("list = ?.find('-depth',1); list = setdiff(list, ?);", "get(list,'Id');", handle, handle);
            return StateflowUtil.getStateflowBlocks(this.model, this.engine, children);
        }
        catch (MatlabException matlabException) {
            return Collections.emptyList();
        }
    }

    public StateflowBlock inspect() {
        try {
            String h = StateflowUtil.getBlockHandle(this);
            this.engine.eval("get(?);", h);
        }
        catch (MatlabException matlabException) {}
        return this;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof StateflowBlock && ((StateflowBlock)other).getId().equals(this.getId());
    }

    public String toString() {
        return String.valueOf(this.getType()) + "[ id = " + this.getId() + ", path = " + this.getPath() + " ]";
    }

    @Override
    public Collection<String> getAllTypeNamesOf() {
        return Arrays.asList(TypeHelper.Kind.STATEFLOW.getKind(), this.getType());
    }

    @Override
    public boolean deleteElementInModel() throws EolRuntimeException {
        try {
            this.engine.eval(DELETE_SF, StateflowUtil.getBlockHandle(this));
            return true;
        }
        catch (MatlabException matlabException) {
            return false;
        }
    }

    public StateflowBlock add(StateflowBlock block) throws EolRuntimeException {
        try {
            block.setParent(this);
        }
        catch (MatlabException e) {
            e.printStackTrace();
        }
        return this;
    }

    public SimulinkBlock asSimulink() throws EolRuntimeException {
        Double h = SimulinkUtil.getHandle(this.getPath(), this.engine);
        if (h >= 0.0) {
            return new SimulinkBlock(this.model, this.engine, h);
        }
        throw new EolRuntimeException("This block does not have a simulink Nature");
    }
}

