/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.types.Struct;

public class MatlabEngineUtil {
    public static List<Double> matlabArrayToList(double[] value) {
        ArrayList<Double> result = new ArrayList<Double>();
        int i = 0;
        while (i < value.length) {
            result.add(value[i]);
            ++i;
        }
        return result;
    }

    public static List<Long> matlabArrayToList(long[] value) {
        ArrayList<Long> result = new ArrayList<Long>();
        int i = 0;
        while (i < value.length) {
            result.add(value[i]);
            ++i;
        }
        return result;
    }

    public static List<Integer> matlabArrayToList(int[] value) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = 0;
        while (i < value.length) {
            result.add(value[i]);
            ++i;
        }
        return result;
    }

    public static List<Float> matlabArrayToList(float[] value) {
        ArrayList<Float> result = new ArrayList<Float>();
        int i = 0;
        while (i < value.length) {
            result.add(Float.valueOf(value[i]));
            ++i;
        }
        return result;
    }

    public static List<Boolean> matlabArrayToList(boolean[] value) {
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        int i = 0;
        while (i < value.length) {
            result.add(value[i]);
            ++i;
        }
        return result;
    }

    public static List<Byte> matlabArrayToList(byte[] value) {
        ArrayList<Byte> result = new ArrayList<Byte>();
        int i = 0;
        while (i < value.length) {
            result.add(value[i]);
            ++i;
        }
        return result;
    }

    public static List<Short> matlabArrayToList(short[] value) {
        ArrayList<Short> result = new ArrayList<Short>();
        int i = 0;
        while (i < value.length) {
            result.add(value[i]);
            ++i;
        }
        return result;
    }

    public static <T> List<T> matlabArrayToList(Object[] value) {
        Object[] newValue = value;
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < newValue.length) {
            result.add(newValue[i]);
            ++i;
        }
        return result;
    }

    public static Object parseMatlabEngineVariable(MatlabEngine engine, String variableName) throws MatlabException {
        Object value = engine.getVariable(variableName);
        return MatlabEngineUtil.parseMatlabEngineVariable(value);
    }

    public static Object parseMatlabEngineVariable(Object value) {
        if (value instanceof byte[]) {
            return MatlabEngineUtil.matlabArrayToList((byte[])value);
        }
        if (value instanceof short[]) {
            return MatlabEngineUtil.matlabArrayToList((short[])value);
        }
        if (value instanceof int[]) {
            return MatlabEngineUtil.matlabArrayToList((int[])value);
        }
        if (value instanceof long[]) {
            return MatlabEngineUtil.matlabArrayToList((long[])value);
        }
        if (value instanceof float[]) {
            return MatlabEngineUtil.matlabArrayToList((float[])value);
        }
        if (value instanceof double[]) {
            return MatlabEngineUtil.matlabArrayToList((double[])value);
        }
        if (value instanceof boolean[]) {
            return MatlabEngineUtil.matlabArrayToList((boolean[])value);
        }
        if (value instanceof String[]) {
            return MatlabEngineUtil.matlabArrayToList((String[])value);
        }
        if (value instanceof Object[]) {
            return MatlabEngineUtil.matlabArrayToList((Object[])value);
        }
        if (value instanceof Character) {
            return String.valueOf(value);
        }
        if (value instanceof String) {
            return String.valueOf(value);
        }
        if (Struct.is(value)) {
            return new Struct(value);
        }
        return value;
    }
}

