/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.types;

import java.lang.reflect.Method;
import java.util.Set;

public class Struct {
    protected static final String STRUCT_MATLAB_CLASS = "com.mathworks.matlab.types.Struct";
    protected static final String CONTAINS_KEY_METHOD = "containsKey";
    protected static final String CONTAINS_VALUE_METHOD = "containsValue";
    protected static final String EQUALS_METHOD = "equals";
    protected static final String GET_METHOD = "get";
    protected static final String ENTRY_SET_METHOD = "entrySet";
    protected static final String HASH_CODE_METHOD = "hashCode";
    protected static final String IS_EMPTY_METHOD = "isEmpty";
    protected static final String KEY_SET_METHOD = "keySet";
    protected static final String SIZE_METHOD = "size";
    protected static final String VALUES_METHOD = "values";
    private static Class<?> struct_class;
    protected Object struct;
    protected Method containsKeyMethod;
    protected Method containsValueMethod;
    protected Method equalsMethod;
    protected Method getMethod;
    protected Method entrySetMethod;
    protected Method hashCodeMethod;
    protected Method isEmptyMethod;
    protected Method keySetMethod;
    protected Method sizeMethod;
    protected Method valuesMethod;

    public static boolean is(Object obj) {
        return Struct.getMatlabClass() == null ? false : Struct.getMatlabClass().isInstance(obj);
    }

    protected static Class<?> getMatlabClass() {
        if (struct_class == null) {
            try {
                struct_class = ClassLoader.getSystemClassLoader().loadClass(STRUCT_MATLAB_CLASS);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return struct_class;
    }

    public Struct(Object struct) {
        if (Struct.is(struct)) {
            this.struct = struct;
            this.init();
        }
    }

    private void init() {
        Class<?> clazz = Struct.getMatlabClass();
        try {
            this.containsKeyMethod = this.containsKeyMethod == null ? clazz.getDeclaredMethod(CONTAINS_KEY_METHOD, Object.class) : null;
            this.containsValueMethod = this.containsValueMethod == null ? clazz.getDeclaredMethod(CONTAINS_VALUE_METHOD, Object.class) : null;
            this.equalsMethod = this.equalsMethod == null ? clazz.getDeclaredMethod(EQUALS_METHOD, Object.class) : null;
            this.getMethod = this.getMethod == null ? clazz.getDeclaredMethod(GET_METHOD, Object.class) : null;
            this.entrySetMethod = this.entrySetMethod == null ? clazz.getDeclaredMethod(ENTRY_SET_METHOD, new Class[0]) : null;
            this.hashCodeMethod = this.hashCodeMethod == null ? clazz.getDeclaredMethod(HASH_CODE_METHOD, new Class[0]) : null;
            this.isEmptyMethod = this.isEmptyMethod == null ? clazz.getDeclaredMethod(IS_EMPTY_METHOD, new Class[0]) : null;
            this.keySetMethod = this.keySetMethod == null ? clazz.getDeclaredMethod(KEY_SET_METHOD, new Class[0]) : null;
            this.sizeMethod = this.sizeMethod == null ? clazz.getDeclaredMethod(SIZE_METHOD, new Class[0]) : null;
            this.valuesMethod = this.valuesMethod == null ? clazz.getDeclaredMethod(VALUES_METHOD, new Class[0]) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Boolean containsKey(Object key) {
        try {
            return (Boolean)this.containsKeyMethod.invoke(this.struct, key);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Boolean containsValue(Object value) {
        try {
            return (Boolean)this.containsValueMethod.invoke(this.struct, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public boolean equals(Object obj) {
        try {
            return (Boolean)this.equalsMethod.invoke(this.struct, obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Object get(Object key) {
        try {
            return this.getMethod.invoke(this.struct, key);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Set<?> entrySet() {
        try {
            return (Set)this.entrySetMethod.invoke(this.struct, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public int hashCode() {
        try {
            return (Integer)this.hashCodeMethod.invoke(this.struct, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Boolean isEmpty() {
        try {
            return (Boolean)this.isEmptyMethod.invoke(this.struct, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Set<?> keySet() {
        try {
            return (Set)this.keySetMethod.invoke(this.struct, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Integer size() {
        try {
            return (Integer)this.sizeMethod.invoke(this.struct, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Set<?> values() {
        try {
            return (Set)this.valuesMethod.invoke(this.struct, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public String toString() {
        return "Struct: [" + this.entrySet().toString() + "]";
    }
}

