/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.HashCursor;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableData;
import org.h2.util.IntIntHashMap;
import org.h2.util.ValueHashMap;
import org.h2.value.Value;
import org.h2.value.ValueArray;

public class HashIndex
extends BaseIndex {
    private ValueHashMap<Integer> rows;
    private IntIntHashMap intMap;
    private TableData tableData;
    private long rowCount;

    public HashIndex(TableData tableData, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.initBaseIndex(tableData, n, string, indexColumnArray, indexType);
        this.tableData = tableData;
        this.reset();
    }

    private void reset() {
        if (this.columns.length == 1 && this.columns[0].getType() == 4) {
            this.intMap = new IntIntHashMap();
        } else {
            this.rows = ValueHashMap.newInstance(this.table.getDatabase());
        }
    }

    public void close(Session session) {
    }

    public void truncate(Session session) {
        this.reset();
    }

    public void remove(Session session) {
    }

    public void add(Session session, Row row) throws SQLException {
        if (this.intMap != null) {
            int n = row.getValue(this.columns[0].getColumnId()).getInt();
            this.intMap.put(n, row.getPos());
        } else {
            Value value = this.getKey(row);
            Integer n = this.rows.get(value);
            if (n != null) {
                throw this.getDuplicateKeyException();
            }
            this.rows.put(this.getKey(row), row.getPos());
        }
        ++this.rowCount;
    }

    public void remove(Session session, Row row) throws SQLException {
        if (this.intMap != null) {
            int n = row.getValue(this.columns[0].getColumnId()).getInt();
            this.intMap.remove(n);
        } else {
            this.rows.remove(this.getKey(row));
        }
        --this.rowCount;
    }

    private Value getKey(SearchRow searchRow) {
        if (this.columns.length == 1) {
            Column column = this.columns[0];
            int n = column.getColumnId();
            Value value = searchRow.getValue(n);
            return value;
        }
        Value[] valueArray = new Value[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            Column column = this.columns[i];
            int n = column.getColumnId();
            valueArray[i] = searchRow.getValue(n);
        }
        return ValueArray.get(valueArray);
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        Integer n;
        int n2;
        int n3;
        if (searchRow == null || searchRow2 == null) {
            throw Message.throwInternalError();
        }
        Row row = this.intMap != null ? ((n3 = this.intMap.get(n2 = searchRow.getValue(this.columns[0].getColumnId()).getInt())) != -1 ? this.tableData.getRow(session, n3) : null) : ((n = this.rows.get(this.getKey(searchRow))) == null ? null : this.tableData.getRow(session, n));
        return new HashCursor(row);
    }

    public double getCost(Session session, int[] nArray) {
        for (Column column : this.columns) {
            int n = column.getColumnId();
            int n2 = nArray[n];
            if ((n2 & 1) == 1) continue;
            return 9.223372036854776E18;
        }
        return 2.0;
    }

    public void checkRename() {
    }

    public boolean needRebuild() {
        return true;
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public Cursor findFirstOrLast(Session session, boolean bl) throws SQLException {
        throw Message.getUnsupportedException("HASH");
    }

    public long getRowCount(Session session) {
        return this.rowCount;
    }

    public long getRowCountApproximation() {
        return this.rowCount;
    }
}

