/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class SAXHelper {
    private static POILogger logger = POILogFactory.getLogger(SAXHelper.class);
    static final EntityResolver IGNORING_ENTITY_RESOLVER = new EntityResolver(){

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new StringReader(""));
        }
    };
    private static final SAXParserFactory saxFactory = SAXParserFactory.newInstance();
    static final String FEATURE_SECURE_PROCESSING = "http://javax.xml.XMLConstants/feature/secure-processing";

    private SAXHelper() {
    }

    public static synchronized XMLReader newXMLReader() throws SAXException, ParserConfigurationException {
        XMLReader xmlReader = saxFactory.newSAXParser().getXMLReader();
        xmlReader.setEntityResolver(IGNORING_ENTITY_RESOLVER);
        SAXHelper.trySetSAXFeature(xmlReader, FEATURE_SECURE_PROCESSING, true);
        SAXHelper.trySetXercesSecurityManager(xmlReader);
        return xmlReader;
    }

    private static void trySetSAXFeature(XMLReader xmlReader, String feature, boolean enabled) {
        try {
            xmlReader.setFeature(feature, enabled);
        }
        catch (Exception e) {
            logger.log(3, (Object)"SAX Feature unsupported", (Object)feature, (Throwable)e);
        }
    }

    private static void trySetXercesSecurityManager(XMLReader xmlReader) {
        for (String securityManagerClassName : new String[]{"com.sun.org.apache.xerces.internal.util.SecurityManager", "org.apache.xerces.util.SecurityManager"}) {
            try {
                Object mgr = Class.forName(securityManagerClassName).newInstance();
                Method setLimit = mgr.getClass().getMethod("setEntityExpansionLimit", Integer.TYPE);
                setLimit.invoke(mgr, 4096);
                xmlReader.setProperty("http://apache.org/xml/properties/security-manager", mgr);
                return;
            }
            catch (Exception e) {
                logger.log(3, (Object)"SAX Security Manager could not be setup", (Throwable)e);
            }
        }
    }

    public static SAXReader getSAXReader() throws DocumentException {
        try {
            SAXReader reader = new SAXReader(SAXHelper.newXMLReader(), false);
            reader.setEntityResolver(IGNORING_ENTITY_RESOLVER);
            return reader;
        }
        catch (SAXException saxe) {
            throw new DocumentException((Throwable)saxe);
        }
        catch (ParserConfigurationException pce) {
            throw new DocumentException((Throwable)pce);
        }
    }

    public static Document readSAXDocument(InputStream inp) throws DocumentException {
        return SAXHelper.getSAXReader().read(inp);
    }

    static {
        saxFactory.setValidating(false);
        saxFactory.setNamespaceAware(true);
    }
}

