/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.engine;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEnginePool;
import org.eclipse.epsilon.emc.simulink.exception.EpsilonSimulinkInternalException;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.exception.MatlabRuntimeException;
import org.eclipse.epsilon.emc.simulink.model.IGenericSimulinkModel;
import org.eclipse.epsilon.emc.simulink.util.MatlabEngineUtil;

public class MatlabEngine {
    private static final String MATLAB_ENGINE_CLASS = "com.mathworks.engine.MatlabEngine";
    private static final String CONNECT_MATLAB_METHOD = "connectMatlab";
    private static final String START_MATLAB_METHOD = "startMatlab";
    private static final String FIND_MATLAB_METHOD = "findMatlab";
    private static final String GET_VARIABLE_METHOD = "getVariable";
    private static final String PUT_VARIABLE_METHOD = "putVariable";
    private static final String EVAL_METHOD = "eval";
    private static final String EVAL_ASYNC_METHOD = "evalAsync";
    private static final String FEVAL_METHOD = "feval";
    private static final String DISCONNECT_METHOD = "disconnect";
    private static final String QUIT_METHOD = "quit";
    private static final String CLOSE_METHOD = "close";
    private static final String RESULT = "result";
    private static final String ASIGN = " = ";
    private static final String PARAM_REGEX = "[?]";
    private static final String FEVAL_ASYNC_METHOD = "fevalAsync";
    private static final String ERROR_INVALID_PARAMETER_NUMBER = "%d parameters were expected but %d were provided";
    protected Object engine;
    private static Class<?> engine_class;
    protected Method getVariableMethod;
    protected Method getVariableAsyncMethod;
    protected Method putVariableMethod;
    protected Method putVariableAsyncMethod;
    protected Method evalMethod;
    protected Method evalAsyncMethod;
    protected Method fevalMethod;
    protected Method fevalWithVariableOutputsMethod;
    protected Method fevalAsyncMethod;
    protected Method closeMethod;
    protected Method quitMethod;
    protected Method disconnectMethod;
    protected String project;
    protected Set<IGenericSimulinkModel> models = new HashSet<IGenericSimulinkModel>();
    protected Boolean tryCatchEnabled = true;

    public boolean isDisconnected() throws Exception {
        Field declaredField = engine_class.getDeclaredField("fDisconnected");
        declaredField.setAccessible(true);
        AtomicBoolean disconnected = (AtomicBoolean)declaredField.get(this.engine);
        return disconnected.get();
    }

    public static void setEngineClass(Class<?> matlabEngineClass) {
        engine_class = matlabEngineClass;
    }

    public void setProject(String project) throws MatlabException {
        this.project = project;
        if (project.equals("current")) {
            this.eval("currentProject;");
        } else {
            File proj = new File(project);
            this.eval("cd '?';", proj.getParent());
            String location = proj.getName().substring(0, proj.getName().indexOf(46));
            this.eval("simulinkproject('?');", location);
        }
    }

    public void addModel(IGenericSimulinkModel model) {
        this.models.add(model);
    }

    public String getProject() {
        return this.project;
    }

    public void release(IGenericSimulinkModel model) throws MatlabRuntimeException {
        if (this.project != null && !this.models.isEmpty()) {
            this.models.remove(model);
        }
        if (this.models.isEmpty()) {
            this.project = null;
            MatlabEnginePool.getInstance().release(this);
        }
    }

    public MatlabEngine() throws Exception {
        if (engine_class == null) {
            throw new IllegalStateException("Engine Class not yet set");
        }
        try {
            this.engine = engine_class.getMethod(CONNECT_MATLAB_METHOD, new Class[0]).invoke(null, new Object[0]);
        }
        catch (InvocationTargetException e) {
            try {
                this.engine = engine_class.getMethod(START_MATLAB_METHOD, new Class[0]).invoke(null, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                throw new MatlabException(e);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException ex) {
                throw new EpsilonSimulinkInternalException(e);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            throw new EpsilonSimulinkInternalException(e);
        }
    }

    public void enableTryCatch(boolean enableTryCatch) {
        this.tryCatchEnabled = enableTryCatch;
    }

    public Boolean isTryCatchEnabled() {
        return this.tryCatchEnabled;
    }

    public Object evalWithSetupAndResult(String setup, String cmd, Object ... parameters) throws MatlabException {
        this.eval(String.valueOf(setup) + (setup.endsWith(";") ? "" : ";") + RESULT + ASIGN + cmd, parameters);
        return this.getVariable(RESULT);
    }

    public Object evalWithResult(String cmd) throws MatlabException {
        this.eval("result = " + cmd);
        return this.getVariable(RESULT);
    }

    public Object evalWithResult(String cmd, Object ... parameters) throws MatlabException {
        this.eval("result = " + cmd, parameters);
        return this.getVariable(RESULT);
    }

    public void eval(String cmd, Object ... parameters) throws MatlabException {
        String[] parts = (cmd = " " + cmd + " ").split(PARAM_REGEX);
        if (parts.length != parameters.length + 1) {
            String error = String.format(ERROR_INVALID_PARAMETER_NUMBER, parts.length - 1, parameters.length);
            throw new RuntimeException(error);
        }
        cmd = parts[0];
        int i = 0;
        while (i < parameters.length) {
            cmd = String.valueOf(cmd) + String.valueOf(parameters[i]).replace("'", "''").replace("\n", "\\n") + parts[i + 1];
            ++i;
        }
        cmd = cmd.substring(1, cmd.length() - 1);
        this.eval(cmd);
    }

    public static boolean is(Object obj) {
        return MatlabEngine.getMatlabClass() == null ? false : MatlabEngine.getMatlabClass().isInstance(obj);
    }

    protected static Class<?> getMatlabClass() {
        if (engine_class == null) {
            try {
                engine_class = ClassLoader.getSystemClassLoader().loadClass(MATLAB_ENGINE_CLASS);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return engine_class;
    }

    public MatlabEngine(Object engine) {
        if (MatlabEngine.is(engine)) {
            this.engine = engine;
        }
    }

    protected Object processInputObject(Object o) {
        return MatlabEngineUtil.formatForMatlabEngine(o);
    }

    protected Object[] processInputObject(Object[] objects) {
        return Arrays.stream(objects).map(this::processInputObject).toArray();
    }

    public static MatlabEngine startMatlab() throws MatlabException {
        try {
            Method startMatlabMethod = engine_class.getMethod(START_MATLAB_METHOD, new Class[0]);
            Object returnedEngine = startMatlabMethod.invoke(null, new Object[0]);
            return new MatlabEngine(returnedEngine);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            throw new EpsilonSimulinkInternalException(e);
        }
        catch (InvocationTargetException e) {
            throw new MatlabException(e);
        }
    }

    public static MatlabEngine startMatlab(String[] options) throws MatlabException {
        try {
            Method startMatlabMethod = engine_class.getMethod(START_MATLAB_METHOD, String[].class);
            Object returnedEngine = startMatlabMethod.invoke(null, new Object[]{options});
            return new MatlabEngine(returnedEngine);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            throw new EpsilonSimulinkInternalException(e);
        }
        catch (InvocationTargetException e) {
            throw new MatlabException(e);
        }
    }

    public static String[] findMatlab() throws MatlabException {
        try {
            Method findMatlabMethod = engine_class.getMethod(FIND_MATLAB_METHOD, new Class[0]);
            return (String[])findMatlabMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            throw new EpsilonSimulinkInternalException(e);
        }
        catch (InvocationTargetException e) {
            throw new MatlabException(e);
        }
    }

    public static MatlabEngine connectMatlab() throws MatlabException {
        try {
            Method connectMatlabMethod = engine_class.getMethod(CONNECT_MATLAB_METHOD, new Class[0]);
            Object returnedEngine = connectMatlabMethod.invoke(null, new Object[0]);
            return new MatlabEngine(returnedEngine);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            throw new EpsilonSimulinkInternalException(e);
        }
        catch (InvocationTargetException e) {
            throw new MatlabException(e);
        }
    }

    public static MatlabEngine connectMatlab(String name) throws MatlabException {
        try {
            Method connectMatlabMethod = engine_class.getMethod(CONNECT_MATLAB_METHOD, String.class);
            Object returnedEngine = connectMatlabMethod.invoke(null, name);
            return new MatlabEngine(returnedEngine);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            throw new EpsilonSimulinkInternalException(e);
        }
        catch (InvocationTargetException e) {
            throw new MatlabException(e);
        }
    }

    public void eval(String cmd) throws MatlabException {
        if (this.evalMethod == null) {
            try {
                this.evalMethod = this.engine.getClass().getMethod(EVAL_METHOD, String.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new EpsilonSimulinkInternalException(e);
            }
        }
        try {
            if (this.isTryCatchEnabled().booleanValue()) {
                cmd = "try\n" + cmd + "\n catch ME \n e = MException(ME.identifier,ME.message); throw(e); \n end";
            }
            this.evalMethod.invoke(this.engine, cmd);
        }
        catch (InvocationTargetException e) {
            throw new MatlabException(e);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new EpsilonSimulinkInternalException(e);
        }
    }

    public Future<Void> evalAsync(String cmd) throws MatlabException {
        if (this.evalAsyncMethod == null) {
            try {
                this.evalAsyncMethod = this.engine.getClass().getMethod(EVAL_ASYNC_METHOD, String.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new EpsilonSimulinkInternalException(e);
            }
        }
        try {
            return (Future)this.evalAsyncMethod.invoke(this.engine, cmd);
        }
        catch (InvocationTargetException e) {
            throw new MatlabException(e);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new EpsilonSimulinkInternalException(e);
        }
    }

    public Object getVariable(String variable) throws MatlabException {
        if (this.getVariableMethod == null) {
            try {
                this.getVariableMethod = this.engine.getClass().getMethod(GET_VARIABLE_METHOD, String.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new EpsilonSimulinkInternalException(e);
            }
        }
        try {
            return MatlabEngineUtil.parseMatlabEngineVariable(this.getVariableMethod.invoke(this.engine, variable));
        }
        catch (InvocationTargetException e) {
            String className = (String)this.evalWithResult("class(?);", variable);
            if (className.equals("Simulink.SimulationOutput")) {
                HashMap<String, Object> output = new HashMap<String, Object>();
                Object evalWithResult = this.evalWithResult("?.ErrorMessage;", variable);
                output.put("ErrorMessage", evalWithResult);
                evalWithResult = this.evalWithResult("?.simout;", variable);
                output.put("simout", evalWithResult);
                evalWithResult = this.evalWithResult("?.tout;", variable);
                output.put("tout", evalWithResult);
                this.eval("meta = ?.SimulationMetadata;", variable);
                HashMap<String, Object> meta = new HashMap<String, Object>();
                this.eval("meta.ModelInfo;");
                evalWithResult = this.getVariable("ans");
                meta.put("ModelInfo", evalWithResult);
                this.eval("meta.TimingInfo;");
                evalWithResult = this.getVariable("ans");
                meta.put("TimingInfo", evalWithResult);
                this.eval("meta.ExecutionInfo;");
                evalWithResult = this.getVariable("ans");
                meta.put("ExecutionInfo", evalWithResult);
                this.eval("meta.UserString;");
                evalWithResult = this.getVariable("ans");
                meta.put("UserString", evalWithResult);
                this.eval("meta.UserData;");
                evalWithResult = this.getVariable("ans");
                meta.put("UserData", evalWithResult);
                return output;
            }
            throw new MatlabException(e);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new EpsilonSimulinkInternalException(e);
        }
    }

    public Object fevalWithResult(int numberOfOutputs, String function, Object ... handles) throws MatlabException {
        if (this.fevalWithVariableOutputsMethod == null) {
            try {
                this.fevalWithVariableOutputsMethod = this.engine.getClass().getMethod(FEVAL_METHOD, Integer.TYPE, String.class, Object[].class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new EpsilonSimulinkInternalException(e);
            }
        }
        try {
            Object res = this.fevalWithVariableOutputsMethod.invoke(this.engine, numberOfOutputs, function, this.processInputObject(handles));
            if (res != null) {
                return MatlabEngineUtil.parseMatlabEngineVariable(res);
            }
            return null;
        }
        catch (InvocationTargetException e) {
            throw new MatlabException(e);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new EpsilonSimulinkInternalException(e);
        }
    }

    public void feval(int numberOfOutputs, String function, Object ... handles) throws MatlabException {
        if (this.fevalWithVariableOutputsMethod == null) {
            try {
                this.fevalWithVariableOutputsMethod = this.engine.getClass().getMethod(FEVAL_METHOD, Integer.TYPE, String.class, Object[].class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new EpsilonSimulinkInternalException(e);
            }
        }
        try {
            this.fevalWithVariableOutputsMethod.invoke(this.engine, numberOfOutputs, function, this.processInputObject(handles));
        }
        catch (InvocationTargetException e) {
            throw new MatlabException(e);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new EpsilonSimulinkInternalException(e);
        }
    }

    public Object fevalWithResult(String function, Object ... handles) throws MatlabException {
        if (this.fevalMethod == null) {
            try {
                this.fevalMethod = this.engine.getClass().getMethod(FEVAL_METHOD, String.class, Object[].class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new EpsilonSimulinkInternalException(e);
            }
        }
        Object[] processInputObject = this.processInputObject(handles);
        try {
            Object res = this.fevalMethod.invoke(this.engine, function, processInputObject);
            return MatlabEngineUtil.parseMatlabEngineVariable(res);
        }
        catch (InvocationTargetException e) {
            throw new MatlabException(e);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new EpsilonSimulinkInternalException(e);
        }
    }

    public void feval(String function, Object ... handles) throws MatlabException {
        if (this.fevalMethod == null) {
            try {
                this.fevalMethod = this.engine.getClass().getMethod(FEVAL_METHOD, String.class, Object[].class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new EpsilonSimulinkInternalException(e);
            }
        }
        try {
            this.fevalMethod.invoke(this.engine, function, this.processInputObject(handles));
        }
        catch (InvocationTargetException e) {
            throw new MatlabException(e);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new EpsilonSimulinkInternalException(e);
        }
    }

    public void putVariable(String variableName, Object value) throws MatlabException {
        if (this.putVariableMethod == null) {
            try {
                this.putVariableMethod = this.engine.getClass().getMethod(PUT_VARIABLE_METHOD, String.class, Object.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new EpsilonSimulinkInternalException(e);
            }
        }
        try {
            this.putVariableMethod.invoke(this.engine, variableName, this.processInputObject(value));
        }
        catch (InvocationTargetException e) {
            throw new MatlabException(e);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new EpsilonSimulinkInternalException(e);
        }
    }

    public void fevalAsync(String function, Object ... handles) throws MatlabException {
        if (this.fevalAsyncMethod == null) {
            try {
                this.fevalAsyncMethod = this.engine.getClass().getMethod(FEVAL_ASYNC_METHOD, String.class, Object[].class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new EpsilonSimulinkInternalException(e);
            }
        }
        try {
            this.fevalAsyncMethod.invoke(this.engine, function, handles);
        }
        catch (InvocationTargetException e) {
            throw new MatlabException(e);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new EpsilonSimulinkInternalException(e);
        }
    }

    public void close() throws MatlabException {
        if (this.closeMethod == null) {
            try {
                this.closeMethod = this.engine.getClass().getMethod(CLOSE_METHOD, new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new EpsilonSimulinkInternalException(e);
            }
        }
        try {
            this.closeMethod.invoke(this.engine, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new MatlabException(e);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new EpsilonSimulinkInternalException(e);
        }
    }

    public void quit() throws MatlabException {
        if (this.quitMethod == null) {
            try {
                this.quitMethod = this.engine.getClass().getMethod(QUIT_METHOD, new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new EpsilonSimulinkInternalException(e);
            }
        }
        try {
            this.quitMethod.invoke(this.engine, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new MatlabException(e);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new EpsilonSimulinkInternalException(e);
        }
    }

    public void disconnect() throws MatlabException {
        if (this.disconnectMethod == null) {
            try {
                this.disconnectMethod = this.engine.getClass().getMethod(DISCONNECT_METHOD, new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new EpsilonSimulinkInternalException(e);
            }
        }
        try {
            this.disconnectMethod.invoke(this.engine, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new MatlabException(e);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new EpsilonSimulinkInternalException(e);
        }
    }
}

