/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.dictionary.model;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.collections.collection.CompositeCollection;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.emc.simulink.dictionary.model.data.SimulinkDataType;
import org.eclipse.epsilon.emc.simulink.dictionary.model.element.ISimulinkDictionaryModelElement;
import org.eclipse.epsilon.emc.simulink.dictionary.model.element.SectionEnum;
import org.eclipse.epsilon.emc.simulink.dictionary.model.element.SimulinkEntry;
import org.eclipse.epsilon.emc.simulink.dictionary.model.element.SimulinkSection;
import org.eclipse.epsilon.emc.simulink.dictionary.operations.contributor.DictionaryModelOperationContributor;
import org.eclipse.epsilon.emc.simulink.dictionary.util.collection.SimulinkEntryCollection;
import org.eclipse.epsilon.emc.simulink.exception.EpsilonSimulinkInternalException;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.model.AbstractSimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.IGenericSimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.model.element.MatlabHandleElement;
import org.eclipse.epsilon.emc.simulink.types.HandleObject;
import org.eclipse.epsilon.eol.EolModule;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.IRelativePathResolver;

public class SimulinkDictionaryModel
extends AbstractSimulinkModel
implements ISimulinkDictionaryModelElement {
    protected static final String CREATE_FILE = "Simulink.data.dictionary.create";
    protected static final String OPEN_FILE = "Simulink.data.dictionary.open";
    protected MatlabHandleElement dictionaryHandle;
    protected DictionaryModelOperationContributor dicOperationContributor;

    protected void loadModel() throws EolModelLoadingException {
        super.loadModel();
        this.dicOperationContributor = new DictionaryModelOperationContributor(this.engine);
        if (!this.file.exists()) {
            try {
                this.dictionaryHandle = new MatlabHandleElement((IGenericSimulinkModel)this, this.engine, (HandleObject)this.engine.fevalWithResult(CREATE_FILE, new Object[]{this.file.getAbsolutePath()}));
            }
            catch (MatlabException e) {
                throw new EolModelLoadingException((Exception)((Object)e), (IModel)this);
            }
        }
        try {
            this.dictionaryHandle = new MatlabHandleElement((IGenericSimulinkModel)this, this.engine, (HandleObject)this.engine.fevalWithResult(OPEN_FILE, new Object[]{this.file.getAbsolutePath()}));
        }
        catch (MatlabException e) {
            throw new EolModelLoadingException((Exception)((Object)e), (IModel)this);
        }
    }

    public void load(StringProperties properties, IRelativePathResolver resolver) throws EolModelLoadingException {
        super.load(properties, resolver);
        this.load();
    }

    public String getTypeNameOf(Object instance) {
        if (instance instanceof ISimulinkModelElement && ((ISimulinkModelElement)instance).getOwningModel().getClass().equals(this.getClass())) {
            return ((ISimulinkModelElement)instance).getType();
        }
        return null;
    }

    public Object getElementById(String id) {
        throw new IllegalAccessError("Not allowed to get element by id");
    }

    public String getElementId(Object instance) {
        throw new IllegalAccessError("Not allowed to get element by id");
    }

    public void setElementId(Object instance, String newId) {
        throw new IllegalAccessError("Not allowed to set element id");
    }

    public boolean owns(Object instance) {
        if (instance instanceof ISimulinkModelElement && ((ISimulinkModelElement)instance).getOwningModel().getClass().equals(this.getClass())) {
            return true;
        }
        return super.owns(instance);
    }

    public boolean isInstantiable(String type) {
        return Arrays.asList("DesignDataEntry", "OtherDataEntry", "ConfigurationsEntry").contains(type) || super.isInstantiable(type);
    }

    public boolean hasType(String type) {
        return Arrays.asList("Dictionary", "Section", "Entry").contains(type) || Arrays.asList("DesignDataEntry", "OtherDataEntry", "ConfigurationsEntry").contains(type);
    }

    public boolean store(String location) {
        throw new IllegalStateException("Not allowed to save in different location");
    }

    protected void closeMatlabModel() {
        try {
            if (!this.isStoredOnDisposal()) {
                this.engine.feval(0, "discardChanges", new Object[]{this.dictionaryHandle.getHandle()});
                System.out.println("Discarding changes");
            }
            this.engine.feval(0, "close", new Object[]{this.dictionaryHandle.getHandle()});
            System.out.println("Closing model");
        }
        catch (Exception e) {
            System.err.println("Unable to close model");
        }
    }

    public boolean store() {
        try {
            System.out.println("Saving changes");
            this.engine.feval(0, "saveChanges", new Object[]{this.dictionaryHandle.getHandle()});
            return true;
        }
        catch (EpsilonSimulinkInternalException | MatlabException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected Collection<ISimulinkModelElement> allContentsFromModel() {
        try {
            CompositeCollection compositeCollection = new CompositeCollection();
            compositeCollection.addComposited(this.getAllOfKind("Section"));
            compositeCollection.addComposited(this.getAllOfKind("Entry"));
            compositeCollection.addComposited(Arrays.asList(this));
            return compositeCollection;
        }
        catch (EolModelElementTypeNotFoundException e) {
            throw new IllegalStateException("We should know the Entry type");
        }
    }

    protected Collection<ISimulinkModelElement> getAllOfTypeFromModel(String type) throws EolModelElementTypeNotFoundException {
        switch (type) {
            case "DesignDataEntry": 
            case "OtherDataEntry": 
            case "ConfigurationsEntry": {
                SectionEnum sectionType = SectionEnum.forEpsilonEntryType(type);
                SimulinkSection section = sectionType.getFromModel(this);
                try {
                    Object collection = this.engine.fevalWithResult("find", new Object[]{section.getHandle()});
                    return new SimulinkEntryCollection(collection, this);
                }
                catch (MatlabException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        return Collections.emptyList();
    }

    protected Collection<ISimulinkModelElement> getAllOfKindFromModel(String kind) throws EolModelElementTypeNotFoundException {
        switch (kind) {
            case "Dictionary": {
                return Arrays.asList(this);
            }
            case "Section": {
                HashSet<ISimulinkModelElement> sections = new HashSet<ISimulinkModelElement>();
                SectionEnum[] sectionEnumArray = SectionEnum.values();
                int n = sectionEnumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SectionEnum section = sectionEnumArray[n2];
                    sections.add(section.getFromModel(this));
                    ++n2;
                }
                return sections;
            }
            case "Entry": {
                SimulinkEntryCollection entries = new SimulinkEntryCollection(null, this);
                SectionEnum[] sectionEnumArray = SectionEnum.values();
                int n = sectionEnumArray.length;
                int n3 = 0;
                while (n3 < n) {
                    SectionEnum sectionType = sectionEnumArray[n3];
                    SimulinkSection section = sectionType.getFromModel(this);
                    try {
                        Object collection = this.engine.fevalWithResult("find", new Object[]{section.getHandle()});
                        entries.addPrimitive(collection);
                    }
                    catch (MatlabException e) {
                        e.printStackTrace();
                        throw new IllegalStateException(e.getMessage());
                    }
                    ++n3;
                }
                return entries;
            }
        }
        return this.getAllOfTypeFromModel(kind);
    }

    protected ISimulinkModelElement createInstanceInModel(String type) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        switch (type) {
            case "Dictionary": 
            case "Section": 
            case "Entry": {
                throw new EolNotInstantiableModelElementTypeException(this.name, type);
            }
            case "DesignDataEntry": 
            case "OtherDataEntry": 
            case "ConfigurationsEntry": {
                return new SimulinkEntry(this, this.engine, SectionEnum.forEpsilonEntryType(type));
            }
        }
        if (type.startsWith("Simulink.")) {
            return new SimulinkDataType(this, this.engine, type);
        }
        return super.createInstanceInModel(type);
    }

    protected boolean deleteElementInModel(Object instance) throws EolRuntimeException {
        if (this.owns(instance)) {
            return ((ISimulinkModelElement)instance).deleteElementInModel();
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        SimulinkDictionaryModel dictionaryModel = new SimulinkDictionaryModel();
        dictionaryModel.setReadOnLoad(true);
        dictionaryModel.setStoredOnDisposal(false);
        dictionaryModel.setFile(new File("/Users/bea/Documents/AppDev/epsilon/plugins/org.eclipse.epsilon.emc.simulink.dictionary/resources/dd5.sldd"));
        dictionaryModel.setLibraryPath("/Applications/MATLAB_R2018b.app/bin/maci64/");
        dictionaryModel.setEngineJarPath("/Applications/MATLAB_R2018b.app/extern/engines/java/jar/engine.jar");
        System.out.println("Loading");
        dictionaryModel.load();
        EolModule module = new EolModule();
        module.getContext().getModelRepository().addModel((IModel)dictionaryModel);
        module.parse("'Starting'.println();\nDictionary.all.first().println();\n Section.all.first().println();\n Entry.all.size().println('Entries: ');");
        System.out.println("Executing");
        module.execute();
    }

    public IModel getOwningModel() {
        return this;
    }

    public Object getProperty(String property) throws EolRuntimeException {
        return this.dictionaryHandle.getProperty(property);
    }

    public void setProperty(String property, Object value) throws EolRuntimeException {
        this.dictionaryHandle.setProperty(property, value);
    }

    public Collection<String> getAllTypeNamesOf() {
        return Arrays.asList(this.getType());
    }

    public boolean deleteElementInModel() throws EolRuntimeException {
        return false;
    }

    public String getType() {
        return "Dictionary";
    }

    public MatlabHandleElement getHandle() {
        return this.dictionaryHandle;
    }
}

