/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.policies;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.gmfgraph.BorderLayout;
import org.eclipse.gmf.gmfgraph.BorderLayoutData;
import org.eclipse.gmf.graphdef.editor.edit.parts.AbstractFigureEditPart;

public class BorderLayoutHelper {
    private Rectangle myCenterBounds;
    private Rectangle myLeftBounds;
    private Rectangle myTopBounds;
    private Rectangle myBottomBounds;
    private Rectangle myRightBounds;

    public BorderLayoutHelper(AbstractFigureEditPart host) {
        this(host.getChildren(), host.getContentPane().getClientArea(), (BorderLayout)host.getRealFigure().getLayout());
    }

    private BorderLayoutHelper(List<AbstractFigureEditPart> childEditParts, Rectangle clientArea, BorderLayout borderLayout) {
        IFigure left = null;
        IFigure right = null;
        IFigure top = null;
        IFigure bottom = null;
        for (AbstractFigureEditPart childEditPart : childEditParts) {
            if (!(childEditPart.getRealFigure().getLayoutData() instanceof BorderLayoutData) || !childEditPart.getFigure().isVisible()) continue;
            BorderLayoutData layoutData = (BorderLayoutData)childEditPart.getRealFigure().getLayoutData();
            switch (layoutData.getAlignment()) {
                case BEGINNING_LITERAL: {
                    if (layoutData.isVertical()) {
                        top = childEditPart.getFigure();
                        break;
                    }
                    left = childEditPart.getFigure();
                    break;
                }
                case END_LITERAL: {
                    if (layoutData.isVertical()) {
                        bottom = childEditPart.getFigure();
                        break;
                    }
                    right = childEditPart.getFigure();
                }
            }
        }
        Rectangle area = clientArea;
        int vGap = borderLayout.getSpacing().getDy();
        int hGap = borderLayout.getSpacing().getDx();
        this.myTopBounds = new Rectangle();
        Dimension preferredSize = top != null ? top.getPreferredSize(area.width, -1) : new Dimension(0, (int)Math.min(10.0, 0.3 * (double)clientArea.width));
        this.myTopBounds.setLocation(area.x, area.y);
        this.myTopBounds.setSize(preferredSize);
        this.myTopBounds.width = area.width;
        area.y += this.myTopBounds.height + vGap;
        area.height -= this.myTopBounds.height + vGap;
        this.myBottomBounds = new Rectangle();
        preferredSize = bottom != null ? bottom.getPreferredSize(Math.max(area.width, 0), -1) : new Dimension(0, (int)Math.min(10.0, 0.3 * (double)clientArea.width));
        this.myBottomBounds.setSize(preferredSize);
        this.myBottomBounds.width = area.width;
        this.myBottomBounds.setLocation(area.x, area.y + area.height - this.myBottomBounds.height);
        area.height -= preferredSize.height + vGap;
        this.myLeftBounds = new Rectangle();
        preferredSize = left != null ? left.getPreferredSize(-1, Math.max(0, area.height)) : new Dimension((int)Math.min(10.0, 0.3 * (double)clientArea.height), 0);
        this.myLeftBounds.setLocation(area.x, area.y);
        this.myLeftBounds.width = preferredSize.width;
        this.myLeftBounds.height = Math.max(0, area.height);
        area.x += preferredSize.width + hGap;
        area.width -= preferredSize.width + hGap;
        this.myRightBounds = new Rectangle();
        preferredSize = right != null ? right.getPreferredSize(-1, Math.max(0, area.height)) : new Dimension((int)Math.min(10.0, 0.3 * (double)clientArea.height), 0);
        this.myRightBounds.width = preferredSize.width;
        this.myRightBounds.height = Math.max(0, area.height);
        this.myRightBounds.setLocation(area.x + area.width - this.myRightBounds.width, area.y);
        area.width -= preferredSize.width + hGap;
        if (area.width < 0) {
            area.width = 0;
        }
        if (area.height < 0) {
            area.height = 0;
        }
        this.myCenterBounds = area;
    }

    public Integer getConstraintFor(Point point) {
        if (this.myBottomBounds.contains(point)) {
            return org.eclipse.draw2d.BorderLayout.BOTTOM;
        }
        if (this.myTopBounds.contains(point)) {
            return org.eclipse.draw2d.BorderLayout.TOP;
        }
        if (this.myLeftBounds.contains(point)) {
            return org.eclipse.draw2d.BorderLayout.LEFT;
        }
        if (this.myRightBounds.contains(point)) {
            return org.eclipse.draw2d.BorderLayout.RIGHT;
        }
        return org.eclipse.draw2d.BorderLayout.CENTER;
    }

    public Rectangle getFeedbackBounds(Point point) {
        Integer constraint = this.getConstraintFor(point);
        if (constraint == org.eclipse.draw2d.BorderLayout.BOTTOM) {
            return this.myBottomBounds.getCopy();
        }
        if (constraint == org.eclipse.draw2d.BorderLayout.TOP) {
            return this.myTopBounds.getCopy();
        }
        if (constraint == org.eclipse.draw2d.BorderLayout.LEFT) {
            return this.myLeftBounds.getCopy();
        }
        if (constraint == org.eclipse.draw2d.BorderLayout.RIGHT) {
            return this.myRightBounds.getCopy();
        }
        return this.myCenterBounds.getCopy();
    }
}

