/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.edit.parts.update;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.lite.edit.parts.update.IExternallyUpdatableEditPart;
import org.eclipse.gmf.runtime.lite.edit.parts.update.IUpdatableEditPart;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class UpdateManager
extends EContentAdapter {
    private final EditPartViewer myViewer;

    public UpdateManager(EditPartViewer viewer) {
        this.myViewer = viewer;
    }

    public void notifyChanged(Notification msg) {
        super.notifyChanged(msg);
        if (msg.isTouch()) {
            return;
        }
        Collection<IUpdatableEditPart> affectedEditParts = this.findAffectedParts(msg);
        for (IUpdatableEditPart next : affectedEditParts) {
            IUpdatableEditPart.Refresher refresher;
            if (next instanceof IExternallyUpdatableEditPart) {
                for (IExternallyUpdatableEditPart.ExternalRefresher nextExternalRefresher : ((IExternallyUpdatableEditPart)next).getExternalRefreshers()) {
                    if (!nextExternalRefresher.isAffectingEvent(msg)) continue;
                    nextExternalRefresher.refresh();
                }
            }
            if ((refresher = next.getRefresher((EStructuralFeature)msg.getFeature(), msg)) == null) continue;
            refresher.refresh();
        }
    }

    private Collection<IUpdatableEditPart> findAffectedParts(Notification msg) {
        View view;
        Object notifier = msg.getNotifier();
        if (notifier instanceof EObject && (view = this.getView((EObject)notifier)) != null) {
            EditPart affectedEditPart = (EditPart)this.myViewer.getEditPartRegistry().get(view);
            if (affectedEditPart instanceof IUpdatableEditPart) {
                if (msg.getFeature() == NotationPackage.eINSTANCE.getView_Visible() && affectedEditPart.getParent() instanceof IUpdatableEditPart) {
                    return Arrays.asList((IUpdatableEditPart)affectedEditPart, (IUpdatableEditPart)affectedEditPart.getParent());
                }
                return Collections.singleton((IUpdatableEditPart)affectedEditPart);
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private View getView(EObject offspring) {
        while (offspring != null && !(offspring instanceof View) || this.isFiltered((View)offspring)) {
            offspring = offspring.eContainer();
        }
        return (View)offspring;
    }

    protected boolean isFiltered(View view) {
        return this.myViewer.getEditPartRegistry().get(view) == null;
    }
}

