/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.output.stateviz;

import java.util.List;
import org.eclipse.escet.cif.simulator.options.CifSpecOption;
import org.eclipse.escet.cif.simulator.options.FrameRateOption;
import org.eclipse.escet.cif.simulator.options.InputModeOption;
import org.eclipse.escet.cif.simulator.output.NullSimulatorOutputComponent;
import org.eclipse.escet.cif.simulator.output.stateviz.StateVisualizationFiltersOption;
import org.eclipse.escet.cif.simulator.output.stateviz.StateVisualizationOption;
import org.eclipse.escet.cif.simulator.output.stateviz.StateVisualizer;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.cif.simulator.runtime.transitions.EventTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.Transition;
import org.eclipse.escet.common.app.framework.SWTUtils;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.eclipse.ui.ControlEditor;
import org.eclipse.escet.common.java.Lists;

public class StateVisualizerOutputComponent
extends NullSimulatorOutputComponent {
    private StateVisualizer visualizer;
    private final boolean interactive;
    private final boolean realTime;
    private final boolean sync = true;

    public StateVisualizerOutputComponent(String filtersTxt) {
        if (this.testMode) {
            this.visualizer = null;
        } else {
            String path = CifSpecOption.getCifSpecPath();
            this.visualizer = (StateVisualizer)ControlEditor.show((String)path, StateVisualizer.class, (String)"show the state visualizer");
            this.visualizer.filtersTxt = filtersTxt;
        }
        this.interactive = InputModeOption.isInteractive();
        this.realTime = FrameRateOption.isRealTimeEnabled();
    }

    @Override
    public void initialState(final RuntimeState state) {
        final StateVisualizer viz = this.visualizer;
        if (viz == null) {
            return;
        }
        viz.initMeta(state);
        SWTUtils.exec((boolean)true, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (!viz.isAvailable()) {
                    return;
                }
                viz.initTable(state);
                viz.update(state);
            }
        });
    }

    @Override
    public void intermediateTrajectoryState(final RuntimeState state) {
        final StateVisualizer viz = this.visualizer;
        if (viz == null) {
            return;
        }
        SWTUtils.exec((boolean)true, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (!viz.isAvailable()) {
                    return;
                }
                viz.update(state);
            }
        });
    }

    @Override
    public void transitionTaken(RuntimeState sourceState, Transition<?> transition, final RuntimeState targetState, Boolean interrupted) {
        if (!this.interactive && this.realTime && transition instanceof EventTransition) {
            return;
        }
        final StateVisualizer viz = this.visualizer;
        if (viz == null) {
            return;
        }
        SWTUtils.exec((boolean)true, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (!viz.isAvailable()) {
                    return;
                }
                viz.update(targetState);
            }
        });
    }

    public void cleanup() {
        if (this.visualizer != null) {
            this.visualizer = null;
        }
    }

    @Override
    public boolean hasVisualInterface() {
        return this.visualizer != null && this.visualizer.isAvailable();
    }

    public static OptionCategory getOptions() {
        List subCats = Lists.list();
        List opts = Lists.list();
        opts.add(Options.getInstance(StateVisualizationOption.class));
        opts.add(Options.getInstance(StateVisualizationFiltersOption.class));
        return new OptionCategory("State visualization", "State visualization options.", subCats, opts);
    }
}

