/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.statements.seq;

import org.eclipse.escet.chi.codegen.expressions.ExpressionBase;
import org.eclipse.escet.chi.codegen.statements.seq.Seq;
import org.eclipse.escet.chi.codegen.statements.seq.SeqList;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.MultiLineTextBox;
import org.eclipse.escet.common.box.TextBox;
import org.eclipse.escet.common.box.VBox;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class SeqForLoop
extends Seq {
    public final ExpressionBase init;
    public final ExpressionBase endCondition;
    public final ExpressionBase increment;
    public final SeqList childStats;

    public SeqForLoop(ExpressionBase init, ExpressionBase endCondition, ExpressionBase increment, SeqList childStats, PositionObject stat) {
        super(stat);
        this.init = init;
        this.endCondition = endCondition;
        this.increment = increment;
        this.childStats = childStats;
    }

    @Override
    public Box boxify() {
        boolean useWhile = this.endCondition != null && !this.endCondition.getCode().isEmpty();
        Box childs = this.childStats.boxify();
        VBox vb = new VBox(4);
        if (useWhile && this.endCondition != null) {
            if (!this.endCondition.getCode().isEmpty()) {
                this.endCondition.setCurrentPositionStatement(vb);
                vb.add((Box)new MultiLineTextBox(this.endCondition.getCode()));
            }
            String endCheck = Strings.fmt((String)"if (!(%s)) break;", (Object[])new Object[]{this.endCondition.getValue()});
            vb.add(endCheck);
        }
        vb.add(childs);
        if (this.increment != null && !this.increment.getCode().isEmpty()) {
            this.increment.setCurrentPositionStatement(vb);
            vb.add((Box)new MultiLineTextBox(this.increment.getCode()));
            if (useWhile) {
                vb.add((Box)new TextBox(this.increment.getValue()));
            }
        }
        childs = vb;
        vb = new VBox(0);
        if (this.init != null && !this.init.getCode().isEmpty()) {
            this.init.setCurrentPositionStatement(vb);
            vb.add((Box)new MultiLineTextBox(this.init.getCode()));
        }
        if (useWhile) {
            vb.add("while (true) {");
            vb.add("    if (NEVER) break;");
            vb.add("    chiCoordinator.testTerminating();");
            vb.add(childs);
            vb.add("}");
        } else {
            String iniText = this.init != null ? this.init.getValue() : "";
            String endText = this.endCondition != null ? this.endCondition.getValue() : "";
            String incText = this.increment != null ? this.increment.getValue() : "";
            String forLine = Strings.fmt((String)"for (%s;%s;%s) {", (Object[])new Object[]{iniText, endText, incText});
            this.setCurrentPositionStatement(vb);
            vb.add(forLine);
            vb.add("    if (NEVER) break;");
            vb.add("    chiCoordinator.testTerminating();");
            vb.add(childs);
            this.setCurrentPositionStatement(vb);
            vb.add("}");
        }
        return vb;
    }
}

