/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.input;

import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.escet.cif.simulator.input.ChosenTargetTime;
import org.eclipse.escet.cif.simulator.input.InteractiveInputComponent;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorException;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.cif.simulator.runtime.SimulationResult;
import org.eclipse.escet.cif.simulator.runtime.SimulatorExitException;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeSpec;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.cif.simulator.runtime.transitions.HistoryTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.ResetTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.Transition;
import org.eclipse.escet.cif.simulator.runtime.transitions.UndoTransition;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;

public final class InteractiveConsoleInputComponent<S extends RuntimeState>
extends InteractiveInputComponent<S> {
    private final AppStreams streams;

    public InteractiveConsoleInputComponent(RuntimeSpec<S> spec, AppStreams streams) {
        super(spec);
        this.streams = streams;
    }

    @Override
    protected boolean needAutomaticInputComponent() {
        return this.autoTime || this.autoTimeDur || ArrayUtils.contains((boolean[])this.autoEvents, (boolean)true);
    }

    @Override
    protected Transition<S> chooseTransitionInteractive(S state, List<Transition<S>> transitions) {
        int nr;
        String question = Strings.fmt((String)"Select a transition ([1..%d]). Enter q to quit. Enter h for help and additional commands. Confirm with <ENTER>: ", (Object[])new Object[]{transitions.size()});
        this.streams.out.print(question);
        this.streams.out.flush();
        while (true) {
            String choice;
            try {
                choice = this.streams.in.readLine();
            }
            catch (IOException ex) {
                throw new InputOutputException("Could not read input.", (Throwable)ex);
            }
            if (choice == null) {
                throw new SimulatorExitException(SimulationResult.USER_TERMINATED);
            }
            choice = choice.trim();
            this.spec.ctxt.checkTermination();
            if (choice.length() == 0) {
                choice = "1";
            }
            if (choice.equals("q") || choice.equals("Q")) {
                throw new SimulatorExitException(SimulationResult.USER_TERMINATED);
            }
            if (choice.equals("h") || choice.equals("H")) {
                this.streams.out.println();
                this.printHelp(true);
                this.streams.out.println();
                this.streams.out.print("Please make another choice: ");
                this.streams.out.flush();
                continue;
            }
            if (choice.equals("r") || choice.equals("R")) {
                if (this.history == null) {
                    this.streams.err.print("Can't reset simulation, as history is disabled. Please try again: ");
                    this.streams.err.flush();
                    continue;
                }
                if (!this.history.canReset((RuntimeState)state)) {
                    this.streams.err.print("Can't reset simulation, as initial state is already the current state. Please try again: ");
                    this.streams.err.flush();
                    continue;
                }
                RuntimeState target = this.history.reset();
                return new ResetTransition<RuntimeState>((RuntimeState)state, target);
            }
            if (choice.startsWith("u") || choice.startsWith("U")) {
                int count;
                String remainder = choice.substring(1).trim();
                if (remainder.isEmpty()) {
                    count = 1;
                } else {
                    while (true) {
                        try {
                            count = Integer.parseInt(remainder);
                        }
                        catch (NumberFormatException ex) {
                            this.streams.err.print(Strings.fmt((String)"\"%s\" is not a valid integer number. Please try again: ", (Object[])new Object[]{remainder}));
                            this.streams.err.flush();
                            continue;
                        }
                        if (count >= 1) break;
                        this.streams.err.print(Strings.fmt((String)"\"%s\" is not a positive number. Please try again: ", (Object[])new Object[]{count}));
                        this.streams.err.flush();
                    }
                }
                if (this.history == null) {
                    this.streams.err.print("Can't undo last transition, as history is disabled. Please try again: ");
                    this.streams.err.flush();
                    continue;
                }
                if (!this.history.isUndoEnabled()) {
                    this.streams.err.print("Can't undo last transition, as undo is disabled. Please try again: ");
                    this.streams.err.flush();
                    continue;
                }
                if (!this.history.canUndo((RuntimeState)state, count)) {
                    this.streams.err.print(Strings.fmt((String)"Can't undo %d transition%s, as that many transitions have not been taken, or the undo buffer is too small. Please try again: ", (Object[])new Object[]{count, count == 1 ? "" : "s"}));
                    this.streams.err.flush();
                    continue;
                }
                RuntimeState target = this.history.undo(count);
                return new UndoTransition<RuntimeState>((RuntimeState)state, target, count);
            }
            try {
                nr = Integer.parseInt(choice);
            }
            catch (NumberFormatException ex) {
                this.streams.err.print(Strings.fmt((String)"\"%s\" is not a valid integer number. Please try again: ", (Object[])new Object[]{choice}));
                this.streams.err.flush();
                continue;
            }
            if (nr >= 1 && nr <= transitions.size()) break;
            this.streams.err.print(Strings.fmt((String)"\"%s\" is not part of the interval [1..%d]. Please try again: ", (Object[])new Object[]{choice, transitions.size()}));
            this.streams.err.flush();
        }
        return transitions.get(nr - 1);
    }

    @Override
    protected HistoryTransition<S> chooseTransitionInteractive(S state, SimulationResult result) {
        Object question = switch (result) {
            case SimulationResult.DEADLOCK -> "Simulation resulted in deadlock. ";
            case SimulationResult.ENDTIME_REACHED -> "User-provided simulation end time reached. ";
            default -> throw new RuntimeException("Unexpected result: " + String.valueOf((Object)result));
        };
        question = (String)question + "Enter q to quit. Enter h for help and additional commands. Confirm with <ENTER>: ";
        this.streams.out.print((String)question);
        this.streams.out.flush();
        while (true) {
            String choice;
            if (this.spec.ctxt.appEnvData.isTerminationRequested()) {
                throw new SimulatorExitException(result);
            }
            try {
                choice = this.streams.in.readLine();
            }
            catch (IOException ex) {
                throw new InputOutputException("Could not read input.", (Throwable)ex);
            }
            if (choice == null) {
                throw new SimulatorExitException(result);
            }
            choice = choice.trim();
            if (this.spec.ctxt.appEnvData.isTerminationRequested()) {
                throw new SimulatorExitException(result);
            }
            if (choice.equals("q") || choice.equals("Q")) {
                throw new SimulatorExitException(result);
            }
            if (choice.equals("h") || choice.equals("H")) {
                this.streams.out.println();
                this.printHelp(false);
                this.streams.out.println();
                this.streams.out.print("Please make another choice: ");
                this.streams.out.flush();
                continue;
            }
            if (choice.equals("r") || choice.equals("R")) {
                if (this.history == null) {
                    this.streams.err.print("Can't reset simulation, as history is disabled. Please try again: ");
                    this.streams.err.flush();
                    continue;
                }
                if (!this.history.canReset((RuntimeState)state)) {
                    this.streams.err.print("Can't reset simulation, as initial state is already the current state. Please try again: ");
                    this.streams.err.flush();
                    continue;
                }
                RuntimeState target = this.history.reset();
                return new ResetTransition<RuntimeState>((RuntimeState)state, target);
            }
            if (choice.startsWith("u") || choice.startsWith("U")) {
                int count;
                String remainder = choice.substring(1).trim();
                if (remainder.isEmpty()) {
                    count = 1;
                } else {
                    while (true) {
                        try {
                            count = Integer.parseInt(remainder);
                        }
                        catch (NumberFormatException ex) {
                            this.streams.err.print(Strings.fmt((String)"\"%s\" is not a valid integer number. Please try again: ", (Object[])new Object[]{remainder}));
                            this.streams.err.flush();
                            continue;
                        }
                        if (count >= 1) break;
                        this.streams.err.print(Strings.fmt((String)"\"%s\" is not a positive number. Please try again: ", (Object[])new Object[]{count}));
                        this.streams.err.flush();
                    }
                }
                if (this.history == null) {
                    this.streams.err.print("Can't undo last transition, as history is disabled. Please try again: ");
                    this.streams.err.flush();
                    continue;
                }
                if (!this.history.isUndoEnabled()) {
                    this.streams.err.print("Can't undo last transition, as undo is disabled. Please try again: ");
                    this.streams.err.flush();
                    continue;
                }
                if (!this.history.canUndo((RuntimeState)state, count)) {
                    this.streams.err.print(Strings.fmt((String)"Can't undo %d transition%s, as that many transitions have not been taken, or the undo buffer is too small. Please try again: ", (Object[])new Object[]{count, count == 1 ? "" : "s"}));
                    this.streams.err.flush();
                    continue;
                }
                RuntimeState target = this.history.undo(count);
                return new UndoTransition<RuntimeState>((RuntimeState)state, target, count);
            }
            this.streams.err.print(Strings.fmt((String)"\"%s\" is not a valid choice. Please try again: ", (Object[])new Object[]{choice}));
            this.streams.err.flush();
        }
    }

    private void printHelp(boolean canChooseTransitions) {
        this.streams.out.println("Interactive console input command help:");
        if (canChooseTransitions) {
            this.streams.out.println("  <nothing, only ENTER>    Choose transition 1.");
            this.streams.out.println("  <number>                 Choose transition <number>.");
        }
        this.streams.out.println("  r                        Reset simulation to initial state.");
        this.streams.out.println("  u                        Undo a single transition.");
        this.streams.out.println("  u <number>               Undo <number> transition(s).");
        this.streams.out.println("  q                        Quit simulation.");
        this.streams.out.println("  h                        Show this help text.");
    }

    @Override
    protected ChosenTargetTime chooseTargetTimeInteractive(S state, double maxTargetTime) {
        double targetTime;
        double sourceTime = ((RuntimeState)state).getTime();
        double maxDelay = maxTargetTime - sourceTime;
        String question = Strings.fmt((String)"Select a duration from (0 .. %s]. Empty choice equals maximum delay. Enter q to quit. Confirm with <ENTER>: ", (Object[])new Object[]{maxDelay});
        this.streams.out.print(question);
        this.streams.out.flush();
        while (true) {
            double delay;
            String choice;
            try {
                choice = this.streams.in.readLine();
            }
            catch (IOException ex) {
                throw new InputOutputException("Could not read input.", (Throwable)ex);
            }
            if (choice == null) {
                throw new SimulatorExitException(SimulationResult.USER_TERMINATED);
            }
            choice = choice.trim();
            this.spec.ctxt.checkTermination();
            if (choice.equals("q") || choice.equals("Q")) {
                throw new SimulatorExitException(SimulationResult.USER_TERMINATED);
            }
            if (choice.length() == 0) {
                return new ChosenTargetTime(sourceTime, maxTargetTime, true);
            }
            try {
                delay = CifSimulatorMath.strToReal(choice);
            }
            catch (CifSimulatorException ex) {
                this.streams.err.print(Strings.fmt((String)"\"%s\" is not a valid real number. Please try again: ", (Object[])new Object[]{choice}));
                this.streams.err.flush();
                continue;
            }
            if (delay <= 0.0 || maxDelay < delay) {
                this.streams.err.print(Strings.fmt((String)"\"%s\" is not part of the interval (0 .. %s]. Please try again: ", (Object[])new Object[]{choice, maxDelay}));
                this.streams.err.flush();
                continue;
            }
            targetTime = sourceTime + delay;
            if (targetTime != sourceTime) break;
            this.streams.err.print(Strings.fmt((String)"Target time \"%s\" after delay \"%s\" is too close to the current time \"%s\". Please try again: ", (Object[])new Object[]{CifSimulatorMath.realToStr(targetTime), choice, CifSimulatorMath.realToStr(sourceTime)}));
            this.streams.err.flush();
        }
        if (targetTime > maxTargetTime) {
            targetTime = maxTargetTime;
        }
        return new ChosenTargetTime(sourceTime, targetTime, false);
    }
}

