/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.appsview.ui.commands;

import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.escet.common.app.framework.appsview.ui.AppsView;
import org.eclipse.escet.common.app.framework.appsview.ui.commands.AppStatusLegendDialog;
import org.eclipse.escet.common.app.framework.appsview.ui.commands.ToolItemCommand;
import org.eclipse.escet.common.app.framework.appsview.ui.icons.AppStatusIcons;
import org.eclipse.swt.widgets.Tree;

public class AppStatusLegendCommand
extends ToolItemCommand {
    @Override
    public String getIconUri() {
        return "platform:/plugin/org.eclipse.escet.common.app.framework.appsview.ui/icons/command_app_status_legend.png";
    }

    @Override
    public String getItemLabel() {
        return "Application Status &Legend";
    }

    @Override
    public String getTooltip() {
        return "Show the legend for the application status icons";
    }

    @Override
    public String getContributionUri() {
        return "bundleclass://org.eclipse.escet.common.app.framework.appsview.ui/" + this.getClass().getName();
    }

    @Override
    public ItemType getItemType() {
        return ItemType.PUSH;
    }

    @Override
    public void execute(MPart part) {
        AppsView view = (AppsView)part.getObject();
        if (view == null) {
            return;
        }
        Tree tree = view.getTree();
        if (tree == null || tree.isDisposed()) {
            return;
        }
        AppStatusIcons icons = view.getIcons();
        AppStatusLegendDialog dialog = new AppStatusLegendDialog(tree.getShell(), icons);
        dialog.create();
        dialog.getShell().setText(this.getItemLabel().replace("&", ""));
        dialog.getShell().setVisible(true);
    }
}

