/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.ode;

import org.apache.commons.math3.ode.events.EventHandler;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.cif.simulator.runtime.ode.OdeSolver;

public abstract class OdeStateEvent<S extends RuntimeState>
implements EventHandler {
    private final OdeSolver<S> solver;

    public OdeStateEvent(OdeSolver<S> solver) {
        this.solver = solver;
    }

    public abstract String getPredText();

    protected abstract boolean eval(S var1);

    public final void init(double t0, double[] y0, double t) {
    }

    public final double g(double t, double[] y) {
        boolean b;
        double rslt;
        this.solver.ctxt.checkTermination();
        this.solver.checkValues(t, y);
        S state = this.solver.updateState(t, y);
        if (this.solver.debug) {
            String valuesTxt = this.solver.valuesToStr(t, y, false);
            this.solver.dbg.printfln("ODE solver: evaluating guard \"%s\": %s", new Object[]{this.getPredText(), valuesTxt});
        }
        double d = rslt = (b = this.eval(state)) ? 1.0 : -1.0;
        if (this.solver.debug) {
            this.solver.dbg.printfln("ODE solver: evaluated guard \"%s\": %s.", new Object[]{this.getPredText(), b});
        }
        return rslt;
    }

    public final EventHandler.Action eventOccurred(double t, double[] y, boolean increasing) {
        if (this.solver.debug) {
            String valuesTxt = this.solver.valuesToStr(t, y, false);
            this.solver.dbg.printfln("ODE solver: state event detected for guard \"%s\": %s", new Object[]{this.getPredText(), valuesTxt});
        }
        return EventHandler.Action.STOP;
    }

    public final void resetState(double t, double[] y) {
        throw new UnsupportedOperationException();
    }
}

