/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.types;

import java.util.List;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.Constants;
import org.eclipse.escet.chi.codegen.expressions.CodeExpression;
import org.eclipse.escet.chi.codegen.expressions.ExpressionBase;
import org.eclipse.escet.chi.codegen.expressions.SimpleExpression;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.types.PrimitiveTypeID;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.metamodel.chi.BinaryExpression;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.IntNumber;
import org.eclipse.escet.chi.metamodel.chi.UnaryExpression;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class IntTypeID
extends PrimitiveTypeID {
    public IntTypeID() {
        super(TypeID.TypeKind.INT);
    }

    @Override
    public String getTypeText() {
        return "int";
    }

    @Override
    public String getJavaType() {
        return "int";
    }

    @Override
    public String getJavaClassType() {
        return "Integer";
    }

    @Override
    public String getStaticReadFuncName() {
        return "org.eclipse.escet.chi.runtime.IoFunctions.readInt";
    }

    @Override
    public String getWriteName(String stream, String val, JavaFile jf) {
        Assert.check((boolean)this.isPrintable());
        jf.addImport("org.eclipse.escet.chi.runtime.IoFunctions.writeInt", true);
        return Strings.fmt((String)"%s(%s, %s);", (Object[])new Object[]{Constants.getClassname("org.eclipse.escet.chi.runtime.IoFunctions.writeInt"), stream, val});
    }

    @Override
    public String getToString(String val, JavaFile jf) {
        return Strings.fmt((String)"String.valueOf(%s)", (Object[])new Object[]{val});
    }

    @Override
    public String getHashCodeName(String val, JavaFile jf) {
        return val;
    }

    @Override
    public String getEmptyValue(JavaFile jf) {
        return "0";
    }

    @Override
    public String getSimplestJavaValue() {
        return "0";
    }

    @Override
    public ExpressionBase convertExprNode(Expression expr, CodeGeneratorContext ctxt, JavaFile currentFile) {
        if (expr instanceof IntNumber) {
            IntNumber num = (IntNumber)expr;
            return new SimpleExpression(num.getValue(), (PositionObject)num);
        }
        if (expr instanceof BinaryExpression) {
            String text;
            BinaryExpression binexpr = (BinaryExpression)expr;
            ExpressionBase left = ExpressionBase.convertExpression(binexpr.getLeft(), ctxt, currentFile);
            ExpressionBase right = ExpressionBase.convertExpression(binexpr.getRight(), ctxt, currentFile);
            String lv = left.getValue();
            String rv = right.getValue();
            switch (binexpr.getOp()) {
                case ADDITION: {
                    text = Strings.fmt((String)"(%s) + (%s)", (Object[])new Object[]{lv, rv});
                    break;
                }
                case FLOOR_DIVISION: {
                    currentFile.addImport("org.eclipse.escet.chi.runtime.ArithmeticFunctions.floorDivision", true);
                    text = Strings.fmt((String)"floorDivision(%s, %s)", (Object[])new Object[]{lv, rv});
                    break;
                }
                case MODULUS: {
                    currentFile.addImport("org.eclipse.escet.chi.runtime.ArithmeticFunctions.modulus", true);
                    text = Strings.fmt((String)"modulus(%s, %s)", (Object[])new Object[]{lv, rv});
                    break;
                }
                case MULTIPLICATION: {
                    text = Strings.fmt((String)"(%s) * (%s)", (Object[])new Object[]{lv, rv});
                    break;
                }
                case SUBTRACTION: {
                    text = Strings.fmt((String)"(%s) - (%s)", (Object[])new Object[]{lv, rv});
                    break;
                }
                default: {
                    Assert.fail((Object)("Unexpected binary operator " + binexpr.getOp().toString() + " in IntTypeID.convertExprNode"));
                    return null;
                }
            }
            if (!left.getCode().isEmpty() || !right.getCode().isEmpty()) {
                List lines = Lists.list();
                lines.addAll(left.getCode());
                lines.addAll(right.getCode());
                return new CodeExpression(lines, text, (PositionObject)expr);
            }
            return new SimpleExpression(text, (PositionObject)expr);
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression unexpr = (UnaryExpression)expr;
            switch (unexpr.getOp()) {
                case NEGATE: {
                    ExpressionBase chExpr = ExpressionBase.convertExpression(unexpr.getChild(), ctxt, currentFile);
                    return ExpressionBase.makeExpression(chExpr.getCode(), "-(" + chExpr.getValue() + ")", (PositionObject)expr);
                }
                case PLUS: {
                    return ExpressionBase.convertExpression(unexpr.getChild(), ctxt, currentFile);
                }
            }
            Assert.fail((Object)("Unexpected unary operator " + unexpr.getOp().toString() + " in IntTypeID.convertExprNode"));
            return null;
        }
        Assert.fail((Object)("Unexpected expression in convertExprNode(" + expr.toString() + "): kind=" + this.kind.toString()));
        return null;
    }
}

