/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.distributions;

import org.eclipse.escet.cif.simulator.runtime.CifSimulatorException;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.cif.simulator.runtime.distributions.CifRandomGenerator;
import org.eclipse.escet.cif.simulator.runtime.distributions.IntegerDistribution;
import org.eclipse.escet.common.java.Strings;

public class PoissonDistribution
extends IntegerDistribution {
    private final CifRandomGenerator randGen;
    private final double r;

    public PoissonDistribution(CifRandomGenerator randGen, double r) {
        this.randGen = randGen;
        this.r = r;
        if (r <= 0.0) {
            String msg1 = Strings.fmt((String)"Invalid operation: %s.", (Object[])new Object[]{this});
            String msg2 = "The rate parameter is not positive.";
            CifSimulatorException e = new CifSimulatorException(msg2);
            throw new CifSimulatorException(msg1, e);
        }
    }

    private PoissonDistribution(PoissonDistribution distribution) {
        this.randGen = distribution.randGen.copy();
        this.r = distribution.r;
    }

    @Override
    public IntegerDistribution copy() {
        return new PoissonDistribution(this);
    }

    @Override
    public int sample() {
        double e = Math.exp(-this.r);
        double p = 1.0;
        int r = -1;
        while (p > e) {
            p *= this.randGen.drawNonZero();
            ++r;
        }
        return r;
    }

    @Override
    public String toString() {
        return Strings.fmt((String)"poisson(%s)", (Object[])new Object[]{CifSimulatorMath.realToStr(this.r)});
    }
}

