/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.javascript;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.CodeGen;
import org.eclipse.escet.cif.codegen.CurlyBraceIfElseGenerator;
import org.eclipse.escet.cif.codegen.DataValue;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.ExprCodeGen;
import org.eclipse.escet.cif.codegen.IfElseGenerator;
import org.eclipse.escet.cif.codegen.SvgCodeGen;
import org.eclipse.escet.cif.codegen.TypeCodeGen;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.assignments.VariableInformation;
import org.eclipse.escet.cif.codegen.javascript.JavaScriptCodeUtils;
import org.eclipse.escet.cif.codegen.javascript.JavaScriptDataValue;
import org.eclipse.escet.cif.codegen.javascript.JavaScriptExprCodeGen;
import org.eclipse.escet.cif.codegen.javascript.JavaScriptFunctionCodeGen;
import org.eclipse.escet.cif.codegen.javascript.JavaScriptSvgCodeGen;
import org.eclipse.escet.cif.codegen.javascript.JavaScriptTypeCodeGen;
import org.eclipse.escet.cif.codegen.options.HtmlFrequenciesOption;
import org.eclipse.escet.cif.codegen.options.TargetLanguage;
import org.eclipse.escet.cif.codegen.typeinfos.ArrayTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.RangeCheckErrorLevelText;
import org.eclipse.escet.cif.codegen.typeinfos.TupleTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.codegen.updates.VariableWrapper;
import org.eclipse.escet.cif.codegen.updates.tree.LhsListProjection;
import org.eclipse.escet.cif.codegen.updates.tree.LhsProjection;
import org.eclipse.escet.cif.codegen.updates.tree.LhsTupleProjection;
import org.eclipse.escet.cif.codegen.updates.tree.SingleVariableAssignment;
import org.eclipse.escet.cif.common.CifDocAnnotationUtils;
import org.eclipse.escet.cif.common.CifIntFuncUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgIn;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.print.Print;
import org.eclipse.escet.cif.metamodel.cif.print.PrintFor;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.Triple;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class JavaScriptCodeGen
extends CodeGen {
    private static final int INDENT = 4;

    public JavaScriptCodeGen(TargetLanguage language) {
        super(language, 4);
        Assert.check((language == TargetLanguage.JAVASCRIPT || language == TargetLanguage.HTML ? 1 : 0) != 0);
    }

    @Override
    protected ExprCodeGen getExpressionCodeGenerator() {
        return new JavaScriptExprCodeGen();
    }

    @Override
    protected TypeCodeGen getTypeCodeGenerator() {
        return new JavaScriptTypeCodeGen();
    }

    @Override
    protected void init() {
        super.init();
        this.replacements.put("javascript-tuples-code", "");
    }

    @Override
    protected Set<String> getReservedTargetNames() {
        return JavaScriptCodeUtils.JAVASCRIPT_IDS;
    }

    @Override
    public String getTargetRef(PositionObject obj) {
        String ref = super.getTargetRef(obj);
        if (obj instanceof AlgVariable) {
            return this.getPrefix() + "." + ref;
        }
        if (obj instanceof Constant) {
            return this.getPrefix() + "." + ref;
        }
        if (obj instanceof ContVariable) {
            return this.getPrefix() + "." + ref;
        }
        if (obj instanceof DiscVariable) {
            DiscVariable dvar = (DiscVariable)obj;
            return CifIntFuncUtils.isFuncParamOrLocalVar((DiscVariable)dvar) ? ref : this.getPrefix() + "." + ref;
        }
        if (obj instanceof EnumDecl) {
            return this.getPrefix() + "." + ref;
        }
        if (obj instanceof InputVariable) {
            return this.getPrefix() + "." + ref;
        }
        throw new AssertionError((Object)("Unexpected object: " + String.valueOf(obj)));
    }

    @Override
    protected Map<String, String> getTemplates() {
        Map templates = Maps.map();
        switch (this.language) {
            case JAVASCRIPT: {
                templates.put("utils.txt", "_utils.js");
                templates.put("class.txt", "_class.js");
                break;
            }
            case HTML: {
                templates.put("index.txt", ".html");
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected target language: " + String.valueOf((Object)this.language)));
            }
        }
        return templates;
    }

    @Override
    protected void postGenerate(CodeContext ctxt) {
        int frequencyDefault = 60;
        if (this.language == TargetLanguage.HTML) {
            Triple<Integer, Integer, Integer> configuredFrequencies = HtmlFrequenciesOption.getFrequencies();
            int frequencyMin = (Integer)configuredFrequencies.first;
            frequencyDefault = (Integer)configuredFrequencies.second;
            int frequencyMax = (Integer)configuredFrequencies.third;
            int frequencyRange = frequencyMax - frequencyMin;
            this.replacements.put("html-frequency-min", Integer.toString(frequencyMin));
            this.replacements.put("html-frequency-max", Integer.toString(frequencyMax));
            MemoryCodeBox frequencySliderMarkersCode = this.makeCodeBox(7);
            frequencySliderMarkersCode.add("<option value=\"%s\"/>", new Object[]{frequencyMin});
            if (frequencyRange >= 10) {
                frequencySliderMarkersCode.add("<option value=\"%s\"/>", new Object[]{frequencyMin + frequencyRange / 4});
            }
            if (frequencyRange > 5) {
                frequencySliderMarkersCode.add("<option value=\"%s\"/>", new Object[]{frequencyMin + frequencyRange / 2});
            }
            if (frequencyRange >= 10) {
                frequencySliderMarkersCode.add("<option value=\"%s\"/>", new Object[]{frequencyMin + frequencyRange * 3 / 4});
            }
            frequencySliderMarkersCode.add("<option value=\"%s\"/>", new Object[]{frequencyMax});
            this.replacements.put("html-frequency-markers", frequencySliderMarkersCode.toString());
        }
        this.replacements.put("js-frequency-default", Integer.toString(frequencyDefault));
        MemoryCodeBox frequencySliderCode = this.makeCodeBox(2);
        if (this.language == TargetLanguage.HTML) {
            frequencySliderCode.add("// Update frequency UI.");
            frequencySliderCode.add("var range = document.getElementById('run-frequency');");
            frequencySliderCode.add("range.value = %s.frequency;", new Object[]{ctxt.getPrefix()});
            frequencySliderCode.add("document.getElementById('run-frequency-output').value = range.value;");
        }
        this.replacements.put("javascript-frequency-slider-code", frequencySliderCode.toString());
        MemoryCodeBox logToPanelCode = this.makeCodeBox(2);
        MemoryCodeBox warningToPanelCode = this.makeCodeBox(2);
        MemoryCodeBox errorToPanelCode = this.makeCodeBox(2);
        if (this.language == TargetLanguage.HTML) {
            logToPanelCode.add("var elem = document.getElementById('log-output');");
            logToPanelCode.add("var newEntry = document.createElement('div');");
            logToPanelCode.add("newEntry.innerHTML = %sUtils.escapeHtml(message) + '\\n';", new Object[]{ctxt.getPrefix()});
            logToPanelCode.add("elem.appendChild(newEntry);");
            logToPanelCode.add("elem.scrollTop = elem.scrollHeight;");
            warningToPanelCode.add("var elem = document.getElementById('log-output');");
            warningToPanelCode.add("var newEntry = document.createElement('div');");
            warningToPanelCode.add("newEntry.innerHTML = %sUtils.escapeHtml(message) + '\\n';", new Object[]{ctxt.getPrefix()});
            warningToPanelCode.add("newEntry.classList.add('warning');");
            warningToPanelCode.add("elem.appendChild(newEntry);");
            warningToPanelCode.add("elem.scrollTop = elem.scrollHeight;");
            errorToPanelCode.add("var elem = document.getElementById('log-output');");
            errorToPanelCode.add("var newEntry = document.createElement('div');");
            errorToPanelCode.add("newEntry.innerHTML = %sUtils.escapeHtml(message) + '\\n';", new Object[]{ctxt.getPrefix()});
            errorToPanelCode.add("newEntry.classList.add('error');");
            errorToPanelCode.add("elem.appendChild(newEntry);");
            errorToPanelCode.add("elem.scrollTop = elem.scrollHeight;");
        }
        this.replacements.put("html-log-to-panel-code", logToPanelCode.toString());
        this.replacements.put("html-warning-to-panel-code", warningToPanelCode.toString());
        this.replacements.put("html-error-to-panel-code", errorToPanelCode.toString());
        MemoryCodeBox getStateTextCode = this.makeCodeBox(2);
        List stateVarsToConsider = this.language == TargetLanguage.JAVASCRIPT ? this.stateVars : Lists.concat((List)this.stateVars, (List)this.inputVars);
        List sortedStateVarsToConsider = stateVarsToConsider.stream().sorted((var1, var2) -> Strings.SORTER.compare((String)this.origDeclNames.get(var1), (String)this.origDeclNames.get(var2))).toList();
        for (Declaration stateVar : sortedStateVarsToConsider) {
            String origName = (String)this.origDeclNames.get(stateVar);
            Assert.notNull((Object)origName);
            getStateTextCode.add("state += %sUtils.fmt(', %s=%%s', %sUtils.valueToStr(%s));", new Object[]{ctxt.getPrefix(), origName, ctxt.getPrefix(), this.getTargetRef((PositionObject)stateVar)});
            if (!(stateVar instanceof ContVariable)) continue;
            getStateTextCode.add("state += %sUtils.fmt(', %s\\'=%%s', %sUtils.valueToStr(%sderiv()));", new Object[]{ctxt.getPrefix(), origName, ctxt.getPrefix(), this.getTargetRef((PositionObject)stateVar)});
        }
        this.replacements.put("javascript-get-state-text-code", getStateTextCode.toString());
        switch (this.language) {
            case JAVASCRIPT: {
                this.replacements.remove("html-svg-in-css");
                this.replacements.remove("html-svg-content");
                this.replacements.remove("html-svg-toggles");
                break;
            }
            case HTML: {
                List<String> utilsLines = this.readTemplate("utils.txt");
                List<String> classLines = this.readTemplate("class.txt");
                this.replacements.put("html-javascript-utils-placeholder", String.join((CharSequence)"\n", utilsLines));
                this.replacements.put("html-javascript-class-placeholder", String.join((CharSequence)"\n", classLines));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected target language: " + String.valueOf((Object)this.language)));
            }
        }
    }

    @Override
    protected void addConstants(CodeContext ctxt) {
        MemoryCodeBox declCode = this.makeCodeBox(1);
        MemoryCodeBox initCode = this.makeCodeBox(3);
        int i = 0;
        while (i < this.constants.size()) {
            Constant constant = (Constant)this.constants.get(i);
            String origName = (String)this.origDeclNames.get(constant);
            Assert.notNull((Object)origName);
            List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)constant);
            declCode.add();
            if (docs.isEmpty()) {
                declCode.add("/** Constant \"%s\". */", new Object[]{origName});
            } else {
                declCode.add("/**");
                declCode.add(" * Constant \"%s\".", new Object[]{origName});
                for (String doc : docs) {
                    declCode.add(" *");
                    declCode.add(" * <p>");
                    String[] stringArray = doc.split("\\r?\\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        declCode.add(" * %s", new Object[]{line});
                        ++n2;
                    }
                    declCode.add(" * </p>");
                }
                declCode.add(" */");
            }
            declCode.add("%s;", new Object[]{this.getTargetVariableName((PositionObject)constant)});
            ExprCode valueCode = ctxt.exprToTarget(constant.getValue(), null);
            Assert.check((!valueCode.hasCode() ? 1 : 0) != 0);
            initCode.add("%s = %s;", new Object[]{this.getTargetRef((PositionObject)constant), valueCode.getData()});
            ++i;
        }
        this.replacements.put("javascript-const-decls", declCode.toString());
        this.replacements.put("javascript-const-init-code", initCode.toString());
    }

    @Override
    protected void addEvents(CodeContext ctxt) {
        MemoryCodeBox code = this.makeCodeBox(2);
        int i = 0;
        while (i < this.events.size()) {
            Event event = (Event)this.events.get(i);
            String name = (String)this.origDeclNames.get(event);
            if (name == null) {
                Assert.check((boolean)this.environmentEvents.values().contains(event));
                name = event.getName();
            }
            String line = i == this.events.size() - 1 ? "%s" : "%s,";
            code.add(line, new Object[]{Strings.stringToJava((String)name)});
            ++i;
        }
        this.replacements.put("javascript-event-name-code", code.toString());
    }

    @Override
    protected void addStateVars(CodeContext ctxt) {
        String origName;
        MemoryCodeBox code = this.makeCodeBox(1);
        for (Declaration var : this.stateVars) {
            String name = this.getTargetVariableName((PositionObject)var);
            String kindCode = var instanceof DiscVariable ? "Discrete" : "Continuous";
            origName = (String)this.origDeclNames.get(var);
            Assert.notNull((Object)origName);
            List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)var);
            code.add();
            if (docs.isEmpty()) {
                code.add("/** %s variable \"%s\". */", new Object[]{kindCode, origName});
            } else {
                code.add("/**");
                code.add(" * %s variable \"%s\".", new Object[]{kindCode, origName});
                for (String doc : docs) {
                    code.add(" *");
                    code.add(" * <p>");
                    String[] stringArray = doc.split("\\r?\\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        code.add(" * %s", new Object[]{line});
                        ++n2;
                    }
                    code.add(" * </p>");
                }
                code.add(" */");
            }
            code.add("%s;", new Object[]{name});
        }
        this.replacements.put("javascript-state-decls", code.toString());
        code = this.makeCodeBox(2);
        for (Declaration var : this.stateVars) {
            Expression value;
            String ref = this.getTargetRef((PositionObject)var);
            if (var instanceof DiscVariable) {
                v = (DiscVariable)var;
                Assert.check((v.getValue() != null ? 1 : 0) != 0);
                Assert.check((v.getValue().getValues().size() == 1 ? 1 : 0) != 0);
                value = (Expression)Lists.first((List)v.getValue().getValues());
            } else {
                Assert.check((boolean)(var instanceof ContVariable));
                v = (ContVariable)var;
                value = v.getValue();
            }
            origName = (String)this.origDeclNames.get(var);
            Assert.notNull((Object)origName);
            code.add("try {");
            code.indent();
            ExprCode valueCode = ctxt.exprToTarget(value, null);
            code.add((Box)valueCode.getCode());
            code.add("%s = %s;", new Object[]{ref, valueCode.getData()});
            code.dedent();
            code.add("} catch (e) {");
            code.indent();
            code.add("if (e instanceof %sException) {", new Object[]{ctxt.getPrefix()});
            code.indent();
            code.add("e = new %sException(\"Failed to evaluate the initial value of variable \\\"%s\\\".\", e);", new Object[]{ctxt.getPrefix(), origName});
            code.add("this.runtimeError(e);");
            code.dedent();
            code.add("}");
            code.add("throw e;");
            code.dedent();
            code.add("}");
        }
        if (this.stateVars.isEmpty()) {
            code.add("// No state variables, except variable 'time'.");
        }
        this.replacements.put("javascript-state-init", code.toString());
    }

    @Override
    protected void addContVars(CodeContext ctxt) {
        ContVariable var;
        String origName;
        MemoryCodeBox code = this.makeCodeBox(1);
        for (ContVariable var2 : this.contVars) {
            String name = this.getTargetVariableName((PositionObject)var2);
            origName = (String)this.origDeclNames.get(var2);
            Assert.notNull((Object)origName);
            code.add();
            code.add("/**");
            code.add(" * Evaluates derivative of continuous variable \"%s\".", new Object[]{origName});
            code.add(" *");
            code.add(" * @return The evaluation result.");
            code.add(" * @throws {%sException} In case of a runtime error caused by code", new Object[]{ctxt.getPrefix()});
            code.add("*       generated from the CIF model.");
            code.add(" */");
            code.add("%sderiv() {", new Object[]{name});
            code.indent();
            code.add("try {");
            code.indent();
            Expression deriv = var2.getDerivative();
            Assert.notNull((Object)deriv);
            ExprCode derivCode = ctxt.exprToTarget(deriv, null);
            code.add((Box)derivCode.getCode());
            code.add("return %s;", new Object[]{derivCode.getData()});
            code.dedent();
            code.add("} catch (e) {");
            code.indent();
            code.add("if (e instanceof %sException) {", new Object[]{ctxt.getPrefix()});
            code.indent();
            code.add("e = new %sException(\"Failed to evaluate the derivative of continuous variable \\\"%s\\\".\", e);", new Object[]{ctxt.getPrefix(), origName});
            code.dedent();
            code.add("}");
            code.add("throw e;");
            code.dedent();
            code.add("}");
            code.dedent();
            code.add("}");
        }
        this.replacements.put("javascript-deriv-code", code.toString());
        code = this.makeCodeBox(6);
        if (!this.contVars.isEmpty()) {
            code.add("try {");
            code.indent();
        }
        int i = 0;
        while (i < this.contVars.size()) {
            var = (ContVariable)this.contVars.get(i);
            String origName2 = (String)this.origDeclNames.get(var);
            Assert.notNull((Object)origName2);
            code.add("var deriv%d = %sderiv();", new Object[]{i, this.getTargetRef((PositionObject)var)});
            ++i;
        }
        if (!this.contVars.isEmpty()) {
            code.add();
        }
        i = 0;
        while (i < this.contVars.size()) {
            var = (ContVariable)this.contVars.get(i);
            String ref = this.getTargetRef((PositionObject)var);
            code.add("%s = %s + delta * deriv%d;", new Object[]{ref, ref, i});
            origName = (String)this.origDeclNames.get(var);
            Assert.notNull((Object)origName);
            code.add("%sUtils.checkReal(%s, %s);", new Object[]{ctxt.getPrefix(), ref, Strings.stringToJava((String)origName)});
            code.add("if (%s == -0.0) %s = 0.0;", new Object[]{ref, ref});
            ++i;
        }
        if (this.contVars.isEmpty()) {
            code.add("// No continuous variables, except variable 'time'.");
        } else {
            code.dedent();
            code.add("} catch (e) {");
            code.indent();
            code.add("if (e instanceof %sException) {", new Object[]{ctxt.getPrefix()});
            code.indent();
            code.add("e = new %sException(\"Failed to update continuous variables after time passage.\", e);", new Object[]{ctxt.getPrefix()});
            code.add("this.runtimeError(e);");
            code.dedent();
            code.add("}");
            code.add("throw e;");
            code.dedent();
            code.add("}");
        }
        this.replacements.put("javascript-cont-upd-code", code.toString());
    }

    @Override
    protected void addAlgVars(CodeContext ctxt) {
        MemoryCodeBox code = this.makeCodeBox(1);
        for (AlgVariable var : this.algVars) {
            String name = this.getTargetVariableName((PositionObject)var);
            String origName = (String)this.origDeclNames.get(var);
            Assert.notNull((Object)origName);
            List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)var);
            code.add();
            code.add("/**");
            code.add(" * Evaluates algebraic variable \"%s\".", new Object[]{origName});
            for (String doc : docs) {
                code.add(" *");
                code.add(" * <p>");
                String[] stringArray = doc.split("\\r?\\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    code.add(" * %s", new Object[]{line});
                    ++n2;
                }
                code.add(" * </p>");
            }
            code.add(" *");
            code.add(" * @return The evaluation result.");
            code.add(" * @throws {%sException} In case of a runtime error caused by code", new Object[]{ctxt.getPrefix()});
            code.add("*       generated from the CIF model.");
            code.add(" */");
            code.add("%s() {", new Object[]{name});
            code.indent();
            code.add("try {");
            code.indent();
            Expression value = var.getValue();
            Assert.notNull((Object)value);
            ExprCode valueCode = ctxt.exprToTarget(value, null);
            code.add((Box)valueCode.getCode());
            code.add("return %s;", new Object[]{valueCode.getData()});
            code.dedent();
            code.add("} catch (e) {");
            code.indent();
            code.add("if (e instanceof %sException) {", new Object[]{ctxt.getPrefix()});
            code.indent();
            code.add("e = new %sException(\"Failed to evaluate algebraic variable \\\"%s\\\".\", e);", new Object[]{ctxt.getPrefix(), origName});
            code.dedent();
            code.add("}");
            code.add("throw e;");
            code.dedent();
            code.add("}");
            code.dedent();
            code.add("}");
        }
        this.replacements.put("javascript-alg-var-code", code.toString());
    }

    @Override
    protected void addInputVars(CodeContext ctxt) {
        MemoryCodeBox code = this.makeCodeBox(1);
        for (InputVariable var : this.inputVars) {
            String name = this.getTargetVariableName((PositionObject)var);
            List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)var);
            String origName = (String)this.origDeclNames.get(var);
            Assert.notNull((Object)origName);
            code.add();
            if (docs.isEmpty()) {
                code.add("/** Input variable \"%s\". */", new Object[]{origName});
            } else {
                code.add("/**");
                code.add(" * Input variable \"%s\".", new Object[]{origName});
                for (String doc : docs) {
                    code.add(" *");
                    code.add(" * <p>");
                    String[] stringArray = doc.split("\\r?\\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        code.add(" * %s", new Object[]{line});
                        ++n2;
                    }
                    code.add(" * </p>");
                }
                code.add(" */");
            }
            code.add("%s;", new Object[]{name});
        }
        this.replacements.put("javascript-state-input", code.toString());
        code = this.makeCodeBox(2);
        if (this.language == TargetLanguage.HTML) {
            code.add("// CIF model input variables.");
            List defaultValueFuncs = Lists.listc((int)0);
            for (InputVariable inputVar : this.inputVars) {
                String ref = this.getTargetRef((PositionObject)inputVar);
                Expression value = CifValueUtils.getDefaultValue((CifType)inputVar.getType(), (List)defaultValueFuncs);
                ExprCode valueCode = ctxt.exprToTarget(value, null);
                code.add((Box)valueCode.getCode());
                code.add("%s = %s;", new Object[]{ref, valueCode.getData()});
            }
            Assert.check((boolean)defaultValueFuncs.isEmpty());
            if (this.inputVars.isEmpty()) {
                code.add("// No input variables.");
            }
            code.add();
        }
        this.replacements.put("javascript-input-init", code.toString());
    }

    @Override
    protected void addFunctions(CodeContext ctxt) {
        MemoryCodeBox code = this.makeCodeBox(1);
        for (InternalFunction func : this.functions) {
            JavaScriptFunctionCodeGen funcGen = new JavaScriptFunctionCodeGen(func);
            funcGen.generate((CodeBox)code, ctxt);
        }
        this.replacements.put("javascript-funcs-code", code.toString());
    }

    @Override
    protected void addEnum(EnumDecl enumDecl, CodeContext ctxt) {
        MemoryCodeBox code = this.makeCodeBox(2);
        EList lits = enumDecl.getLiterals();
        int i = 0;
        while (i < lits.size()) {
            if (i > 0) {
                code.add();
            }
            EnumLiteral lit = (EnumLiteral)lits.get(i);
            List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)lit);
            String name = lit.getName();
            if (docs.isEmpty()) {
                code.add("/** Literal \"%s\". */", new Object[]{name});
            } else {
                code.add("/**");
                code.add(" * Literal \"%s\".", new Object[]{name});
                for (String doc : docs) {
                    code.add(" *");
                    code.add(" * <p>");
                    String[] stringArray = doc.split("\\r?\\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        code.add(" * %s", new Object[]{line});
                        ++n2;
                    }
                    code.add(" * </p>");
                }
                code.add(" */");
            }
            Object line = Strings.fmt((String)"_%s: Symbol(\"%s\")", (Object[])new Object[]{name, name});
            line = (String)line + (i == lits.size() - 1 ? "" : ",");
            code.add((String)line);
            ++i;
        }
        this.replacements.put("javascript-enum-lits-code", code.toString());
    }

    @Override
    protected void addPrints(CodeContext ctxt) {
        MemoryCodeBox code = this.makeCodeBox(2);
        for (Print print : this.printDecls) {
            boolean[] preAndPost;
            EList printFors = print.getFors();
            List printConds = Lists.list();
            if (printFors.isEmpty()) {
                printConds.add("(true)");
            } else {
                for (PrintFor printFor : printFors) {
                    switch (printFor.getKind()) {
                        case EVENT: {
                            printConds.add("(idx >= 0)");
                            break;
                        }
                        case FINAL: {
                            break;
                        }
                        case INITIAL: {
                            printConds.add("(idx == -3)");
                            break;
                        }
                        case NAME: {
                            Expression eventRef = printFor.getEvent();
                            Assert.check((boolean)(eventRef instanceof EventExpression));
                            Event event = ((EventExpression)eventRef).getEvent();
                            int idx = (Integer)this.eventMap.get(event);
                            printConds.add(Strings.fmt((String)"(idx == %d)", (Object[])new Object[]{idx}));
                            break;
                        }
                        case TIME: {
                            printConds.add("(idx == -2)");
                        }
                    }
                }
            }
            Object printCond = printConds.isEmpty() ? "(false)" : (printConds.size() == 1 ? (String)Lists.first((List)printConds) : "(" + String.join((CharSequence)" || ", printConds) + ")");
            code.add("if %s {", new Object[]{printCond});
            code.indent();
            boolean[] blArray = new boolean[2];
            blArray[0] = true;
            boolean[] blArray2 = preAndPost = blArray;
            int n = preAndPost.length;
            int n2 = 0;
            while (n2 < n) {
                Expression txtExpr;
                boolean pre = blArray2[n2];
                Expression whenPred = pre ? print.getWhenPre() : print.getWhenPost();
                Expression expression = txtExpr = pre ? print.getTxtPre() : print.getTxtPost();
                if (txtExpr != null) {
                    code.add("if (%spre) {", new Object[]{pre ? "" : "!"});
                    code.indent();
                    if (whenPred != null) {
                        ExprCode whenCode = ctxt.exprToTarget(whenPred, null);
                        code.add("var whenCond;");
                        code.add("try {");
                        code.indent();
                        code.add((Box)whenCode.getCode());
                        code.add("whenCond = %s;", new Object[]{whenCode.getData()});
                        code.dedent();
                        code.add("} catch (e) {");
                        code.indent();
                        code.add("if (e instanceof %sException) {", new Object[]{ctxt.getPrefix()});
                        code.indent();
                        code.add("e = new %sException(\"Failed to evaluate print declaration \\\"when %s\\\" filter.\", e);", new Object[]{ctxt.getPrefix(), pre ? "pre" : "post"});
                        code.add("this.runtimeError(e);");
                        code.dedent();
                        code.add("}");
                        code.add("throw e;");
                        code.dedent();
                        code.add("}");
                        code.add("if (whenCond) {");
                        code.indent();
                    }
                    code.add("var text;");
                    code.add("try {");
                    code.indent();
                    ExprCode txtCode = ctxt.exprToTarget(txtExpr, null);
                    code.add((Box)txtCode.getCode());
                    CifType valueType = txtExpr.getType();
                    if (valueType instanceof StringType) {
                        code.add("text = %s;", new Object[]{txtCode.getData()});
                    } else {
                        code.add("var value = %s;", new Object[]{txtCode.getData()});
                        code.add("text = %sUtils.valueToStr(value);", new Object[]{ctxt.getPrefix()});
                    }
                    code.dedent();
                    code.add("} catch (e) {");
                    code.indent();
                    code.add("if (e instanceof %sException) {", new Object[]{ctxt.getPrefix()});
                    code.indent();
                    code.add("e = new %sException(\"Failed to evaluate print declaration \\\"%s\\\" text.\", e);", new Object[]{ctxt.getPrefix(), pre ? "pre" : "post"});
                    code.add("this.runtimeError(e);");
                    code.dedent();
                    code.add("}");
                    code.add("throw e;");
                    code.dedent();
                    code.add("}");
                    String target = print.getFile().getPath();
                    target = Strings.stringToJava((String)target);
                    code.add("this.infoPrintOutput(text, %s);", new Object[]{target});
                    if (whenPred != null) {
                        code.dedent();
                        code.add("}");
                    }
                    code.dedent();
                    code.add("}");
                }
                ++n2;
            }
            code.dedent();
            code.add("}");
        }
        if (this.printDecls.isEmpty()) {
            code.add("// No print declarations.");
        }
        this.replacements.put("javascript-print-code", code.toString());
    }

    @Override
    protected void addSvgDecls(CodeContext ctxt, String cifSpecFileDir) {
        JavaScriptSvgCodeGen svgCodeGen = new JavaScriptSvgCodeGen();
        svgCodeGen.codeSvgContent = this.makeCodeBox(5);
        svgCodeGen.codeSvgToggles = this.makeCodeBox(2);
        svgCodeGen.codeCopyApply = this.makeCodeBox(2);
        svgCodeGen.codeMoveApply = this.makeCodeBox(2);
        svgCodeGen.codeInClickHandlers = this.makeCodeBox(1);
        svgCodeGen.codeInEventSetters = this.makeCodeBox(1);
        svgCodeGen.codeInSetup = this.makeCodeBox(2);
        svgCodeGen.codeInCss = this.makeCodeBox(3);
        svgCodeGen.codeOutDeclarations = this.makeCodeBox(1);
        svgCodeGen.codeOutAssignments = this.makeCodeBox(2);
        svgCodeGen.codeOutApply = this.makeCodeBox(2);
        svgCodeGen.genCodeCifSvg(ctxt, cifSpecFileDir, this.svgDecls, this.eventMap, this.environmentEvents);
        this.replacements.put("html-svg-content", svgCodeGen.codeSvgContent.toString());
        this.replacements.put("html-svg-toggles", svgCodeGen.codeSvgToggles.toString());
        this.replacements.put("html-svg-copy-apply-code", svgCodeGen.codeCopyApply.toString());
        this.replacements.put("html-svg-move-apply-code", svgCodeGen.codeMoveApply.toString());
        this.replacements.put("javascript-svg-in-click-handlers-code", svgCodeGen.codeInClickHandlers.toString());
        this.replacements.put("javascript-svg-in-event-setters-code", svgCodeGen.codeInEventSetters.toString());
        this.replacements.put("javascript-svg-in-setup-code", svgCodeGen.codeInSetup.toString());
        this.replacements.put("html-svg-in-css", svgCodeGen.codeInCss.toString());
        this.replacements.put("javascript-svg-out-declarations", svgCodeGen.codeOutDeclarations.toString());
        this.replacements.put("javascript-svg-out-assignments-code", svgCodeGen.codeOutAssignments.toString());
        this.replacements.put("javascript-svg-out-apply-code", svgCodeGen.codeOutApply.toString());
    }

    @Override
    protected void addEdges(CodeContext ctxt, String cifSpecFileDir) {
        Assert.implies((this.language == TargetLanguage.JAVASCRIPT ? 1 : 0) != 0, (boolean)this.svgInEdges.isEmpty());
        Assert.implies((this.language == TargetLanguage.JAVASCRIPT ? 1 : 0) != 0, (boolean)this.environmentEvents.isEmpty());
        MemoryCodeBox codeCallsSvgInUpdates = this.makeCodeBox(3);
        MemoryCodeBox codeCallsSvgInEvents = this.makeCodeBox(3);
        MemoryCodeBox codeCallsUncontrollables = this.makeCodeBox(3);
        MemoryCodeBox codeCallsControllables = this.makeCodeBox(3);
        MemoryCodeBox codeMethods = this.makeCodeBox(1);
        this.addEnvEventExecCode((CodeBox)codeCallsSvgInUpdates, (CodeBox)codeMethods, ctxt, cifSpecFileDir);
        int edgeIdx = 0;
        edgeIdx = this.addEdges(this.svgInEdges, edgeIdx, (CodeBox)codeCallsSvgInEvents, (CodeBox)codeMethods, true, ctxt);
        edgeIdx = this.addEdges(this.uncontrollableEdges, edgeIdx, (CodeBox)codeCallsUncontrollables, (CodeBox)codeMethods, false, ctxt);
        edgeIdx = this.addEdges(this.controllableEdges, edgeIdx, (CodeBox)codeCallsControllables, (CodeBox)codeMethods, false, ctxt);
        this.replacements.put("javascript-edge-calls-code-svgin-updates", codeCallsSvgInUpdates.toString());
        this.replacements.put("javascript-edge-calls-code-svgin-events", codeCallsSvgInEvents.toString());
        this.replacements.put("javascript-edge-calls-code-uncontrollables", codeCallsUncontrollables.toString());
        this.replacements.put("javascript-edge-calls-code-controllables", codeCallsControllables.toString());
        this.replacements.put("javascript-edge-methods-code", codeMethods.toString());
    }

    private void addEnvEventExecCode(CodeBox codeCalls, CodeBox codeMethods, CodeContext ctxt, String cifSpecFileDir) {
        Assert.implies((this.language == TargetLanguage.JAVASCRIPT ? 1 : 0) != 0, (boolean)this.environmentEvents.isEmpty());
        int environmentEventIdx = -1;
        for (Map.Entry entry : this.environmentEvents.entrySet()) {
            ++environmentEventIdx;
            SvgIn svgIn = (SvgIn)entry.getKey();
            String svgInId = SvgCodeGen.evalSvgStringExpr(svgIn.getId());
            String svgFileRelPath = svgIn.getSvgFile().getPath();
            String svgFileAbsPath = Paths.resolve((String)svgFileRelPath, (String)cifSpecFileDir);
            String svgFileNormRelPath = Paths.getRelativePath((String)svgFileAbsPath, (String)cifSpecFileDir);
            Event event = (Event)entry.getValue();
            String eventName = event.getName();
            int eventIdx = (Integer)this.eventMap.get(event);
            Assert.check((eventIdx >= 0 ? 1 : 0) != 0);
            codeCalls.add();
            codeCalls.add("// Environment event: %s.", new Object[]{eventName});
            codeCalls.add("anythingExecuted |= this.execEnvironmentEvent%d();", new Object[]{environmentEventIdx});
            codeMethods.add();
            codeMethods.add("/**");
            codeMethods.add(" * Execute code for an SVG input mapping with id \"%s\",", new Object[]{svgInId});
            codeMethods.add(" * for SVG image \"%s\",", new Object[]{svgFileNormRelPath});
            codeMethods.add(" * for the environment event with index %d,", new Object[]{environmentEventIdx});
            codeMethods.add(" * which is the event with index %d: %s.", new Object[]{eventIdx, eventName});
            codeMethods.add(" *");
            codeMethods.add(" * @return 'true' if the SVG input mapping was executed, 'false' otherwise.");
            codeMethods.add(" * @throws {%sException} In case of a runtime error caused by code", new Object[]{ctxt.getPrefix()});
            codeMethods.add("*       generated from the CIF model.");
            codeMethods.add(" */");
            codeMethods.add("execEnvironmentEvent%d() {", new Object[]{environmentEventIdx});
            codeMethods.indent();
            codeMethods.add("try {");
            codeMethods.indent();
            codeMethods.add("if (%s.svgInEvent != %d) return false;", new Object[]{ctxt.getPrefix(), eventIdx});
            codeMethods.add();
            codeMethods.add("%s.svgInId = null;", new Object[]{ctxt.getPrefix()});
            codeMethods.add("%s.svgInEvent = -1;", new Object[]{ctxt.getPrefix()});
            codeMethods.add();
            codeMethods.add("if (this.doInfoPrintOutput) this.printOutput(%d, true);", new Object[]{eventIdx});
            codeMethods.add("if (this.doInfoEvent) this.infoEvent(%d, true);", new Object[]{eventIdx});
            Assert.check((!svgIn.getUpdates().isEmpty() ? 1 : 0) != 0);
            codeMethods.add();
            codeMethods.add("try {");
            codeMethods.indent();
            this.addUpdates((List<Update>)svgIn.getUpdates(), codeMethods, ctxt);
            codeMethods.dedent();
            codeMethods.add("} catch (e) {");
            codeMethods.indent();
            codeMethods.add("if (e instanceof %sException) {", new Object[]{ctxt.getPrefix()});
            codeMethods.indent();
            codeMethods.add("e = new %sException(\"Failed to execute update(s).\", e);", new Object[]{ctxt.getPrefix()});
            codeMethods.dedent();
            codeMethods.add("}");
            codeMethods.add("throw e;");
            codeMethods.dedent();
            codeMethods.add("}");
            codeMethods.add();
            codeMethods.add("if (this.doInfoEvent) this.infoEvent(%d, false);", new Object[]{eventIdx});
            codeMethods.add("if (this.doInfoPrintOutput) this.printOutput(%d, false);", new Object[]{eventIdx});
            codeMethods.add("if (this.doStateOutput || this.doTransitionOutput) this.log('');");
            codeMethods.add("return true;");
            codeMethods.dedent();
            codeMethods.add("} catch (e) {");
            codeMethods.indent();
            codeMethods.add("if (e instanceof %sException) {", new Object[]{ctxt.getPrefix()});
            codeMethods.indent();
            codeMethods.add("e = new %sException(\"Failed to (try to) execute environment event %s.\", e);", new Object[]{ctxt.getPrefix(), Strings.escape((String)eventName)});
            codeMethods.add("this.runtimeError(e);");
            codeMethods.dedent();
            codeMethods.add("}");
            codeMethods.add("throw e;");
            codeMethods.dedent();
            codeMethods.add("}");
            codeMethods.dedent();
            codeMethods.add("}");
        }
    }

    private int addEdges(List<Edge> edges, int edgeIdx, CodeBox codeCalls, CodeBox codeMethods, boolean areSvgInEdges, CodeContext ctxt) {
        int i = 0;
        while (i < edges.size()) {
            Expression guard;
            Edge edge = edges.get(i);
            Assert.check((edge.getEvents().size() == 1 ? 1 : 0) != 0);
            Expression eventRef = ((EdgeEvent)Lists.first((List)edge.getEvents())).getEvent();
            Event event = ((EventExpression)eventRef).getEvent();
            int eventIdx = (Integer)this.eventMap.get(event);
            String eventName = (String)this.origDeclNames.get(event);
            Assert.notNull((Object)eventName);
            codeCalls.add();
            codeCalls.add("// Event \"%s\".", new Object[]{eventName});
            codeCalls.add("anythingExecuted |= this.execEdge%d();", new Object[]{edgeIdx});
            List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)event);
            codeMethods.add();
            codeMethods.add("/**");
            codeMethods.add(" * Execute code for edge with index %d and event \"%s\".", new Object[]{edgeIdx, eventName});
            for (String doc : docs) {
                codeMethods.add(" *");
                codeMethods.add(" * <p>");
                String[] stringArray = doc.split("\\r?\\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    codeMethods.add(" * %s", new Object[]{line});
                    ++n2;
                }
                codeMethods.add(" * </p>");
            }
            codeMethods.add(" *");
            codeMethods.add(" * @return 'true' if the edge was executed, 'false' otherwise.");
            codeMethods.add(" * @throws {%sException} In case of a runtime error caused by code", new Object[]{ctxt.getPrefix()});
            codeMethods.add("*       generated from the CIF model.");
            codeMethods.add(" */");
            codeMethods.add("execEdge%d() {", new Object[]{edgeIdx});
            codeMethods.indent();
            codeMethods.add("try {");
            codeMethods.indent();
            EList guards = edge.getGuards();
            Assert.check((guards.size() <= 1 ? 1 : 0) != 0);
            Expression expression = guard = guards.isEmpty() ? null : (Expression)Lists.first((List)guards);
            if (guard != null) {
                ExprCode guardCode = ctxt.exprToTarget(guard, null);
                codeMethods.add("var guard;");
                codeMethods.add("try {");
                codeMethods.indent();
                codeMethods.add((Box)guardCode.getCode());
                codeMethods.add("guard = %s;", new Object[]{guardCode.getData()});
                codeMethods.dedent();
                codeMethods.add("} catch (e) {");
                codeMethods.indent();
                codeMethods.add("if (e instanceof %sException) {", new Object[]{ctxt.getPrefix()});
                codeMethods.indent();
                codeMethods.add("e = new %sException(\"Failed to evaluate guard.\", e);", new Object[]{ctxt.getPrefix()});
                codeMethods.dedent();
                codeMethods.add("}");
                codeMethods.add("throw e;");
                codeMethods.dedent();
                codeMethods.add("}");
                codeMethods.add();
                codeMethods.add("if (!guard) {");
                codeMethods.indent();
                if (areSvgInEdges) {
                    codeMethods.add("if (%s.svgInEvent == %d) {", new Object[]{ctxt.getPrefix(), eventIdx});
                    codeMethods.indent();
                    codeMethods.add("%s.warning(%sUtils.fmt('An SVG element with id \"%%s\" was clicked, but the corresponding event \"%s\" is not enabled in the current state.', %s.svgInId));", new Object[]{ctxt.getPrefix(), ctxt.getPrefix(), eventName, ctxt.getPrefix()});
                    codeMethods.add("%s.svgInId = null;", new Object[]{ctxt.getPrefix()});
                    codeMethods.add("%s.svgInEvent = -1;", new Object[]{ctxt.getPrefix()});
                    codeMethods.dedent();
                    codeMethods.add("}");
                }
                codeMethods.add("return false;");
                codeMethods.dedent();
                codeMethods.add("}");
            }
            if (areSvgInEdges) {
                codeMethods.add();
                codeMethods.add("if (%s.svgInEvent != %d) return false;", new Object[]{ctxt.getPrefix(), eventIdx});
                codeMethods.add();
                codeMethods.add("%s.svgInId = null;", new Object[]{ctxt.getPrefix()});
                codeMethods.add("%s.svgInEvent = -1;", new Object[]{ctxt.getPrefix()});
            }
            codeMethods.add();
            codeMethods.add("if (this.doInfoPrintOutput) this.printOutput(%d, true);", new Object[]{eventIdx});
            codeMethods.add("if (this.doInfoEvent) this.infoEvent(%d, true);", new Object[]{eventIdx});
            if (!edge.getUpdates().isEmpty()) {
                codeMethods.add();
                codeMethods.add("try {");
                codeMethods.indent();
                this.addUpdates((List<Update>)edge.getUpdates(), codeMethods, ctxt);
                codeMethods.dedent();
                codeMethods.add("} catch (e) {");
                codeMethods.indent();
                codeMethods.add("if (e instanceof %sException) {", new Object[]{ctxt.getPrefix()});
                codeMethods.indent();
                codeMethods.add("e = new %sException(\"Failed to execute update(s).\", e);", new Object[]{ctxt.getPrefix()});
                codeMethods.dedent();
                codeMethods.add("}");
                codeMethods.add("throw e;");
                codeMethods.dedent();
                codeMethods.add("}");
            }
            codeMethods.add();
            codeMethods.add("if (this.doInfoEvent) this.infoEvent(%d, false);", new Object[]{eventIdx});
            codeMethods.add("if (this.doInfoPrintOutput) this.printOutput(%d, false);", new Object[]{eventIdx});
            codeMethods.add("if (this.doStateOutput || this.doTransitionOutput) this.log('');");
            codeMethods.add("return true;");
            codeMethods.dedent();
            codeMethods.add("} catch (e) {");
            codeMethods.indent();
            codeMethods.add("if (e instanceof %sException) {", new Object[]{ctxt.getPrefix()});
            codeMethods.indent();
            codeMethods.add("e = new %sException(\"Failed to (try to) execute event \\\"%s\\\".\", e);", new Object[]{ctxt.getPrefix(), eventName});
            codeMethods.add("this.runtimeError(e);");
            codeMethods.dedent();
            codeMethods.add("}");
            codeMethods.add("throw e;");
            codeMethods.dedent();
            codeMethods.add("}");
            codeMethods.dedent();
            codeMethods.add("}");
            ++i;
            ++edgeIdx;
        }
        return edgeIdx;
    }

    @Override
    protected IfElseGenerator getIfElseUpdateGenerator() {
        return new CurlyBraceIfElseGenerator();
    }

    @Override
    public void performSingleAssign(CodeBox code, SingleVariableAssignment asgn, Expression value, CodeContext readCtxt, CodeContext writeCtxt) {
        Assert.check((asgn.rhsProjections == null ? 1 : 0) != 0);
        Assert.check((asgn.lhsProjections == null ? 1 : 0) != 0);
        Assert.check((!asgn.needsRangeBoundCheck() ? 1 : 0) != 0);
        VariableInformation varInfo = writeCtxt.getWriteVarInfo(asgn.variable);
        ExprCode assignment = readCtxt.exprToTarget(value, writeCtxt.makeDestination(varInfo));
        code.add((Box)assignment.getCode());
        Assert.check((!assignment.hasDataValue() ? 1 : 0) != 0);
    }

    @Override
    public void performAssign(CodeBox code, SingleVariableAssignment asgn, String rhsText, CodeContext readCtxt, CodeContext writeCtxt) {
        ArrayTypeInfo arrayTi;
        LhsTupleProjection tupleLhs;
        TupleTypeInfo tupleTi;
        LhsProjection lhsProj;
        VariableInformation fullVarInfo = writeCtxt.getWriteVarInfo(asgn.variable);
        JavaScriptDataValue rhsValue = new JavaScriptDataValue(rhsText);
        if (asgn.lhsProjections == null) {
            CifType assignedType = asgn.getAssignedType();
            TypeInfo rangeCheckInfo = readCtxt.typeToTarget(assignedType);
            rangeCheckInfo.checkRange(assignedType, asgn.valueType, rhsValue, asgn.variableType, fullVarInfo.name, Lists.list(), 0, code, readCtxt);
            fullVarInfo.typeInfo.storeValue(code, rhsValue, writeCtxt.makeDestination(fullVarInfo));
            return;
        }
        String[] indexTexts = new String[asgn.lhsProjections.length];
        List rangeErrorTexts = Lists.list();
        int i = 0;
        while (i < asgn.lhsProjections.length) {
            LhsProjection lhsProj2 = asgn.lhsProjections[i];
            if (lhsProj2 instanceof LhsTupleProjection) {
                LhsTupleProjection tupleProj = (LhsTupleProjection)lhsProj2;
                indexTexts[i] = Integer.toString(tupleProj.fieldNumber);
                rangeErrorTexts.add(new RangeCheckErrorLevelText(false, tupleProj.getSelectedFieldName()));
            } else {
                LhsListProjection listProj = (LhsListProjection)lhsProj2;
                VariableInformation indexVarInfo = writeCtxt.makeTempVariable((CifType)CifConstructors.newIntType(), "index");
                indexTexts[i] = indexVarInfo.targetRef;
                rangeErrorTexts.add(new RangeCheckErrorLevelText(true, indexVarInfo.targetVariableName));
                ExprCode indexCode = readCtxt.exprToTarget(listProj.index, null);
                indexVarInfo.typeInfo.declareInit(code, indexCode.getRawDataValue(), writeCtxt.makeDestination(indexVarInfo));
            }
            ++i;
        }
        CifType assignedType = asgn.getAssignedType();
        TypeInfo rangeCheckInfo = readCtxt.typeToTarget(assignedType);
        rangeCheckInfo.checkRange(assignedType, asgn.valueType, rhsValue, asgn.variableType, fullVarInfo.name, rangeErrorTexts, 0, code, readCtxt);
        int last = asgn.lhsProjections.length - 1;
        VariableInformation[] partVariables = new VariableInformation[last];
        int i2 = 0;
        while (i2 < last) {
            ExprCode projectRhs;
            lhsProj = asgn.lhsProjections[i2];
            CifType elementType = lhsProj.getPartType();
            partVariables[i2] = readCtxt.makeTempVariable(elementType, "part");
            VariableInformation containerInfo = i2 == 0 ? readCtxt.getReadVarInfo(new VariableWrapper(asgn.variable, false)) : partVariables[i2 - 1];
            ExprCode containerValue = new ExprCode();
            containerValue.setDataValue(new JavaScriptDataValue(containerInfo.targetRef));
            if (containerInfo.typeInfo instanceof TupleTypeInfo) {
                tupleTi = (TupleTypeInfo)containerInfo.typeInfo;
                tupleLhs = (LhsTupleProjection)lhsProj;
                projectRhs = tupleTi.getProjectedValue(containerValue, tupleLhs.fieldNumber, null, readCtxt);
            } else {
                Assert.check((boolean)(containerInfo.typeInfo instanceof ArrayTypeInfo));
                arrayTi = (ArrayTypeInfo)containerInfo.typeInfo;
                ExprCode indexVar = new ExprCode();
                indexVar.setDataValue(new JavaScriptDataValue(indexTexts[i2]));
                projectRhs = arrayTi.getProjectedValue(containerValue, indexVar, null, readCtxt);
            }
            code.add((Box)projectRhs.getCode());
            partVariables[i2].typeInfo.declareInit(code, projectRhs.getRawDataValue(), readCtxt.makeDestination(partVariables[i2]));
            ++i2;
        }
        i2 = last;
        while (i2 >= 0) {
            MemoryCodeBox modify;
            lhsProj = asgn.lhsProjections[i2];
            VariableInformation containerInfo = i2 == 0 ? writeCtxt.getReadVarInfo(new VariableWrapper(asgn.variable, false)) : partVariables[i2 - 1];
            ExprCode containerCode = new ExprCode();
            containerCode.setDataValue(new JavaScriptDataValue(containerInfo.targetRef));
            ExprCode partCode = new ExprCode();
            if (i2 == last) {
                partCode.setDataValue(rhsValue);
            } else {
                partCode.setDataValue(new JavaScriptDataValue(partVariables[i2].targetRef));
            }
            if (containerInfo.typeInfo instanceof TupleTypeInfo) {
                tupleTi = (TupleTypeInfo)containerInfo.typeInfo;
                tupleLhs = (LhsTupleProjection)lhsProj;
                modify = readCtxt.makeCodeBox();
                modify.add("%s = %s.copy();", new Object[]{containerInfo.targetRef, containerInfo.targetRef});
                modify.add((Box)tupleTi.modifyContainer(containerInfo, partCode, tupleLhs.fieldNumber, readCtxt));
            } else {
                Assert.check((boolean)(containerInfo.typeInfo instanceof ArrayTypeInfo));
                arrayTi = (ArrayTypeInfo)containerInfo.typeInfo;
                ExprCode indexCode = new ExprCode();
                indexCode.setDataValue(new JavaScriptDataValue(indexTexts[i2]));
                modify = arrayTi.modifyContainer(containerInfo, partCode, indexCode, readCtxt);
            }
            code.add((Box)modify);
            --i2;
        }
    }

    @Override
    protected void addUpdatesBeginScope(CodeBox code) {
        code.add("{");
        code.indent();
    }

    @Override
    protected void addUpdatesEndScope(CodeBox code) {
        code.dedent();
        code.add("}");
    }

    @Override
    protected void addSpec(CodeContext ctxt) {
        List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)this.spec);
        MemoryCodeBox classJavaDoc = this.makeCodeBox(0);
        if (docs.isEmpty()) {
            classJavaDoc.add("/** ${prefix} code generated from a CIF specification. */");
        } else {
            classJavaDoc.add("/**");
            classJavaDoc.add(" * ${prefix} code generated from a CIF specification.");
            for (String doc : docs) {
                classJavaDoc.add(" *");
                classJavaDoc.add(" * <p>");
                String[] stringArray = doc.split("\\r?\\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    classJavaDoc.add(" * %s", new Object[]{line});
                    ++n2;
                }
                classJavaDoc.add(" * </p>");
            }
            classJavaDoc.add(" */");
        }
        this.replacements.put("javascript-class-jsdoc", classJavaDoc.toString());
    }

    @Override
    public Destination makeDestination(VariableInformation varInfo) {
        JavaScriptDataValue dataValue = new JavaScriptDataValue(varInfo.targetRef);
        return new Destination(null, varInfo.typeInfo, dataValue);
    }

    @Override
    public DataValue makeDataValue(String value) {
        return new JavaScriptDataValue(value);
    }
}

