/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.equivalence;

import java.util.Collections;
import java.util.List;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.Edge;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.eventbased.automata.Location;
import org.eclipse.escet.cif.eventbased.automata.OutgoingEdgeIterator;
import org.eclipse.escet.cif.eventbased.equivalence.Block;
import org.eclipse.escet.cif.eventbased.equivalence.BlockLocation;
import org.eclipse.escet.cif.eventbased.equivalence.BlockPartitioner;
import org.eclipse.escet.cif.eventbased.equivalence.CounterExample;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class LangEquivCalculation
extends BlockPartitioner {
    public LangEquivCalculation(List<Automaton> automs) {
        super(automs, true);
        Assert.check((automs.size() == 2 ? 1 : 0) != 0);
    }

    public CounterExample checkLanguageEquivalence() {
        return this.performBlockPartitioning();
    }

    private List<Event> getSplitExplanationPath(Location loc1, Location loc2) {
        List splitPath = Lists.list();
        Location curLoc1 = loc1;
        Location curLoc2 = loc2;
        while (true) {
            Block block2;
            Block block1;
            Assert.check(((block1 = (Block)this.blocks.get(((BlockLocation)this.blockLocs.get((Object)curLoc1)).blockNumber)) != (block2 = (Block)this.blocks.get(((BlockLocation)this.blockLocs.get((Object)curLoc2)).blockNumber)) ? 1 : 0) != 0);
            while (block1.parent != block2.parent) {
                int maxDepth = Math.max(block1.depth, block2.depth);
                if (block1.depth == maxDepth) {
                    block1 = block1.parent;
                }
                if (block2.depth != maxDepth) continue;
                block2 = block2.parent;
            }
            Assert.check((block1 != block2 ? 1 : 0) != 0);
            Assert.check((block1.splitEvent == block2.splitEvent ? 1 : 0) != 0);
            splitPath.add(block1.splitEvent);
            if (block1.splitEvent == null) break;
            Location nextLoc1 = this.getNextLocation(curLoc1, block1.splitEvent);
            Location nextLoc2 = this.getNextLocation(curLoc2, block2.splitEvent);
            Assert.check((nextLoc1 != null || nextLoc2 != null ? 1 : 0) != 0);
            if (nextLoc1 == null || nextLoc2 == null) break;
            curLoc1 = nextLoc1;
            curLoc2 = nextLoc2;
        }
        return splitPath;
    }

    @Override
    protected CounterExample constructCounterExample(Block block, Event finalEvent) {
        List<Event> path = this.getReversePath(block);
        Collections.reverse(path);
        Location[] locs = new Location[2];
        Location[] newLocs = new Location[2];
        locs[0] = ((Automaton)this.automs.get((int)0)).initial;
        locs[1] = ((Automaton)this.automs.get((int)1)).initial;
        int pathIdx = 0;
        while (pathIdx < path.size()) {
            Event evt = path.get(pathIdx);
            newLocs[0] = this.getNextLocation(locs[0], evt);
            newLocs[1] = this.getNextLocation(locs[1], evt);
            if (newLocs[0] == null || newLocs[1] == null) {
                Assert.check((newLocs[0] != null || newLocs[1] != null ? 1 : 0) != 0);
                return new CounterExample(path.subList(0, pathIdx), locs, evt);
            }
            Location[] swap = locs;
            locs = newLocs;
            newLocs = swap;
            ++pathIdx;
        }
        if (finalEvent == null) {
            return new CounterExample(path, locs, null);
        }
        List<Event> splitExplanationPath = this.getSplitExplanationPath(locs[0], locs[1]);
        int i = 0;
        while (i < splitExplanationPath.size() - 1) {
            Event evt = splitExplanationPath.get(i);
            path.add(evt);
            locs[0] = this.getNextLocation(locs[0], evt);
            locs[1] = this.getNextLocation(locs[1], evt);
            Assert.notNull((Object)locs[0]);
            Assert.notNull((Object)locs[1]);
            ++i;
        }
        Event lastExplanationEvent = (Event)Lists.last(splitExplanationPath);
        if (lastExplanationEvent == null) {
            return new CounterExample(path, locs, null);
        }
        int numEventsEnabled = (this.getNextLocation(locs[0], lastExplanationEvent) == null ? 0 : 1) + (this.getNextLocation(locs[1], lastExplanationEvent) == null ? 0 : 1);
        if (numEventsEnabled != 1) {
            Assert.fail();
        }
        return new CounterExample(path, locs, lastExplanationEvent);
    }

    private List<Event> getReversePath(Block blk) {
        List reversePath = Lists.list();
        BlockLocation best = null;
        for (BlockLocation bl : blk.locs) {
            if (best != null && bl.depth >= best.depth) continue;
            best = bl;
        }
        while (best.depth != 0) {
            BlockLocation bestPrev = null;
            Edge bestIncEdge = null;
            for (Edge incEdge : best.loc.getIncoming()) {
                BlockLocation prev = (BlockLocation)this.blockLocs.get(incEdge.srcLoc);
                if (bestPrev != null && bestPrev.depth <= prev.depth) continue;
                bestPrev = prev;
                bestIncEdge = incEdge;
            }
            reversePath.add(bestIncEdge.event);
            best = bestPrev;
        }
        return reversePath;
    }

    private Location getNextLocation(Location loc, Event evt) {
        OutgoingEdgeIterator iter = loc.getOutgoing(evt);
        if (!iter.hasNext()) {
            return null;
        }
        return ((Edge)iter.next()).dstLoc;
    }
}

