/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.cif2cif.LinearizeBase;
import org.eclipse.escet.cif.cif2cif.LocationPointerManager;
import org.eclipse.escet.cif.common.CifEdgeUtils;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifLocationUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeSend;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.automata.impl.EdgeEventImpl;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.VoidType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.ListProductIterator;
import org.eclipse.escet.common.java.Lists;

public class LinearizeProduct
extends LinearizeBase {
    public LinearizeProduct() {
        this(false);
    }

    public LinearizeProduct(boolean optInits) {
        super(optInits);
    }

    @Override
    protected void createEdges(List<Automaton> auts, Automaton mergedAut, Location mergedLoc) {
        List events = Lists.set2list((Set)CifEventUtils.getAlphabet((Automaton)mergedAut));
        LinearizeProduct.linearizeEdges(auts, this.alphabets, events, this.lpIntroducer, true, false, (List<Edge>)mergedLoc.getEdges());
    }

    public static void linearizeEdges(List<Automaton> auts, List<CifEventUtils.Alphabets> alphabets, List<Event> events, LocationPointerManager locPtrManager, boolean removeMonitors, boolean addLocPtrUpdates, List<Edge> linEdges) {
        List syncAlphabets = Lists.listc((int)auts.size());
        List sendAlphabets = Lists.listc((int)auts.size());
        List recvAlphabets = Lists.listc((int)auts.size());
        List moniAlphabets = Lists.listc((int)auts.size());
        for (CifEventUtils.Alphabets autAlphabets : alphabets) {
            syncAlphabets.add(autAlphabets.syncAlphabet);
            sendAlphabets.add(autAlphabets.sendAlphabet);
            recvAlphabets.add(autAlphabets.recvAlphabet);
            moniAlphabets.add(autAlphabets.moniAlphabet);
        }
        List syncAuts = CifEventUtils.filterAutomata(auts, (List)syncAlphabets, events);
        List sendAuts = CifEventUtils.filterAutomata(auts, (List)sendAlphabets, events);
        List recvAuts = CifEventUtils.filterAutomata(auts, (List)recvAlphabets, events);
        List moniAuts = CifEventUtils.filterMonitorAuts(auts, (List)moniAlphabets, events);
        if (removeMonitors) {
            for (Automaton aut : auts) {
                aut.setMonitors(null);
            }
        }
        int i = 0;
        while (i < events.size()) {
            LinearizeProduct.linearizeEdges(events.get(i), (List)syncAuts.get(i), (List)sendAuts.get(i), (List)recvAuts.get(i), (Set)moniAuts.get(i), locPtrManager, addLocPtrUpdates, linEdges);
            ++i;
        }
    }

    private static void linearizeEdges(Event event, List<Automaton> syncAuts, List<Automaton> sendAuts, List<Automaton> recvAuts, Set<Automaton> moniAuts, LocationPointerManager locPtrManager, boolean addLocPtrUpdates, List<Edge> linEdges) {
        boolean isChannel = event.getType() != null;
        boolean isVoid = isChannel && event.getType() instanceof VoidType;
        List syncEdges = Lists.listc((int)syncAuts.size());
        for (Automaton aut : syncAuts) {
            boolean monitor = moniAuts.contains(aut);
            List edges = Lists.list();
            List monitoredLocs = Lists.listc((int)aut.getLocations().size());
            for (Location loc : aut.getLocations()) {
                boolean trueGuard = false;
                for (Iterator edge : loc.getEdges()) {
                    for (EdgeEvent edgeEvent : edge.getEvents()) {
                        Event evt = CifEventUtils.getEventFromEdgeEvent((EdgeEvent)edgeEvent);
                        if (evt != event) continue;
                        if (edge.getGuards().isEmpty()) {
                            trueGuard = true;
                        }
                        edges.add(edgeEvent);
                    }
                }
                if (!monitor || trueGuard) continue;
                monitoredLocs.add(loc);
            }
            if (!monitoredLocs.isEmpty()) {
                edges.add(new MonitorEdgeEvent(monitoredLocs, event));
            }
            syncEdges.add(edges);
        }
        List sendEdges = Lists.list();
        for (Automaton aut : sendAuts) {
            for (Location loc : aut.getLocations()) {
                for (Iterator edge : loc.getEdges()) {
                    for (EdgeEvent edgeEvent : edge.getEvents()) {
                        Iterator evt = CifEventUtils.getEventFromEdgeEvent((EdgeEvent)edgeEvent);
                        if (evt != event) continue;
                        sendEdges.add(edgeEvent);
                    }
                }
            }
        }
        List recvEdges = Lists.list();
        for (Automaton aut : recvAuts) {
            for (Location loc : aut.getLocations()) {
                for (Edge edge : loc.getEdges()) {
                    for (EdgeEvent edgeEvent : edge.getEvents()) {
                        Event evt = CifEventUtils.getEventFromEdgeEvent((EdgeEvent)edgeEvent);
                        if (evt != event) continue;
                        recvEdges.add(edgeEvent);
                    }
                }
            }
        }
        List possibilities = syncEdges;
        if (isChannel) {
            possibilities.add(sendEdges);
            possibilities.add(recvEdges);
        }
        ListProductIterator iter = new ListProductIterator(possibilities);
        while (iter.hasNext()) {
            EdgeEvent edgeEvent;
            List edgeEvents = iter.next();
            List guards = Lists.listc((int)(2 * edgeEvents.size()));
            for (EdgeEvent edgeEvent2 : edgeEvents) {
                LinearizeProduct.addGuards(edgeEvent2, guards, locPtrManager);
            }
            Expression guard = CifValueUtils.createConjunction((List)guards);
            List updates = Lists.list();
            List<Update> rcvUpdates = Lists.list();
            int i = 0;
            while (i < edgeEvents.size()) {
                edgeEvent = (EdgeEvent)edgeEvents.get(i);
                if (isChannel && !isVoid && i == edgeEvents.size() - 1) {
                    LinearizeProduct.addUpdates(edgeEvent, rcvUpdates, addLocPtrUpdates ? locPtrManager : null);
                } else {
                    LinearizeProduct.addUpdates(edgeEvent, updates, addLocPtrUpdates ? locPtrManager : null);
                }
                ++i;
            }
            if (isChannel && !isVoid) {
                int sendIdx = edgeEvents.size() - 2;
                EdgeSend sendEdgeEvt = (EdgeSend)edgeEvents.get(sendIdx);
                Expression sendValue = sendEdgeEvt.getValue();
                rcvUpdates = LinearizeProduct.replaceUpdates(rcvUpdates, sendValue);
                updates.addAll(rcvUpdates);
            }
            EventExpression eventRef = CifConstructors.newEventExpression();
            eventRef.setEvent(event);
            eventRef.setType((CifType)CifConstructors.newBoolType());
            edgeEvent = CifConstructors.newEdgeEvent();
            edgeEvent.setEvent((Expression)eventRef);
            Edge edge = CifConstructors.newEdge();
            edge.getEvents().add((Object)edgeEvent);
            edge.getGuards().add((Object)guard);
            edge.getUpdates().addAll((Collection)updates);
            linEdges.add(edge);
        }
    }

    private static void addGuards(EdgeEvent edgeEvent, List<Expression> guards, LocationPointerManager locPtrManager) {
        if (edgeEvent instanceof MonitorEdgeEvent) {
            MonitorEdgeEvent monitorEdgeEvent = (MonitorEdgeEvent)edgeEvent;
            List<Location> srcLocs = monitorEdgeEvent.locs;
            Event event = monitorEdgeEvent.monitoredEvent;
            List locsGuards = Lists.listc((int)srcLocs.size());
            for (Location srcLoc : srcLocs) {
                List locGuards = Lists.listc((int)4);
                Automaton aut = CifLocationUtils.getAutomaton((Location)srcLoc);
                if (aut.getLocations().size() > 1) {
                    Expression srcRef = locPtrManager.createLocRef(srcLoc);
                    locGuards.add(srcRef);
                }
                for (Edge srcEdge : srcLoc.getEdges()) {
                    for (EdgeEvent srcEdgeEvent : srcEdge.getEvents()) {
                        Event evt = CifEventUtils.getEventFromEdgeEvent((EdgeEvent)srcEdgeEvent);
                        if (evt != event) continue;
                        List edgeGuards = EMFHelper.deepclone((List)srcEdge.getGuards());
                        Expression edgeGuard = CifValueUtils.createConjunction((List)edgeGuards);
                        locGuards.add(CifValueUtils.makeInverse((Expression)edgeGuard));
                    }
                }
                locsGuards.add(CifValueUtils.createConjunction((List)locGuards));
            }
            guards.add(CifValueUtils.createDisjunction((List)locsGuards));
        } else {
            Edge edge = (Edge)edgeEvent.eContainer();
            Location src = CifEdgeUtils.getSource((Edge)edge);
            Automaton aut = (Automaton)src.eContainer();
            if (aut.getLocations().size() > 1) {
                Expression srcRef = locPtrManager.createLocRef(src);
                guards.add(srcRef);
            }
            guards.addAll(EMFHelper.deepclone((List)edge.getGuards()));
        }
    }

    private static void addUpdates(EdgeEvent edgeEvent, List<Update> updates, LocationPointerManager locPtrManager) {
        if (!(edgeEvent instanceof MonitorEdgeEvent)) {
            Location tgtLoc;
            Location srcLoc;
            Edge edge = (Edge)edgeEvent.eContainer();
            updates.addAll(EMFHelper.deepclone((List)edge.getUpdates()));
            if (locPtrManager != null && (srcLoc = CifEdgeUtils.getSource((Edge)edge)) != (tgtLoc = CifEdgeUtils.getTarget((Edge)edge))) {
                updates.add(locPtrManager.createLocUpdate(tgtLoc));
            }
        }
    }

    private static class MonitorEdgeEvent
    extends EdgeEventImpl {
        public final List<Location> locs;
        public final Event monitoredEvent;

        public MonitorEdgeEvent(List<Location> locs, Event monitoredEvent) {
            this.locs = locs;
            this.monitoredEvent = monitoredEvent;
        }
    }
}

