/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.texteditorbase;

import org.eclipse.escet.setext.texteditorbase.ColorManager;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;

public class Style {
    private final RGB foreground;
    private final RGB background;
    private final Font font;
    private final int style;

    public Style(RGB foreground) {
        this(foreground, null, null, 0);
    }

    public Style(int red, int green, int blue) {
        this(new RGB(red, green, blue), null, null, 0);
    }

    public Style(RGB foreground, int style) {
        this(foreground, null, null, style);
    }

    public Style(int red, int green, int blue, int style) {
        this(new RGB(red, green, blue), null, null, style);
    }

    public Style(RGB foreground, RGB background, Font font, int style) {
        this.foreground = foreground;
        this.background = background;
        this.font = font;
        this.style = style;
    }

    public IToken createToken(ColorManager manager) {
        Color f = this.foreground == null ? null : manager.getColor(this.foreground);
        Color b = this.background == null ? null : manager.getColor(this.background);
        TextAttribute attr = new TextAttribute(f, b, this.style, this.font);
        return new Token((Object)attr);
    }
}

