/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm;

import java.util.Collection;
import java.util.List;
import java.util.function.DoublePredicate;
import java.util.stream.IntStream;
import org.apache.commons.math3.linear.RealMatrix;
import org.eclipse.escet.common.dsm.Label;
import org.eclipse.escet.common.java.CsvUtils;
import org.eclipse.escet.common.java.Lists;

public class Dmm {
    public RealMatrix adjacencies;
    public Label[] rowLabels;
    public Label[] columnLabels;

    public Dmm(RealMatrix adjacencies, Label[] rowLabels, Label[] columnLabels) {
        this.adjacencies = adjacencies;
        this.rowLabels = rowLabels;
        this.columnLabels = columnLabels;
    }

    public Dmm(Dmm dmm) {
        this.adjacencies = dmm.adjacencies;
        this.rowLabels = dmm.rowLabels;
        this.columnLabels = dmm.columnLabels;
    }

    public IntStream filterColumn(int column, DoublePredicate pred) {
        return IntStream.range(0, this.adjacencies.getRowDimension()).filter(r -> pred.test(this.adjacencies.getEntry(r, column)));
    }

    public IntStream filterRow(int row, DoublePredicate pred) {
        return IntStream.range(0, this.adjacencies.getColumnDimension()).filter(c -> pred.test(this.adjacencies.getEntry(row, c)));
    }

    public Collection<Label> getColumnLabels(IntStream stream) {
        return (Collection)stream.mapToObj(c -> this.columnLabels[c]).collect(Lists.toList());
    }

    public Collection<Label> getRowLabels(IntStream stream) {
        return (Collection)stream.mapToObj(r -> this.rowLabels[r]).collect(Lists.toList());
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean useRfcEol) {
        List lines = Lists.listc((int)(1 + this.rowLabels.length));
        List lineValues = Lists.listc((int)(1 + this.columnLabels.length));
        lineValues.add("");
        Label[] labelArray = this.columnLabels;
        int n = this.columnLabels.length;
        int n2 = 0;
        while (n2 < n) {
            Label label = labelArray[n2];
            lineValues.add(label.toString());
            ++n2;
        }
        lines.add(lineValues);
        int row = 0;
        while (row < this.rowLabels.length) {
            lineValues = Lists.listc((int)(1 + this.columnLabels.length));
            lineValues.add(this.rowLabels[row].toString());
            int col = 0;
            while (col < this.columnLabels.length) {
                double value = this.adjacencies.getEntry(row, col);
                if ((double)((int)value) == value) {
                    lineValues.add(String.valueOf((int)value));
                } else {
                    lineValues.add(String.valueOf(value));
                }
                ++col;
            }
            lines.add(lineValues);
            ++row;
        }
        return CsvUtils.rowsToString((List)lines, (boolean)useRfcEol);
    }
}

